/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.extension;

import com.wily.util.StringUtils;
import com.wily.util.adt.AttributesStringDictionaryReader;
import com.wily.util.adt.IStringDictionaryReader;
import com.wily.util.exception.UnexpectedExceptionError;
import com.wily.util.extension.AExtension;
import com.wily.util.extension.ExtensionStringLocalizer;
import com.wily.util.extension.IPlugin;
import com.wily.util.extension.InMemoryJarClassLoader;
import com.wily.util.extension.InMemoryJarFile;
import com.wily.util.extension.InvalidExtensionException;
import com.wily.util.extension.JarURLPhysicalModule;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.io.IConstructorExternalizable;
import com.wily.util.text.IStringLocalizer;
import com.wily.util.text.MultipleResourceBundleStringLocalizer;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.List;
import java.util.jar.JarFile;

public class MemoryExtension
extends AExtension
implements IConstructorExternalizable {
    private final InMemoryJarFile fJarFile;
    private String fName;
    private String fClassloaderKey;
    private String fType;
    private int fVersion;
    private List fDependencies;
    private MultipleResourceBundleStringLocalizer fExtensionLocalizer;
    private List fPluginList;
    private ClassLoader fParentLoader;
    private IStringDictionaryReader fAttributesReader;
    private ClassLoader fClassLoader;
    private int fRank;
    private IModuleFeedbackChannel fModuleFeedback;

    public MemoryExtension(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fJarFile = (InMemoryJarFile)in.readObject();
        try {
            super.initialize(this.fJarFile.getName(), this.fJarFile.getMainAttributes());
            this.initialize(null, this.getClass().getClassLoader());
        }
        catch (InvalidExtensionException e) {
            throw new UnexpectedExceptionError(e);
        }
    }

    public MemoryExtension(JarFile jarFile, IModuleFeedbackChannel feedback, ClassLoader parentClassLoader) throws IOException, InvalidExtensionException {
        this.fJarFile = new InMemoryJarFile(jarFile);
        super.initialize(jarFile.getName(), this.fJarFile.getMainAttributes());
        this.initialize(feedback, parentClassLoader);
    }

    private void initialize(IModuleFeedbackChannel feedback, ClassLoader parentClassLoader) throws InvalidExtensionException {
        this.fName = this.getMainAttributeValueOrThrow("com-wily-Extension-Name");
        this.fModuleFeedback = feedback;
        this.fClassloaderKey = this.getMainAttributeValue("com-wily-Extension-Classloader-Key");
        this.fType = this.getMainAttributeValue("com-wily-Extension-Type");
        String commaSeparatedDependencies = this.getMainAttributeValue("com-wily-Extension-depends-on");
        String[] deps = commaSeparatedDependencies == null ? new String[]{} : StringUtils.parseAndTrimList(commaSeparatedDependencies, ",");
        this.fDependencies = Arrays.asList(deps);
        this.fVersion = this.getValidatedVersion();
        this.fPluginList = this.buildPluginList(this, this.getMainAttributeValueOrThrow("com-wily-Extension-Plugins-List"));
        this.fExtensionLocalizer = this.buildStringLocalizer(feedback, parentClassLoader, this.getMainAttributeValue("com-wily-Extension-Localized-Resource-List"));
        this.fAttributesReader = new AttributesStringDictionaryReader(this.fJarFile.getMainAttributes());
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.fJarFile);
    }

    public String IExtension_getName() {
        return this.fName;
    }

    public void IExtension_setParentClassLoader(ClassLoader loader) throws InvalidExtensionException {
        this.fParentLoader = loader = JarURLPhysicalModule.getBundleClassLoaders(this.fModuleFeedback, loader, this.fJarFile);
        this.fClassLoader = new InMemoryJarClassLoader(this.fParentLoader, this.fJarFile);
    }

    public String IExtension_getClassloaderKey() {
        return this.fClassloaderKey;
    }

    public String IExtension_getType() {
        return this.fType;
    }

    public int IExtension_getVersion() {
        return this.fVersion;
    }

    public String IExtension_getSource() {
        return this.fJarFile.getName();
    }

    public String[] IExtension_getDependencies() {
        return this.fDependencies.toArray(new String[0]);
    }

    public ClassLoader IExtension_getClassLoader() {
        return this.fClassLoader;
    }

    public IStringLocalizer IExtension_getStringLocalizer(IStringLocalizer fallback) {
        return new ExtensionStringLocalizer(this.fExtensionLocalizer, fallback);
    }

    public IPlugin[] IExtension_getFilteredPluginList(String pluginFilter) {
        return this.getFilteredPluginList(this.fPluginList, pluginFilter);
    }

    public IStringDictionaryReader IExtension_getAttributes() {
        return this.fAttributesReader;
    }

    public String ITopologicalSortNode_getId() {
        return this.IExtension_getName();
    }

    public String[] ITopologicalSort_getDependencies() {
        return this.IExtension_getDependencies();
    }

    public int ITopologicalSort_getRank() {
        return this.fRank;
    }

    public void ITopologicalSort_setRank(int v) {
        this.fRank = v;
    }
}

