/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.errors.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.feature.ErrorFeature;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.hc2.MethodThrewErrorReportingTracer;
import com.wily.introscope.spec.metric.ESEException;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;

public class WebServicesMethodThrewErrorReportingTracer
extends MethodThrewErrorReportingTracer {
    public WebServicesMethodThrewErrorReportingTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    protected void doFinishTrace(int tracerIndex, InvocationData data) {
        String errMsg = this.constructErrorMessage(data);
        if (this.qualifyingExceptionWasThrown(data) && ErrorFeature.evalErrorQualificationForCurrTxn((IAgent)this.getAgent(), (Throwable)data.getInvocationThrownException(), (String)errMsg)) {
            this.decorateTransactionTraceWithErrorData(data, errMsg);
            IStackElement topElement = data.getVirtualCursor().getTopOfStack();
            if (topElement != data) {
                Throwable error = data.getInvocationThrownException();
                this.incrementErrorMetric(topElement);
                this.constructAndSendErrorSnapshot(topElement, error, errMsg);
            } else {
                this.incrementErrorMetric(data);
                this.constructAndSendErrorSnapshot(data, errMsg);
            }
            data.incrementErrorMetric();
        }
        this.createOwnMetricError(data);
    }

    protected void createOwnMetricError(InvocationData data) {
        Throwable error = data.getInvocationThrownException();
        if (error != null) {
            String component = this.formatParameterizedName(data);
            String errorMessage = String.valueOf(component) + ": " + error.getClass().getName() + ": " + error.getMessage();
            if (ErrorFeature.evalErrorQualificationForCurrTxn((IAgent)this.getAgent(), null, (String)errorMessage)) {
                try {
                    this.getDataAccumulatorFactory().getLongIntervalCounterDataAccumulator(this.getErrorsMetricName(component)).ILongIntervalCounterDataAccumulator_addSingleIncident();
                }
                catch (ESEException eSEException) {
                    Assertion.wilyFail((String)"Metric type conflict");
                }
            }
        }
    }

    protected String getErrorsMetricName(String component) {
        return String.valueOf(component) + ":" + "Errors Per Interval";
    }
}

