/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.correlation;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.trace.correlation.WSCorrelationTracer;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.Field;

public class WebsphereClientHTTPCorrelationTracer
extends WSCorrelationTracer {
    boolean doFinish = true;

    public WebsphereClientHTTPCorrelationTracer(IAgent agent, AttributeListing attributeListing, ProbeIdentification probeIdentification, Object sample) {
        super(agent, attributeListing, probeIdentification, sample);
    }

    public void ITracer_startTrace(int index, InvocationData data) {
        if (!WSMUtils.correlationHTTPInsertionEnabled()) {
            return;
        }
        try {
            Object messageContext;
            Object transportOut;
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug("WebsphereClientHTTPCorrelationTracer:: getInvocationParameterCount=" + data.getInvocationParameterCount());
                int i = 0;
                while (i < data.getInvocationParameterCount()) {
                    this.logger.debug("WebsphereClientHTTPCorrelationTracer::" + data.getInvocationParameterAsObject(i).getClass());
                    ++i;
                }
            }
            if ((transportOut = WSMUtils.invokeMethodOnObject(messageContext = data.getInvocationParameterAsObject(0), "getProperty", new Class[]{String.class}, new Object[]{"TRANSPORT_OUT"})) != null) {
                this.doFinish = false;
                return;
            }
            this.doFinish = true;
            Object sOAPOverHTTPSender = data.getInvocationObject();
            Field hTTPOutSc = sOAPOverHTTPSender.getClass().getDeclaredField("httpOutSC");
            hTTPOutSc.setAccessible(true);
            Object hTTPOutScObject = hTTPOutSc.get(sOAPOverHTTPSender);
            Object hTTPRequestMessage = WSMUtils.invokeMethodOnObject(hTTPOutScObject, "getRequest");
            CorrelationId corIdTmp = new CorrelationId();
            String correlationId = corIdTmp.getOutgoingCorrelationIdStrippedForHeader();
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug("WebsphereClientHTTPCorrelationTracer CorID: " + correlationId);
            }
            WSMUtils.invokeMethodOnObject(hTTPRequestMessage, "setHeader", new Class[]{String.class, String.class}, new Object[]{"CorID", correlationId});
        }
        catch (Throwable bomb) {
            String message = "WebsphereClientHTTPCorrelationTracer ITracer_startTrace exception:  " + bomb;
            WSMUtils.handleException(this.getAgent(), message, bomb);
        }
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        if (!WSMUtils.correlationHTTPInsertionEnabled()) {
            return;
        }
        if (this.doFinish) {
            int correlationCount = new CorrelationId().decrementCorrelationCount();
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug("WebsphereClientHTTPCorrelationTracer ITracer_finishTrace correlationCount=" + correlationCount);
            }
        }
    }
}

