/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.correlation;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.trace.correlation.WSClientCorrelationTracer;
import com.wily.util.properties.AttributeListing;

public class WebsphereJAXWSClientCorrelationTracer
extends WSClientCorrelationTracer {
    boolean doFinish = true;

    public WebsphereJAXWSClientCorrelationTracer(IAgent agent, AttributeListing attributeListing, ProbeIdentification probeIdentification, Object sample) {
        super(agent, attributeListing, probeIdentification, sample);
    }

    public void ITracer_startTrace(int index, InvocationData data) {
        try {
            boolean isHTTPInsertionEnabled = WSMUtils.correlationHTTPInsertionEnabled();
            this.insertHTTPCorrelationInfo(data, isHTTPInsertionEnabled);
            return;
        }
        catch (Throwable bomb) {
            String message = "WebsphereJAXWSClientCorrelationTracer ITracer_startTrace exception:  " + bomb;
            WSMUtils.handleException(this.getAgent(), message, bomb);
            return;
        }
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("WebsphereJAXWSClientCorrelationTracer:: ITracer_finishTrace");
        }
        if (this.doFinish && WSMUtils.correlationSOAPInsertionEnabled()) {
            super.ITracer_finishTrace(tracerIndex, data);
        }
    }

    protected void insertHTTPCorrelationInfo(InvocationData data, boolean isHTTPInsertionEnabled) throws Exception {
        if (isHTTPInsertionEnabled) {
            Object messageContext = data.getInvocationParameterAsObject(0);
            Object transportOut = WSMUtils.invokeMethodOnObject(messageContext, "getProperty", new Class[]{String.class}, new Object[]{"TRANSPORT_OUT"});
            if (transportOut != null) {
                this.doFinish = false;
            }
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug("WebsphereJAXWSClientCorrelationTracer:: doFinish " + this.doFinish);
            }
            Object httpOutSC = WSMUtils.getField(data.getInvocationObject(), "httpOutSC");
            Object httpReqMsg = WSMUtils.invokeMethodOnObject(httpOutSC, "getRequest");
            this.addCorrelationInfoToHttpHeaders(messageContext, httpReqMsg);
        }
    }

    protected void addCorrelationInfoToHttpHeaders(Object messageContext, Object httpReqMsg) throws Exception {
        if (this.doFinish) {
            String correlationId = (String)WSMUtils.invokeMethodOnObject(messageContext, "getProperty", new Class[]{String.class}, new Object[]{"CORRELATION_ID"});
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug("WebsphereJAXWSClientCorrelationTracer HTTP CorID: " + correlationId);
            }
            WSMUtils.invokeMethodOnObject(httpReqMsg, "setHeader", new Class[]{String.class, String.class}, new Object[]{"CorID", correlationId});
        }
    }
}

