/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.nameformatter.cxf;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.INameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.powerpack.webservices.KConstants;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.util.StringUtils;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Map;

public class CXFJaxWSServerNameFormatter
implements INameFormatter,
KConstants {
    private IAgent fAgent;

    public CXFJaxWSServerNameFormatter(IAgent agent) {
        this.fAgent = agent;
    }

    private IAgent getAgent() {
        return this.fAgent;
    }

    public String INameFormatter_format(String name, InvocationData data) {
        try {
            Map mapExchangeInfo;
            if (name.indexOf("{namespace}", 0) >= 0) {
                String namespace = (String)data.get("com.wily.powerpack.webservices.trace.NamespaceKey");
                if (namespace == null) {
                    mapExchangeInfo = (Map)data.getInvocationParameterAsObject(0);
                    Object serviceQName = mapExchangeInfo.get("javax.xml.ws.wsdl.service");
                    namespace = (String)WSMUtils.invokeMethodOnObject(serviceQName, "getNamespaceURI");
                }
                if (namespace == null) {
                    namespace = "UnknownNamespace";
                }
                namespace = CXFJaxWSServerNameFormatter.formatToBeResourceSafe(namespace);
                name = StringUtils.replace((String)name, (String)"{namespace}", (String)namespace);
                data.put("com.wily.powerpack.webservices.trace.NamespaceKey", (Object)namespace);
            }
            if (name.indexOf("{servicename}", 0) >= 0) {
                Map inMessage;
                Object exchangeInfo;
                String serviceName = (String)data.get("com.wily.powerpack.webservices.trace.ServiceNameKey");
                if (serviceName == null && (exchangeInfo = data.getInvocationParameterAsObject(0)) != null && (inMessage = (Map)WSMUtils.invokeMethodOnObject(exchangeInfo, "getInMessage")) != null) {
                    serviceName = (String)inMessage.get("org.apache.cxf.request.url");
                }
                if (serviceName == null) {
                    mapExchangeInfo = (Map)data.getInvocationParameterAsObject(0);
                    serviceName = ((URI)mapExchangeInfo.get("javax.xml.ws.wsdl.description")).toString();
                }
                if (serviceName == null) {
                    serviceName = "UnknownService";
                }
                serviceName = CXFJaxWSServerNameFormatter.formatToBeResourceSafe(serviceName);
                name = StringUtils.replace((String)name, (String)"{servicename}", (String)serviceName);
                data.put("com.wily.powerpack.webservices.trace.NamespaceKey", (Object)serviceName);
            }
            if (name.indexOf("{operationname}", 0) >= 0) {
                String operationName = (String)data.get("com.wily.powerpack.webservices.trace.OperationNameKey");
                if (operationName == null) {
                    operationName = ((Method)data.getInvocationParameterAsObject(2)).getName();
                }
                if (operationName == null) {
                    operationName = "UnknownOperationName";
                }
                operationName = CXFJaxWSServerNameFormatter.formatToBeResourceSafe(operationName);
                name = StringUtils.replace((String)name, (String)"{operationname}", (String)operationName);
                data.put("com.wily.powerpack.webservices.trace.OperationNameKey", (Object)operationName);
            }
        }
        catch (Exception e) {
            WSMUtils.handleException(this.getAgent(), "CXFJaxWSServerNameFormatter INameFormatter_format", e);
        }
        return name;
    }

    public static String formatToBeResourceSafe(String value) {
        return StringUtils.replaceIllegalChars((String)value, (char[])kIllegalResourceChars, (char)'_');
    }
}

