/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.nameformatter.netweaver;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.powerpack.webservices.KConstants;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.trace.nameformatter.IWSNameFormatter;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;

public class WSNameCacheFormatter
implements IWSNameFormatter,
KConstants {
    private final IAgent fAgent;
    private final IModuleFeedbackChannel logger;

    public WSNameCacheFormatter(IAgent agent) {
        this.fAgent = agent;
        this.logger = agent.IAgent_getModuleFeedback();
    }

    public String getNamespace(InvocationData data) {
        String namespaceURI = null;
        try {
            Class<?> cache = data.getInvocationObject().getClass().getClassLoader().loadClass("com.wily.powerpack.webservices.extension.agent.trace.nameformatter.WSNameCache");
            namespaceURI = (String)WSMUtils.invokeMethodOnClass(cache, "getNamespaceURI");
        }
        catch (Throwable e) {
            namespaceURI = "UnknownNamespace";
            WSMUtils.getLogger().error("WSNameCacheFormatter::getNamespace.Unable to getNamespace:" + e);
        }
        return StringUtils.isEmpty((String)namespaceURI) ? "UnknownNamespace" : namespaceURI;
    }

    public String getOperationName(InvocationData data) {
        String operationName = (String)data.getInvocationParameterAsObject(0);
        return StringUtils.isEmpty((String)operationName) ? "UnknownOperationName" : operationName;
    }

    public String getServiceName(InvocationData data) {
        String webserviceName = null;
        try {
            Object runtimeCtx = data.getInvocationParameterAsObject(3);
            Object transport = WSMUtils.invokeMethodOnObject(runtimeCtx, "getTransport");
            webserviceName = (String)WSMUtils.invokeMethodOnObject(transport, "getEntryPointID");
            webserviceName = WSMUtils.formatURLToBeResourceSafe(webserviceName);
        }
        catch (Throwable e) {
            webserviceName = "UnknownService";
            WSMUtils.getLogger().error("WSNameCacheFormatter::getServiceName.Unable to getWebserviceName:" + e);
        }
        return StringUtils.isEmpty((String)webserviceName) ? "UnknownService" : webserviceName;
    }

    protected IAgent getAgent() {
        return this.fAgent;
    }

    public String INameFormatter_format(String name, InvocationData data) {
        String namespace = null;
        String operationName = null;
        String webserviceName = null;
        try {
            if (name != null) {
                if (name.indexOf("{servicename}", 0) >= 0) {
                    webserviceName = this.getServiceName(data);
                    webserviceName = WSMUtils.formatToBeResourceSafe(webserviceName);
                    name = StringUtils.replace((String)name, (String)"{servicename}", (String)webserviceName);
                }
                if (name.indexOf("{namespace}", 0) >= 0) {
                    namespace = this.getNamespace(data);
                    namespace = WSMUtils.formatToBeResourceSafe(namespace);
                    name = StringUtils.replace((String)name, (String)"{namespace}", (String)namespace);
                }
                if (name.indexOf("{operationname}", 0) >= 0) {
                    operationName = this.getOperationName(data);
                    operationName = WSMUtils.formatToBeResourceSafe(operationName);
                    name = StringUtils.replace((String)name, (String)"{operationname}", (String)operationName);
                }
            }
        }
        catch (Exception e) {
            WSMUtils.getLogger().error("WSNameCacheFormatter.INameFormatter_format() Error:" + e);
        }
        return name;
    }
}

