/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.nameformatter.weblogic;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.INameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.powerpack.webservices.KConstants;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.util.StringUtils;
import java.lang.reflect.Field;
import java.util.Map;

public class SyncHandlerNameFormatter
implements INameFormatter,
KConstants {
    private final IAgent agent;
    public static final String kPropertyNamespace = "wily.jaxws.client.namespace";
    public static final String kPropertyOperation = "wily.jaxws.client.operationname";
    public static final String kPropertyEndpoint = "javax.xml.ws.service.endpoint.address";
    public static final String kPropertyWsdlServiceName = "wily.jaxws.client.wsdlservicename";
    public static final String wlVersion = SyncHandlerNameFormatter.getWLVersion();

    public SyncHandlerNameFormatter(IAgent agent) {
        this.agent = agent;
    }

    public String INameFormatter_format(String name, InvocationData data) {
        WSMUtils.getLogger().debug("SyncHandlerFormatter::started");
        if (name == null) {
            WSMUtils.getLogger().debug("INVALID name to format.NULL");
            return null;
        }
        String operationName = null;
        String serviceName = null;
        String namespace = null;
        String wsdlServiceName = null;
        try {
            Object mapViewRc = null;
            WSMUtils.getLogger().debug("SyncHandlerNameFormatter::invObj:" + data.getInvocationObject().getClass().getName());
            WSMUtils.getLogger().debug("SyncHandlerNameFormatter::invObj details:" + data.getInvocationParameterCount() + " " + data.getInvocationParameterAsObject(2).getClass().getName());
            Object objRequestContext = data.getInvocationParameterAsObject(2);
            String versionCheck = "12.1.1";
            if (wlVersion != null) {
                boolean checkVersion = WSMUtils.checkIfVersionQualifies(wlVersion, versionCheck);
                if (checkVersion) {
                    if (WSMUtils.getLogger().isDebugEnabled()) {
                        WSMUtils.getLogger().debug("looking for method asMap in RequestContext");
                    }
                    mapViewRc = WSMUtils.invokeMethodOnObject(objRequestContext, "asMap");
                } else {
                    if (WSMUtils.getLogger().isDebugEnabled()) {
                        WSMUtils.getLogger().debug("looking for method getmapview in RequestContext");
                    }
                    mapViewRc = WSMUtils.invokeMethodOnObject(objRequestContext, "getMapView");
                }
            } else {
                if (WSMUtils.getLogger().isDebugEnabled()) {
                    WSMUtils.getLogger().debug("taking the default approach and looking for method getmapview in RequestContext");
                }
                mapViewRc = WSMUtils.invokeMethodOnObject(objRequestContext, "getMapView");
            }
            Map mapRequestContext = (Map)mapViewRc;
            if (name.indexOf("{servicename}", 0) >= 0) {
                serviceName = (String)mapRequestContext.get(kPropertyEndpoint);
                if (serviceName == null) {
                    serviceName = "UnknownService";
                }
                serviceName = WSMUtils.formatToBeResourceSafe(serviceName);
                data.put("com.wily.powerpack.webservices.trace.NamespaceKey", (Object)serviceName);
                WSMUtils.getLogger().debug("SyncHandlerNameFormatter::serviceName:" + serviceName);
                name = StringUtils.replace((String)name, (String)"{servicename}", (String)serviceName);
            }
            if (name.indexOf("{wsdlservicename}", 0) >= 0) {
                wsdlServiceName = (String)mapRequestContext.get(kPropertyWsdlServiceName);
                if (wsdlServiceName == null) {
                    wsdlServiceName = "UnknownService";
                }
                wsdlServiceName = WSMUtils.formatToBeResourceSafe(wsdlServiceName);
                data.put("com.wily.powerpack.webservices.trace.NamespaceKey", (Object)wsdlServiceName);
                WSMUtils.getLogger().debug("SyncHandlerNameFormatter::wsdlServiceName:" + wsdlServiceName);
                name = StringUtils.replace((String)name, (String)"{wsdlservicename}", (String)wsdlServiceName);
            }
            if (name.indexOf("{namespace}", 0) >= 0) {
                namespace = (String)mapRequestContext.get(kPropertyNamespace);
                if (namespace == null) {
                    namespace = serviceName;
                }
                namespace = WSMUtils.formatToBeResourceSafe(namespace);
                data.put("com.wily.powerpack.webservices.trace.NamespaceKey", (Object)namespace);
                WSMUtils.getLogger().debug("SyncHandlerNameFormatter::NameSpace:" + namespace);
                name = StringUtils.replace((String)name, (String)"{namespace}", (String)namespace);
            }
            if (name.indexOf("{operationname}", 0) >= 0) {
                operationName = (String)mapRequestContext.get(kPropertyOperation);
                if (operationName == null) {
                    operationName = "UnknownOperationName";
                }
                operationName = WSMUtils.formatToBeResourceSafe(operationName);
                data.put("com.wily.powerpack.webservices.trace.OperationNameKey", (Object)operationName);
                name = StringUtils.replace((String)name, (String)"{operationname}", (String)operationName);
            }
        }
        catch (Exception e) {
            this.agent.IAgent_getModuleFeedback().error((Throwable)e);
        }
        WSMUtils.getLogger().debug("SyncHandlerFormatter::ended");
        return name;
    }

    private static final String getWLVersion() {
        String Version;
        block4: {
            Version = null;
            if (wlVersion == null) {
                Class<?> wlVersionClass = null;
                try {
                    wlVersionClass = Class.forName("weblogic.common.internal.Version", false, ClassLoader.getSystemClassLoader());
                    Field versionField = wlVersionClass.getDeclaredField("VERSION_STRING");
                    versionField.setAccessible(true);
                    Version = (String)versionField.get(wlVersionClass);
                    if (WSMUtils.getLogger().isDebugEnabled()) {
                        WSMUtils.getLogger().debug("Found weblogic version " + wlVersion);
                    }
                }
                catch (Exception e) {
                    if (!WSMUtils.getLogger().isDebugEnabled()) break block4;
                    WSMUtils.getLogger().debug("Error in getting weblogic version " + e);
                }
            }
        }
        return Version;
    }
}

