/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.nameformatter.websphere;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.powerpack.webservices.KConstants;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.trace.nameformatter.JAXWSNameFormatter;
import java.util.Map;

public class JAXWSAsynchClientFormatter
extends JAXWSNameFormatter
implements KConstants {
    public JAXWSAsynchClientFormatter(IAgent agent) {
        super(agent);
    }

    public final String getServiceName(InvocationData data) {
        try {
            Object listenerObj = data.getInvocationObject();
            Object handlerObj = WSMUtils.invokeMethodOnObject(listenerObj, "getHandler");
            Object objRequestContext = WSMUtils.invokeMethodOnObject(handlerObj, "getRequestContext");
            Map mapRequestContext = (Map)objRequestContext;
            this.serviceName = (String)mapRequestContext.get("javax.xml.ws.service.endpoint.address");
            this.logger.debug("mapRequestContext:" + mapRequestContext);
            this.logger.debug("serviceName:" + this.serviceName);
            this.logger.debug("JAXWSProxyHandlerNameFormatter.getServiceName()");
            if (this.serviceName == null) {
                this.serviceName = "UnknownService";
            }
        }
        catch (Exception exception) {
            return "UnknownService";
        }
        return this.serviceName;
    }

    public final String getOperationName(InvocationData data) {
        Object listenerObj = data.getInvocationObject();
        try {
            Object handlerObj = WSMUtils.invokeMethodOnObject(listenerObj, "getHandler");
            Map reqctxtobj = (Map)WSMUtils.invokeMethodOnObject(handlerObj, "getRequestContext");
            Object opNameObj = reqctxtobj.get("soa_asynch_opname");
            if (opNameObj != null) {
                return opNameObj.toString();
            }
            return "UnknownOperationName";
        }
        catch (Throwable e) {
            this.logger.info("ClientAsynchTracer:Error in retreiving from request context", e);
            return "UnknownOperationName";
        }
    }

    public final String getNamespace(InvocationData data) {
        try {
            Object listenerObj = data.getInvocationObject();
            Object handlerObj = WSMUtils.invokeMethodOnObject(listenerObj, "getHandler");
            Object objServiceDelegate = WSMUtils.invokeMethodOnObject(handlerObj, "getServiceDelegate");
            Object serviceQName = WSMUtils.invokeMethodOnObject(objServiceDelegate, "getServiceName");
            this.namespace = (String)WSMUtils.invokeMethodOnObject(serviceQName, "getNamespaceURI()");
            if (this.namespace != null) {
                return this.namespace;
            }
            return this.getServiceName(data);
        }
        catch (Exception exception) {
            return this.getServiceName(data);
        }
    }
}

