/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.websphere.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.feature.FaultFeature;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ProbeInformation;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.cas.IBlameTransactionElement;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.hc2.WilyTransactionElement;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.trace.hc2.WebServiceBlamePointTracer;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.AttributeListing;
import java.util.HashMap;

public class ClientAsyncFaultTracer
extends WebServiceBlamePointTracer {
    protected final IModuleFeedbackChannel logger;

    public ClientAsyncFaultTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.logger = agent.IAgent_getModuleFeedback();
    }

    protected WilyTransactionElement constructTransactionElement(Object key, String metricName, int blameStatus, boolean isStartTrace, ITransactionElement parent, IBlameTransactionElement previous, IBlameTransactionElement start, ProbeInformation probeInformation) {
        HashMap metrics = new HashMap(5);
        IRepository concurrentSds = null;
        IRepository timerSds = null;
        IRepository stallSds = null;
        IRepository errorsSds = null;
        IRepository perIntervalSds = null;
        AgentMetric[] faultMetric = this.createFaultsMetric(this.getFormattedMetricName(metricName));
        return FaultFeature.createFaultedBlameTransactionElement((Object)key, (String)metricName, (int)blameStatus, (boolean)true, (ITransactionElement)parent, (IBlameTransactionElement)previous, null, metrics, timerSds, perIntervalSds, concurrentSds, errorsSds, stallSds, (ProbeInformation)probeInformation, (AgentMetric[])faultMetric, (boolean)this.subscribeToDownstreamErrors(), (boolean)this.subscribeToDownstreamStalls(), (boolean)this.subscribeToDownstreamFaults());
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("START:ClientAsyncFaultTracer.ITracer_finishTrace()");
        }
        try {
            Throwable error = (Throwable)data.getInvocationParameterAsObject(0);
            Object objCoreMessageContext = data.getInvocationParameterAsObject(1);
            Object objAxisMessageContext = WSMUtils.invokeMethodOnObject(objCoreMessageContext, "getAxisMessageContext");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("objAxisMessageContext:" + objAxisMessageContext);
            }
            Boolean isFault = (Boolean)WSMUtils.invokeMethodOnObject(objAxisMessageContext, "isFault");
            data.put("isFault", (Object)isFault);
            if (isFault != null && isFault.booleanValue()) {
                String faultMessage = "SOAP Fault:: " + error.toString();
                data.put("faultMessage", (Object)faultMessage);
            }
        }
        catch (Exception exFault) {
            this.logger.error((Throwable)exFault);
        }
        super.ITracer_finishTrace(tracerIndex, data);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("END:ClientAsyncFaultTracer.ITracer_finishTrace()");
        }
    }

    protected void updateCustomMetricsIfAny(WilyTransactionElement start, InvocationData data) {
        boolean isFault = (Boolean)data.get("isFault");
        if (isFault) {
            FaultFeature.incrementFaultMetric((InvocationData)data);
            String faultMessage = (String)data.get("faultMessage");
            if (faultMessage != null) {
                FaultFeature.constructAndSendFaultSnapshotToServer((InvocationData)data, (String)faultMessage, (IAgent)this.getAgent());
                FaultFeature.decorateTransactionsWithFault((InvocationData)data, (String)faultMessage);
            }
        }
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        super.doStartBlamePointTrace(tracerIndex, data);
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }
}

