/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.handlers.weblogic10;

import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.trace.nameformatter.WSNameCache;
import com.wily.powerpack.webservices.handlers.SimpleServiceDeserializer;
import com.wily.powerpack.webservices.handlers.WsdmGenericHandler;
import com.wily.powerpack.webservices.handlers.WsdmHandlerUtil;
import com.wily.powerpack.webservices.handlers.WsdmLogger;
import com.wily.powerpack.webservices.handlers.WsdmMessageContext;
import com.wily.util.properties.IndexedProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdmJAXWSHandler
implements SOAPHandler<SOAPMessageContext> {
    public static final String CORRELATION_ID_NAME = "WSCorIDSOAPHeader";
    public static final String CORRELATION_NAMESPACE = "http://www.wilytech.com/";
    public static final String CORRELATION_ATTR_NAME = "CorID";
    public static final String CORRELATION_ID_KEY = "CorIDForSOAPInvocation";
    public static final String kWSDMClientObservationType = "2";
    public static final String kWSDMServerObservationType = "1";
    public WsdmHandlerUtil wsdmHandlerUtil = null;
    private Integer observationType = new Integer(0);
    protected static final String KEY_TRANS_ID = "WSDM_TRANSID";
    private static final String kWaitPeriodWSDMHandlerProperty = "waitPeriod";
    private static final String kWaitPeriodWSDMHandlerPropertyKey = "com.wily.powerpack.SOA.waitPeriod";
    private static final String kQueueSizeMinWSDMHandlerProperty = "queueSizeMin";
    private static final String kQueueSizeMinWSDMHandlerPropertyKey = "com.wily.powerpack.SOA.queueSizeMin";
    private static final String kQueueSizeMaxWSDMHandlerProperty = "queueSizeMax";
    private static final String kQueueSizeMaxWSDMHandlerPropertyKey = "com.wily.powerpack.SOA.queueSizeMax";
    private static final String kBlockUnknownWSDMHandlerProperty = "blockUnknown";
    private static final String kBlockUnknownWSDMHandlerPropertyKey = "com.wily.powerpack.SOA.blockUnknown";
    private static final String kLogSoapWSDMHandlerProperty = "logSoap";
    private static final String kLogSoapWSDMHandlerPropertyKey = "com.wily.powerpack.SOA.logSoap";
    private static final String kScopeWSDMHandlerProperty = "scope";
    private static final String kScopeWSDMHandlerPropertyKey = "com.wily.powerpack.SOA.scope";
    private static final String kRelInofPingSecondsWSDMHandlerProperty = "relInfoPingSeconds";
    private static final String kRelInofPingSecondsWSDMHandlerPropertyKey = "com.wily.powerpack.SOA.relInfoPingSeconds";
    private static final String kAutoDiscoverWSDMHandlerProperty = "autoDiscover";
    private static final String kAutoDiscoverWSDMHandlerPropertyKey = "com.wily.powerpack.SOA.autoDiscover";
    private static final String kSendSoapWSDMHandlerProperty = "sendSoap";
    private static final String kSendSoapWSDMHandlerPropertyKey = "com.wily.powerpack.SOA.sendSoap";
    private static final String kAgentOnlyWSDMHandlerProperty = "SOAManagerCore";
    private static final String kAgentOnlyWSDMHandlerPropertyKey = "com.wily.powerpack.SOA.SOAManagerCore";
    private static final String kObservationTypeWSDMHandlerProperty = "observationType";
    private static final String kSoapMessageSizeWSDMHandlerProperty = "soapMessageSize";
    private static final String kSoapMessageSizeWSDMHandlerPropertyKey = "com.wily.powerpack.SOA.soapMessageSize";
    protected static WsdmLogger log = new WsdmLogger();

    void init() {
    }

    public void mapDependency() {
    }

    void init(String observerType) {
        block2: {
            log.debug("WsdmJAXWSHandler::init: observertype=" + observerType);
            try {
                this.wsdmInit(observerType);
            }
            catch (Throwable e) {
                log.error("WsdmJAXWSHandler::init: " + e);
                if (!log.isDebugLogging().booleanValue()) break block2;
                log.debug("WsdmJAXWSHandler::init: " + WSMUtils.dumpStackTrace(e));
            }
        }
    }

    private void wsdmInit(String observerType) {
        log.debug("WsdmJAXWSHandler::wsdminit observertype=" + observerType);
        this.setObservationType(observerType);
        this.wsdmHandlerUtil = WsdmHandlerUtil.getWsdmHandlerUtil();
    }

    private void wsdmInit() {
        String className = this.getClass().getName();
        if (className.equals("com.wily.powerpack.webservices.handlers.WsdmClientJAXWSHandler")) {
            this.wsdmInit(kWSDMClientObservationType);
        } else {
            this.wsdmInit(kWSDMServerObservationType);
        }
    }

    void destroy() {
    }

    public void close(MessageContext SOAPMessageContext2) {
    }

    private static Hashtable<String, String> getWSDMHandlerConfig(IndexedProperties props) {
        Hashtable<String, String> config = new Hashtable<String, String>();
        String value = props.getProperty(kWaitPeriodWSDMHandlerPropertyKey);
        if (value != null) {
            config.put(kWaitPeriodWSDMHandlerProperty, value);
        }
        if ((value = props.getProperty(kQueueSizeMinWSDMHandlerPropertyKey)) != null) {
            config.put(kQueueSizeMinWSDMHandlerProperty, value);
        }
        if ((value = props.getProperty(kQueueSizeMaxWSDMHandlerPropertyKey)) != null) {
            config.put(kQueueSizeMaxWSDMHandlerProperty, value);
        }
        if ((value = props.getProperty(kBlockUnknownWSDMHandlerPropertyKey)) != null) {
            config.put(kBlockUnknownWSDMHandlerProperty, value);
        }
        if ((value = props.getProperty(kLogSoapWSDMHandlerPropertyKey)) != null) {
            config.put(kLogSoapWSDMHandlerProperty, value);
        }
        if ((value = props.getProperty(kScopeWSDMHandlerPropertyKey)) != null) {
            config.put(kScopeWSDMHandlerProperty, value);
        }
        if ((value = props.getProperty(kRelInofPingSecondsWSDMHandlerPropertyKey)) != null) {
            config.put(kRelInofPingSecondsWSDMHandlerProperty, value);
        }
        if ((value = props.getProperty(kAutoDiscoverWSDMHandlerPropertyKey)) != null) {
            config.put(kAutoDiscoverWSDMHandlerProperty, value);
        }
        if ((value = props.getProperty(kSendSoapWSDMHandlerPropertyKey)) != null) {
            config.put(kSendSoapWSDMHandlerProperty, value);
        }
        if ((value = props.getProperty(kAgentOnlyWSDMHandlerPropertyKey)) != null) {
            config.put(kAgentOnlyWSDMHandlerProperty, value);
        }
        if ((value = props.getProperty(kSoapMessageSizeWSDMHandlerPropertyKey)) != null) {
            config.put(kSoapMessageSizeWSDMHandlerProperty, value);
        }
        return config;
    }

    private void setCorrelationIdInHeader(SOAPHeader header, String correlationId, Name attrName) {
        block3: {
            try {
                if (header != null) {
                    SOAPElement headerElement = header.addChildElement(CORRELATION_ID_NAME, "", CORRELATION_NAMESPACE);
                    headerElement.addAttribute(attrName, correlationId);
                    headerElement.addNamespaceDeclaration("", CORRELATION_NAMESPACE);
                }
            }
            catch (SOAPException se) {
                log.error("WsdmJAXWSHandler::setCorrelationIdInHeader cannot set header " + (Object)((Object)se));
                if (!log.isDebugLogging().booleanValue()) break block3;
                log.debug("WsdmJAXWSHandler::setCorrelationIdInHeader: " + WSMUtils.dumpStackTrace(se));
            }
        }
    }

    public boolean handleMessage(SOAPMessageContext soapMessageContext) {
        try {
            if (log.isDebugLogging().booleanValue()) {
                log.debug("In Handle Message " + this.getClass().getName());
            }
            if (this.getObservationType() == 0) {
                this.wsdmInit();
            }
            Boolean outbound = (Boolean)soapMessageContext.get((Object)"javax.xml.ws.handler.message.outbound");
            if (this.getClass().getName().equals("com.ca.wsdm.handlers.WsdmServerJAXWSHandler")) {
                if (outbound.booleanValue()) {
                    return this.wsdmHandleResponse(soapMessageContext);
                }
                return this.wsdmHandleRequest(soapMessageContext);
            }
            if (outbound.booleanValue()) {
                return this.wsdmHandleRequest(soapMessageContext);
            }
            return this.wsdmHandleResponse(soapMessageContext);
        }
        catch (Throwable e) {
            log.error("WsdmJAXWSHandler::handleMessage" + e);
            if (log.isDebugLogging().booleanValue()) {
                log.debug("WsdmJAXWSHandler::handleMessage: " + WSMUtils.dumpStackTrace(e));
            }
            return true;
        }
    }

    public boolean handleFault(SOAPMessageContext soapMessageContext) {
        block8: {
            WsdmMessageContext wsdmMessageContext;
            block7: {
                block6: {
                    if (this.getObservationType() == 2) {
                        int correlationCount = new CorrelationId().decrementCorrelationCount();
                        log.debug("WsdmJAXWSHandler handleFault correlationCount=" + correlationCount);
                    }
                    wsdmMessageContext = this.setupTransactionId((MessageContext)soapMessageContext);
                    if (log.isDebugLogging().booleanValue()) {
                        log.debug("WsdmJAXWSHandler::handleFault: wsdmMessageContext =" + wsdmMessageContext + "soapMessageContext=" + soapMessageContext);
                    }
                    if (wsdmMessageContext.getOperationNameSpace() != null && !wsdmMessageContext.getOperationNameSpace().equals("")) break block6;
                    log.error("WsdmJAXWSHandler::handleFault: unable to get serviceName");
                    return true;
                }
                if (wsdmMessageContext.getOperationName() != null && !wsdmMessageContext.getOperationName().equals("")) break block7;
                log.error("WsdmJAXWSHandler::handleFault: unable to get operationName");
                return true;
            }
            try {
                this.processSoapFault(wsdmMessageContext, soapMessageContext);
            }
            catch (Throwable e) {
                log.error("WsdmJAXWSHandler::handleFault: Failed to handle fault: " + e);
                if (!log.isDebugLogging().booleanValue()) break block8;
                log.debug("WsdmJAXWSHandler::handleFault: " + WSMUtils.dumpStackTrace(e));
            }
        }
        return true;
    }

    protected void processSoapFault(WsdmMessageContext wsdmMessageContext, SOAPMessageContext soapMessageContext) {
        block2: {
            SOAPMessage soapMess = soapMessageContext.getMessage();
            try {
                this.sendoutSoapFaultInfo(soapMess.getSOAPPart().getEnvelope().getBody().getFault(), wsdmMessageContext);
            }
            catch (SOAPException e) {
                log.error("WsdmJAXWSHandler::processSoapFault: unable to send fault information: " + (Object)((Object)e));
                if (!log.isDebugLogging().booleanValue()) break block2;
                log.debug("WsdmJAXWSHandler::processSoapFault: " + WSMUtils.dumpStackTrace(e));
            }
        }
    }

    private void processCorrelationId(int observationType, SOAPEnvelope envelope) throws SOAPException {
        SOAPHeader header = envelope.getHeader();
        Name attrName = envelope.createName(CORRELATION_ATTR_NAME);
        if (this.getObservationType() == 1) {
            boolean correlationIdFound = false;
            if (header != null) {
                Iterator it = header.getChildElements();
                while (it.hasNext()) {
                    SOAPHeaderElement headerElement;
                    String headerName;
                    Object ChildElement = it.next();
                    if (!(ChildElement instanceof SOAPHeaderElement) || !(headerName = (headerElement = (SOAPHeaderElement)ChildElement).getElementName().getLocalName()).equals(CORRELATION_ID_NAME)) continue;
                    correlationIdFound = true;
                    String correlationId = headerElement.getAttributeValue(attrName);
                    new CorrelationId(correlationId);
                    break;
                }
            }
            if (!correlationIdFound) {
                new CorrelationId();
            }
            return;
        }
        if (this.getObservationType() == 2) {
            String correlationId = new CorrelationId().getOutgoingCorrelationIdStrippedForHeader();
            if (header == null) {
                header = envelope.addHeader();
            }
            this.setCorrelationIdInHeader(header, correlationId, attrName);
        } else {
            log.error("WsdmJAXWSHandler::processCorrelationId: observationType is not set");
        }
    }

    protected String getXMLStringFromSOAPElement(SOAPElement se) {
        if (se == null) {
            return "";
        }
        StringBuffer soapStringBuffer = new StringBuffer();
        soapStringBuffer.append("<" + se.getElementName().getQualifiedName() + " ");
        Iterator envAttrs = se.getAllAttributes();
        while (envAttrs.hasNext()) {
            Name attrName = (Name)envAttrs.next();
            soapStringBuffer.append(" " + attrName.getQualifiedName() + "=\"" + se.getAttributeValue(attrName) + "\" ");
        }
        Iterator envNameSpaces = se.getNamespacePrefixes();
        while (envNameSpaces.hasNext()) {
            String nameSpacePrefix = (String)envNameSpaces.next();
            soapStringBuffer.append(" xmlns:" + nameSpacePrefix + "=\"" + se.getNamespaceURI(nameSpacePrefix) + "\" ");
        }
        soapStringBuffer.append(">");
        if (se.getValue() != null && !se.getValue().equals("")) {
            soapStringBuffer.append(se.getValue());
        } else {
            Iterator children = se.getChildElements();
            while (children.hasNext()) {
                Object childElement = children.next();
                if (!(childElement instanceof SOAPElement)) continue;
                soapStringBuffer.append(this.getXMLStringFromSOAPElement((SOAPElement)childElement));
            }
        }
        soapStringBuffer.append("</" + se.getElementName().getQualifiedName() + ">");
        return soapStringBuffer.toString();
    }

    protected String walkEnvelope(SOAPEnvelope env) {
        if (env == null) {
            return "";
        }
        SOAPHeader header = null;
        try {
            header = env.getHeader();
        }
        catch (SOAPException sOAPException) {
            header = null;
        }
        String headerStr = "";
        if (header != null) {
            headerStr = header.toString();
        }
        SOAPBody soapBody = null;
        try {
            soapBody = env.getBody();
        }
        catch (SOAPException sOAPException) {
            soapBody = null;
        }
        StringBuffer bodyStr = new StringBuffer(headerStr);
        if (soapBody != null) {
            Iterator iter = soapBody.getChildElements();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (!(element instanceof SOAPBodyElement)) continue;
                SOAPBodyElement el = (SOAPBodyElement)element;
                bodyStr.append(el.toString());
            }
        }
        return bodyStr.toString();
    }

    private boolean wsdmHandleRequest(SOAPMessageContext context) {
        HttpServletRequest req;
        WsdmMessageContext wsdmMessageContext = new WsdmMessageContext(this.getObservationType());
        if (log.isDebugLogging().booleanValue()) {
            log.debug("WsdmJAXWSHandler::wsdmHandleRequest");
        }
        if ((req = (HttpServletRequest)context.get((Object)"javax.xml.ws.servlet.request")) != null) {
            this.setPortName(wsdmMessageContext, req);
            wsdmMessageContext.setRequestorLocation(req.getRemoteAddr());
        } else if (log.isDebugLogging().booleanValue()) {
            log.debug("WsdmJAXWSHandler::wsdmHandleRequest: request== null response = " + context.get((Object)"javax.xml.ws.servlet.response"));
        }
        return this.processRequestSOAP(wsdmMessageContext, context);
    }

    protected boolean processRequestSOAP(WsdmMessageContext wsdmMessageContext, SOAPMessageContext context) {
        SOAPEnvelope se;
        block10: {
            SOAPMessage soapMess = context.getMessage();
            se = null;
            SOAPPart sp = null;
            try {
                if (soapMess != null) {
                    sp = soapMess.getSOAPPart();
                    if (sp != null && (se = sp.getEnvelope()) != null) {
                        this.processCorrelationId(wsdmMessageContext.getObservationType(), se);
                    }
                    break block10;
                }
                log.error("WsdmJAXWSHandler::processRequestSOAP: SoapMess is null");
                return true;
            }
            catch (SOAPException e) {
                log.error("WsdmJAXWSHandler::processRequestSOAP: " + (Object)((Object)e));
                if (log.isDebugLogging().booleanValue()) {
                    log.debug("WsdmJAXWSHandler::processRequestSOAP: " + WSMUtils.dumpStackTrace(e));
                }
                return true;
            }
        }
        if (wsdmMessageContext.getOperationNameSpace() == null || wsdmMessageContext.getOperationNameSpace().equals("")) {
            String tempinputString;
            block11: {
                if (log.isDebugLogging().booleanValue()) {
                    log.debug("WsdmJAXWSHandler::processRequestSOAP: OperationNameSpace not found, attempt to extract from SOAP Element");
                }
                tempinputString = null;
                try {
                    tempinputString = this.getXMLStringFromSOAPElement((SOAPElement)se.getBody());
                }
                catch (Exception cce) {
                    if (!log.isDebugLogging().booleanValue()) break block11;
                    log.debug("WsdmJAXWSHandler::processRequestSOAP: " + cce);
                }
            }
            this.getServiceOperationNameFromSoapBody(tempinputString, wsdmMessageContext);
        }
        this.wsdmHandlerUtil.observeRequest(wsdmMessageContext);
        context.put((Object)KEY_TRANS_ID, (Object)wsdmMessageContext);
        log.debug("WsdmJAXWSHandler::processRequestSOAP before  WsdmHandlerUtil.CLIENT_OBSERVATION_TYPE");
        if (this.getObservationType() == 2) {
            log.debug("WsdmJAXWSHandler::processRequestSOAP in WsdmHandlerUtil.CLIENT_OBSERVATION_TYPE");
            this.setNameCache(wsdmMessageContext.getOperationName(), wsdmMessageContext.getOperationNameSpace());
            WsdmGenericHandler wsdmGenericHandler = new WsdmGenericHandler();
            wsdmGenericHandler.mapDependency();
        }
        return true;
    }

    protected boolean wsdmHandleResponse(SOAPMessageContext context) {
        WsdmMessageContext wsdmMessageContext;
        if (this.getObservationType() == 2) {
            int correlationCount = new CorrelationId().decrementCorrelationCount();
            log.debug("WsdmJAXWSHandler wsdmHandleResponse correlationCount=" + correlationCount);
        }
        if ((wsdmMessageContext = (WsdmMessageContext)context.get((Object)KEY_TRANS_ID)) == null) {
            if (log.isDebugLogging().booleanValue()) {
                log.debug("WsdmJAXWSHandler::wsdmHandleResponse: response not found, creating new one");
            }
            wsdmMessageContext = new WsdmMessageContext(this.getObservationType());
        }
        this.setNameCache(wsdmMessageContext.getOperationName(), wsdmMessageContext.getOperationNameSpace());
        context.getMessage();
        this.wsdmHandlerUtil.observeResponse(wsdmMessageContext);
        return true;
    }

    protected String dumpStackTrace(Throwable t) {
        StackTraceElement[] e = t.getStackTrace();
        String ret = "\nstack trace:";
        int i = 0;
        while (i < e.length) {
            ret = String.valueOf(ret) + e[i] + "\n";
            ++i;
        }
        return ret;
    }

    public Set<QName> getHeaders() {
        return Collections.emptySet();
    }

    protected void getServiceOperationNameFromSoapBody(String inputString, WsdmMessageContext context) {
        block8: {
            if (WSMUtils.xmlParsingEnabled()) {
                if (log.isDebugLogging().booleanValue()) {
                    log.debug("WsdmJAXWSHandler: xml parsing is enabled, attempting to getOperationNamespaceFromSoapBody");
                    log.debug("WsdmJAXWSHandler::getServiceOperationNameFromSoapBody: inputString= " + inputString);
                }
                SimpleServiceDeserializer ssd = new SimpleServiceDeserializer(inputString);
                try {
                    ssd.parse();
                    context.setOperationNameSpace(ssd.getServiceName().trim());
                    context.setOperationName(ssd.getOperationName().trim());
                }
                catch (SAXException e) {
                    log.error("WsdmJAXWSHandler::getServiceOperationNameFromSoapBody: " + e);
                    if (log.isDebugLogging().booleanValue()) {
                        log.debug("WsdmJAXWSHandler::getServiceOperationNameFromSoapBody: " + WSMUtils.dumpStackTrace(e));
                    }
                    break block8;
                }
                catch (Exception e) {
                    log.error("WsdmJAXWSHandler::getServiceOperationNameFromSoapBody: " + e);
                    if (log.isDebugLogging().booleanValue()) {
                        log.debug("WsdmJAXWSHandler::getServiceOperationNameFromSoapBody: " + WSMUtils.dumpStackTrace(e));
                    }
                    break block8;
                }
            }
            if (log.isDebugLogging().booleanValue()) {
                log.debug("WsdmJAXWSHandler: xml parsing is disabled, will NOT attempt to getOperationNamespaceFromSoapBody");
            }
        }
    }

    protected void sendoutSoapFaultInfo(SOAPFault soapFault, WsdmMessageContext context) {
        Detail detail;
        if (soapFault == null) {
            return;
        }
        String[] sarr = null;
        if (soapFault.getDetail() != null && (detail = soapFault.getDetail()) != null) {
            Iterator it = detail.getDetailEntries();
            ArrayList<String> listDetailEntries = new ArrayList<String>();
            if (it != null) {
                while (it.hasNext()) {
                    DetailEntry entry = (DetailEntry)it.next();
                    if (entry == null) continue;
                    listDetailEntries.add(entry.getValue());
                }
            }
            sarr = listDetailEntries.toArray(new String[listDetailEntries.size()]);
        }
        this.wsdmHandlerUtil.spoolFault(context, soapFault.getFaultActor(), soapFault.getFaultCode().toString(), soapFault.getFaultString(), sarr);
    }

    protected void setPortName(WsdmMessageContext wsdmMessageContext, HttpServletRequest req) {
        if (req != null) {
            if (log.isDebugLogging().booleanValue()) {
                log.debug("setPortName" + req.getPathInfo() + ":" + req.getServletPath() + ":" + req.getRequestURL() + ":" + req.getPathInfo() + ":" + req.getContextPath());
            }
            if (req.getServerPort() == 80) {
                wsdmMessageContext.setPortName("http://" + req.getServerName() + req.getRequestURI());
            } else {
                wsdmMessageContext.setPortName("http://" + req.getServerName() + ":" + req.getServerPort() + req.getRequestURI());
            }
        }
    }

    protected WsdmMessageContext setupTransactionId(MessageContext context) {
        WsdmMessageContext wsdmMessageContext = null;
        if (context.containsKey((Object)KEY_TRANS_ID)) {
            wsdmMessageContext = (WsdmMessageContext)context.get((Object)KEY_TRANS_ID);
        }
        return wsdmMessageContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getObservationType() {
        if (log.isDebugLogging().booleanValue()) {
            log.debug("WsdmJAXWSHandler::getObservationType is " + (this.observationType == null ? "null" : this.observationType));
        }
        Integer n = this.observationType;
        synchronized (n) {
            return this.observationType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObservationType(int oType) {
        Integer n = this.observationType;
        synchronized (n) {
            this.observationType = new Integer(oType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObservationType(String oType) {
        block5: {
            try {
                Integer n = this.observationType;
                synchronized (n) {
                    this.observationType = Integer.parseInt(oType);
                }
            }
            catch (Throwable e) {
                log.error("WsdmJAXWSHandler::setObservationType: " + e);
                if (!log.isDebugLogging().booleanValue()) break block5;
                log.debug("WsdmJAXWSHandler::setObservationType: " + WSMUtils.dumpStackTrace(e));
            }
        }
    }

    private void setNameCache(String operationName, String namespace) {
        WSNameCache.setOperationName(operationName);
        WSNameCache.setNamespaceURI(namespace);
    }
}

