/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class IntHashMap
extends AbstractMap
implements Cloneable,
Serializable {
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    transient Entry[] fTable;
    transient int fSize;
    int fThreshold;
    final float fLoadFactor;
    volatile transient int fModCount;
    private transient Set entrySet = null;
    volatile transient Collection valuesCollection = null;
    private static final long serialVersionUID = 362498820763181265L;

    public IntHashMap(int initialCapacity, float loadFactor) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.fLoadFactor = loadFactor;
        this.fThreshold = (int)((float)capacity * loadFactor);
        this.fTable = new Entry[capacity];
        this.init();
    }

    public IntHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IntHashMap() {
        this.fLoadFactor = 0.75f;
        this.fThreshold = 16;
        this.fTable = new Entry[16];
        this.init();
    }

    void init() {
    }

    static int indexFor(int h, int length) {
        return h & length - 1;
    }

    public final int getModCount() {
        return this.fModCount;
    }

    public int size() {
        return this.fSize;
    }

    public boolean isEmpty() {
        return this.fSize == 0;
    }

    public Object get(int k) {
        int hash = k;
        int i = IntHashMap.indexFor(hash, this.fTable.length);
        Entry e = this.fTable[i];
        while (e != null) {
            if (e.hash == hash && k == e.key) {
                return e.value;
            }
            e = e.next;
        }
        return e;
    }

    public boolean containsKey(int k) {
        int hash = k;
        int i = IntHashMap.indexFor(hash, this.fTable.length);
        Entry e = this.fTable[i];
        while (e != null) {
            if (e.hash == hash && k == e.key) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    Entry getEntry(int k) {
        int hash = k;
        int i = IntHashMap.indexFor(hash, this.fTable.length);
        Entry e = this.fTable[i];
        while (e != null && (e.hash != hash || k != e.key)) {
            e = e.next;
        }
        return e;
    }

    public Object put(int k, Object value) {
        int hash = k;
        int i = IntHashMap.indexFor(hash, this.fTable.length);
        Entry e = this.fTable[i];
        while (e != null) {
            if (e.hash == hash && k == e.key) {
                Object oldValue = e.value;
                e.value = value;
                e.recordAccess(this);
                return oldValue;
            }
            e = e.next;
        }
        ++this.fModCount;
        this.addEntry(hash, k, value, i);
        return null;
    }

    private void putForCreate(int k, Object value) {
        int hash = k;
        int i = IntHashMap.indexFor(hash, this.fTable.length);
        Entry e = this.fTable[i];
        while (e != null) {
            if (e.hash == hash && k == e.key) {
                e.value = value;
                return;
            }
            e = e.next;
        }
        this.createEntry(hash, k, value, i);
    }

    void resize(int newCapacity) {
        Entry[] oldTable = this.fTable;
        int oldCapacity = oldTable.length;
        if (this.fSize < this.fThreshold || oldCapacity > newCapacity) {
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        this.transfer(newTable);
        this.fTable = newTable;
        this.fThreshold = (int)((float)newCapacity * this.fLoadFactor);
    }

    void transfer(Entry[] newTable) {
        Entry[] src = this.fTable;
        int newCapacity = newTable.length;
        for (int j = 0; j < src.length; ++j) {
            Entry next;
            Entry e = src[j];
            if (e == null) continue;
            src[j] = null;
            do {
                next = e.next;
                int i = IntHashMap.indexFor(e.hash, newCapacity);
                e.next = newTable[i];
                newTable[i] = e;
            } while ((e = next) != null);
        }
    }

    public Object remove(int key) {
        Entry e = this.removeEntryForKey(key);
        return e == null ? e : e.value;
    }

    Entry removeEntryForKey(int k) {
        Entry prev;
        int hash = k;
        int i = IntHashMap.indexFor(hash, this.fTable.length);
        Entry e = prev = this.fTable[i];
        while (e != null) {
            Entry next = e.next;
            if (e.hash == hash && k == e.key) {
                ++this.fModCount;
                --this.fSize;
                if (prev == e) {
                    this.fTable[i] = next;
                } else {
                    prev.next = next;
                }
                e.recordRemoval(this);
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    Entry removeMapping(Object o) {
        Entry prev;
        int k;
        if (!(o instanceof Map.Entry)) {
            return null;
        }
        Entry entry = (Entry)o;
        int hash = k = entry.getKey();
        int i = IntHashMap.indexFor(hash, this.fTable.length);
        Entry e = prev = this.fTable[i];
        while (e != null) {
            Entry next = e.next;
            if (e.hash == hash && e.equals(entry)) {
                ++this.fModCount;
                --this.fSize;
                if (prev == e) {
                    this.fTable[i] = next;
                } else {
                    prev.next = next;
                }
                e.recordRemoval(this);
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    public void clear() {
        ++this.fModCount;
        Entry[] tab = this.fTable;
        for (int i = 0; i < tab.length; ++i) {
            tab[i] = null;
        }
        this.fSize = 0;
    }

    public boolean containsValue(Object value) {
        if (value == null) {
            return this.containsNullValue();
        }
        Entry[] tab = this.fTable;
        for (int i = 0; i < tab.length; ++i) {
            Entry e = tab[i];
            while (e != null) {
                if (value.equals(e.value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    private boolean containsNullValue() {
        Entry[] tab = this.fTable;
        for (int i = 0; i < tab.length; ++i) {
            Entry e = tab[i];
            while (e != null) {
                if (e.value == null) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    void addEntry(int hash, int key, Object value, int bucketIndex) {
        this.fTable[bucketIndex] = new Entry(hash, key, value, this.fTable[bucketIndex]);
        if (this.fSize++ >= this.fThreshold) {
            this.resize(2 * this.fTable.length);
        }
    }

    void createEntry(int hash, int key, Object value, int bucketIndex) {
        this.fTable[bucketIndex] = new Entry(hash, key, value, this.fTable[bucketIndex]);
        ++this.fSize;
    }

    Iterator newValueIterator() {
        return new ValueIterator();
    }

    Iterator newEntryIterator() {
        return new EntryIterator();
    }

    public Collection values() {
        Collection vs = this.valuesCollection;
        return vs != null ? vs : (this.valuesCollection = new ValuesWrapper());
    }

    public Set entrySet() {
        Set es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.fTable.length);
        s.writeInt(this.fSize);
        Iterator i = this.entrySet().iterator();
        while (i.hasNext()) {
            Entry e = (Entry)i.next();
            s.writeInt(e.getKey());
            s.writeObject(e.getValue());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int numBuckets = s.readInt();
        this.fTable = new Entry[numBuckets];
        this.init();
        int size = s.readInt();
        for (int i = 0; i < size; ++i) {
            int key = s.readInt();
            Object value = s.readObject();
            this.putForCreate(key, value);
        }
    }

    int capacity() {
        return this.fTable.length;
    }

    float loadFactor() {
        return this.fLoadFactor;
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        public Iterator iterator() {
            return IntHashMap.this.newEntryIterator();
        }

        public boolean contains(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            Entry candidate = IntHashMap.this.getEntry(e.getKey());
            return candidate != null && candidate.equals(e);
        }

        public boolean remove(Object o) {
            return IntHashMap.this.removeMapping(o) != null;
        }

        public int size() {
            return IntHashMap.this.fSize;
        }

        public void clear() {
            IntHashMap.this.clear();
        }
    }

    private class ValuesWrapper
    extends AbstractCollection {
        private ValuesWrapper() {
        }

        public Iterator iterator() {
            return IntHashMap.this.newValueIterator();
        }

        public int size() {
            return IntHashMap.this.fSize;
        }

        public boolean contains(Object o) {
            return IntHashMap.this.containsValue(o);
        }

        public void clear() {
            IntHashMap.this.clear();
        }
    }

    private class EntryIterator
    extends HashIterator {
        private EntryIterator() {
        }

        public Object next() {
            return this.nextEntry();
        }
    }

    private class ValueIterator
    extends HashIterator {
        private ValueIterator() {
        }

        public Object next() {
            return this.nextEntry().value;
        }
    }

    private abstract class HashIterator
    implements Iterator {
        Entry next;
        int expectedModCount;
        int index;
        Entry current;

        HashIterator() {
            this.expectedModCount = IntHashMap.this.fModCount;
            Entry[] t = IntHashMap.this.fTable;
            int i = t.length;
            Entry n = null;
            if (IntHashMap.this.fSize != 0) {
                while (i > 0 && (n = t[--i]) == null) {
                }
            }
            this.next = n;
            this.index = i;
        }

        public boolean hasNext() {
            return this.next != null;
        }

        Entry nextEntry() {
            if (IntHashMap.this.fModCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            Entry n = e.next;
            Entry[] t = IntHashMap.this.fTable;
            int i = this.index;
            while (n == null && i > 0) {
                n = t[--i];
            }
            this.index = i;
            this.next = n;
            this.current = e;
            return this.current;
        }

        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            if (IntHashMap.this.fModCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            int k = this.current.key;
            this.current = null;
            IntHashMap.this.removeEntryForKey(k);
            this.expectedModCount = IntHashMap.this.fModCount;
        }
    }

    static class Entry {
        final int key;
        Object value;
        final int hash;
        Entry next;

        Entry(int h, int k, Object v, Entry n) {
            this.value = v;
            this.next = n;
            this.key = k;
            this.hash = h;
        }

        public int getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object newValue) {
            Object oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        public boolean equals(Object o) {
            Object v2;
            Object v1;
            int k2;
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            int k1 = this.getKey();
            return k1 == (k2 = e.getKey()) && ((v1 = this.getValue()) == (v2 = e.getValue()) || v1 != null && v1.equals(v2));
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }

        void recordAccess(IntHashMap m) {
        }

        void recordRemoval(IntHashMap m) {
        }
    }
}

