/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.io;

import com.wily.util.io.FastArrayCopy;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;

public class NonSyncByteArrayOutputStream
extends OutputStream {
    private static final byte[] kEmptyByteArray = new byte[0];
    private static final int kBufferSize = 8192;
    private final int fBufferSize;
    private LinkedList fBuffers;
    private int fBufferPosition;
    private byte[] fCurrentBuffer;

    public NonSyncByteArrayOutputStream() {
        this(8192);
    }

    public NonSyncByteArrayOutputStream(int buffersSize) {
        this.fBufferSize = buffersSize;
        this.fBuffers = new LinkedList();
        this.reset();
    }

    private void addBuffer() {
        if (this.fCurrentBuffer != null) {
            this.fBuffers.add(this.fCurrentBuffer);
        }
        this.fCurrentBuffer = new byte[this.fBufferSize];
        this.fBufferPosition = 0;
    }

    public final void write(int b) throws IOException {
        if (this.fBufferPosition == this.fBufferSize) {
            this.addBuffer();
        }
        this.fCurrentBuffer[this.fBufferPosition++] = (byte)b;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        while (len != 0) {
            if (this.fBufferPosition == this.fBufferSize) {
                this.addBuffer();
            }
            int amountForCurrentBuff = Math.min(len, this.fBufferSize - this.fBufferPosition);
            FastArrayCopy.copy(b, off, this.fCurrentBuffer, this.fBufferPosition, amountForCurrentBuff);
            off += amountForCurrentBuff;
            this.fBufferPosition += amountForCurrentBuff;
            len -= amountForCurrentBuff;
        }
    }

    public void reset() {
        this.fBuffers.clear();
        if (this.fCurrentBuffer == null) {
            this.fCurrentBuffer = new byte[this.fBufferSize];
        }
        this.fBufferPosition = 0;
    }

    public int size() {
        return this.fBuffers.size() * this.fBufferSize + this.fBufferPosition;
    }

    public void writeTo(OutputStream out) throws IOException {
        Iterator i = this.fBuffers.iterator();
        while (i.hasNext()) {
            byte[] buffer = (byte[])i.next();
            out.write(buffer);
        }
        if (this.fBufferPosition > 0) {
            out.write(this.fCurrentBuffer, 0, this.fBufferPosition);
        }
    }

    public void writeTo(DataOutput out) throws IOException {
        Iterator i = this.fBuffers.iterator();
        while (i.hasNext()) {
            byte[] buffer = (byte[])i.next();
            out.write(buffer);
        }
        if (this.fBufferPosition > 0) {
            out.write(this.fCurrentBuffer, 0, this.fBufferPosition);
        }
    }

    public byte[] toByteArray() {
        int size = this.size();
        if (size > 0) {
            byte[] newbuf = new byte[size];
            int destPosition = 0;
            Iterator i = this.fBuffers.iterator();
            while (i.hasNext()) {
                byte[] buffer = (byte[])i.next();
                System.arraycopy(buffer, 0, newbuf, destPosition, this.fBufferSize);
                destPosition += this.fBufferSize;
            }
            System.arraycopy(this.fCurrentBuffer, 0, newbuf, destPosition, this.fBufferPosition);
            return newbuf;
        }
        return kEmptyByteArray;
    }
}

