/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.properties.lockable;

import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.io.ExtendedFile;
import com.wily.util.io.StreamCopier;
import com.wily.util.properties.hot.PositiveIntegerConfigurationProperty;
import com.wily.util.properties.hot.PositiveLongConfigurationProperty;
import com.wily.util.properties.lockable.ILockableFileContent;
import com.wily.util.properties.lockable.ILocker;
import com.wily.util.properties.lockable.Locker;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class LockableFileManager {
    private static final String kLockDirectory = ".lock";
    private static final String kBackupFileSuffix = ".bak";
    private static final String kWriterLockFileSuffix = ".wlk";
    private static final String kUpdatingLockFileSuffix = ".ulk";
    private static final long kDefaultLockRetryIntervalMillis = 100L;
    private static final int kDefaultNumberLockRetries = 300;
    private static final long kFileOperationAttemptDelayMillis = 10L;
    private static final int kFileOperationRetries = 3;
    private ExtendedFile fPropertyFile;
    private ExtendedFile fBackupFile;
    private ExtendedFile fWriterLockFile;
    private ExtendedFile fUpdatingLockFile;
    private IModuleFeedbackChannel fFeedback;
    private ILocker fWriterLocker;
    private PositiveLongConfigurationProperty fLockRetryIntervalMillis;
    private PositiveIntegerConfigurationProperty fNumberLockRetries;

    public LockableFileManager(ExtendedFile propertyFile, IModuleFeedbackChannel feedback) {
        this(propertyFile, feedback, null, null);
    }

    public LockableFileManager(ExtendedFile propertyFile, IModuleFeedbackChannel feedback, PositiveLongConfigurationProperty lockRetryIntervalMillis) {
        this(propertyFile, feedback, lockRetryIntervalMillis, null);
    }

    public LockableFileManager(ExtendedFile propertyFile, IModuleFeedbackChannel feedback, PositiveLongConfigurationProperty lockRetryIntervalMillis, PositiveIntegerConfigurationProperty numberLockRetries) {
        this.fPropertyFile = propertyFile;
        this.fFeedback = feedback;
        this.makeFiles(propertyFile, this.fFeedback);
        this.fWriterLocker = new Locker(this.fWriterLockFile, this.fFeedback);
        this.fLockRetryIntervalMillis = lockRetryIntervalMillis;
        this.fNumberLockRetries = numberLockRetries;
    }

    private boolean makeLockDirectory(ExtendedFile lockDir, IModuleFeedbackChannel feedback) {
        if (lockDir.exists()) {
            if (lockDir.isDirectory()) {
                return true;
            }
            if (feedback.isDebugEnabled()) {
                feedback.debug("Lock directory already exists and is a file! Using profile folder directly instead");
            }
            return false;
        }
        if (lockDir.mkdir()) {
            return true;
        }
        if (lockDir.exists() && lockDir.isDirectory()) {
            return true;
        }
        if (feedback.isDebugEnabled()) {
            feedback.debug("Cannot create lock directory. Using profile folder directly instead");
        }
        return false;
    }

    private void makeFiles(ExtendedFile file, IModuleFeedbackChannel feedback) {
        if (file != null) {
            String root;
            int suffixStart;
            ExtendedFile lockDir = new ExtendedFile(file.getParentFile(), kLockDirectory);
            if (!this.makeLockDirectory(lockDir, feedback)) {
                lockDir = new ExtendedFile(file.getParentFile());
            }
            if ((suffixStart = (root = file.getName()).lastIndexOf(46)) >= 0) {
                root = root.substring(0, suffixStart);
            }
            this.fBackupFile = new ExtendedFile(lockDir, String.valueOf(root) + kBackupFileSuffix);
            this.fWriterLockFile = new ExtendedFile(lockDir, String.valueOf(root) + kWriterLockFileSuffix);
            this.fUpdatingLockFile = new ExtendedFile(lockDir, String.valueOf(root) + kUpdatingLockFileSuffix);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void copyfile(ExtendedFile from, ExtendedFile to) throws IOException {
        i = 1;
        while (true) {
            block22: {
                block20: {
                    if (i > 3) {
                        return;
                    }
                    in = null;
                    out = null;
                    try {
                        try {
                            in = new FileInputStream(ExtendedFile.getCanonicalFile(from));
                            out = new FileOutputStream(ExtendedFile.getCanonicalFile(to));
                            StreamCopier.copy(in, out);
                            var7_7 = null;
                            if (in == null) break block20;
                        }
                        catch (IOException e) {
                            if (this.fFeedback.isDebugEnabled()) {
                                this.fFeedback.debug("Error in copying file", e);
                            }
                            if (i == 3) {
                                throw e;
                            }
                            break block22;
                        }
                    }
                    catch (Throwable var8_8) {
                        var7_7 = null;
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException v0) {}
                        }
                        if (out == null) throw var8_8;
                        try {
                            out.close();
                            throw var8_8;
                        }
                        catch (IOException v1) {}
                        throw var8_8;
                    }
                    try {}
                    catch (IOException v2) {}
                    in.close();
                }
                if (out == null) return;
                try {}
                catch (IOException v3) {}
                out.close();
                return;
                return;
            }
            var7_7 = null;
            if (in != null) {
                try {}
                catch (IOException v4) {}
                in.close();
            }
            if (out == null) ** GOTO lbl-1000
            try {}
            catch (IOException v5) {}
            out.close();
lbl-1000:
            // 3 sources

            {
                Thread.sleep(10L);
            }
            ++i;
        }
    }

    private void deletefile(ExtendedFile file) throws IOException {
        int i = 1;
        while (i <= 3) {
            try {
                file.deleteFile();
                return;
            }
            catch (IOException e) {
                if (this.fFeedback.isDebugEnabled()) {
                    this.fFeedback.debug("Error in deleting file", e);
                }
                if (i == 3) {
                    throw e;
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
                ++i;
            }
        }
    }

    private long getLockRetryIntervalMillis() {
        if (this.fLockRetryIntervalMillis != null) {
            return (Long)this.fLockRetryIntervalMillis.getValue();
        }
        return 100L;
    }

    private int getNumberLockRetries() {
        if (this.fNumberLockRetries != null) {
            return (Integer)this.fNumberLockRetries.getValue();
        }
        return 300;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean writeLockableFile(ILockableFileContent fileContent) {
        block30: {
            numberRetries = 0;
            while (!this.fWriterLocker.tryLock()) {
                if (++numberRetries >= this.getNumberLockRetries()) {
                    if (this.fFeedback == null) return false;
                    if (this.fFeedback.isDebugEnabled() == false) return false;
                    this.fFeedback.debug("Exceeded maximum number of lock retries");
                    return false;
                }
                try {
                    Thread.sleep(this.getLockRetryIntervalMillis());
                }
                catch (InterruptedException v0) {
                    return false;
                }
            }
            try {
                block28: {
                    block27: {
                        if (this.needRecovery() && !this.recover()) {
                            block26: {
                                if (this.fFeedback != null && this.fFeedback.isDebugEnabled()) {
                                    this.fFeedback.debug("Error in recovering property file '" + this.fPropertyFile.getName() + "'");
                                }
                                var6_3 = null;
                                try {
                                    if (this.fBackupFile.exists() && !this.fUpdatingLockFile.exists()) {
                                        this.fBackupFile.deleteFile();
                                    }
                                }
                                catch (IOException e) {
                                    if (this.fFeedback == null || !this.fFeedback.isDebugEnabled()) break block26;
                                    this.fFeedback.debug("Error in deleting backup file '" + this.fBackupFile.getName() + "'", e);
                                }
                            }
                            this.fWriterLocker.release();
                            return false;
                        }
                        this.copyfile(this.fPropertyFile, this.fBackupFile);
                        this.fUpdatingLockFile.createFile();
                        try {
                            try {
                                fileContent.writeContent(this.fPropertyFile);
                            }
                            catch (IOException e) {
                                if (this.fFeedback != null && this.fFeedback.isDebugEnabled()) {
                                    this.fFeedback.debug("IO Error in writing property file '" + this.fPropertyFile.getName() + "'", e);
                                }
                                this.copyfile(this.fBackupFile, this.fPropertyFile);
                                throw e;
                            }
                            var4_15 = null;
                        }
                        catch (Throwable var5_13) {
                            var4_14 = null;
                            this.fUpdatingLockFile.deleteFile();
                            throw var5_13;
                        }
                        this.fUpdatingLockFile.deleteFile();
                        var6_4 = null;
                        ** try [egrp 6[TRYBLOCK] [10 : 353->383)] { 
lbl52:
                        // 1 sources

                        if (this.fBackupFile.exists() && !this.fUpdatingLockFile.exists()) {
                            this.fBackupFile.deleteFile();
                        }
                        break block27;
lbl55:
                        // 1 sources

                        catch (IOException e) {
                            if (this.fFeedback == null || !this.fFeedback.isDebugEnabled()) break block27;
                            this.fFeedback.debug("Error in deleting backup file '" + this.fBackupFile.getName() + "'", e);
                        }
                    }
                    this.fWriterLocker.release();
                    return true;
                    catch (IOException e) {
                        if (this.fFeedback == null || !this.fFeedback.isDebugEnabled()) break block28;
                        this.fFeedback.debug("IO Error in writing property file '" + this.fPropertyFile.getName() + "'", e);
                    }
                }
                var6_6 = null;
            }
            catch (Throwable var7_16) {
                block29: {
                    var6_5 = null;
                    ** try [egrp 6[TRYBLOCK] [10 : 353->383)] { 
lbl72:
                    // 1 sources

                    if (this.fBackupFile.exists() && !this.fUpdatingLockFile.exists()) {
                        this.fBackupFile.deleteFile();
                    }
                    break block29;
lbl75:
                    // 1 sources

                    catch (IOException e) {
                        if (this.fFeedback == null || !this.fFeedback.isDebugEnabled()) break block29;
                        this.fFeedback.debug("Error in deleting backup file '" + this.fBackupFile.getName() + "'", e);
                    }
                }
                this.fWriterLocker.release();
                throw var7_16;
            }
            ** try [egrp 6[TRYBLOCK] [10 : 353->383)] { 
lbl82:
            // 1 sources

            if (this.fBackupFile.exists() && !this.fUpdatingLockFile.exists()) {
                this.fBackupFile.deleteFile();
            }
            break block30;
lbl85:
            // 1 sources

            catch (IOException e) {
                if (this.fFeedback == null || !this.fFeedback.isDebugEnabled()) break block30;
                this.fFeedback.debug("Error in deleting backup file '" + this.fBackupFile.getName() + "'", e);
            }
        }
        this.fWriterLocker.release();
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean recover() {
        if (!this.needRecovery()) return true;
        try {
            if (!this.fBackupFile.exists()) {
                if (!this.fUpdatingLockFile.exists()) return true;
                this.deletefile(this.fUpdatingLockFile);
                return true;
            }
            if (this.fUpdatingLockFile.exists()) {
                try {
                    this.copyfile(this.fBackupFile, this.fPropertyFile);
                }
                catch (IOException e) {
                    if (this.fFeedback == null) return false;
                    if (!this.fFeedback.isDebugEnabled()) return false;
                    this.fFeedback.debug("Cannot recover by copying backup file to property file", e);
                    return false;
                }
                this.deletefile(this.fUpdatingLockFile);
            }
            this.fBackupFile.deleteFile();
            return true;
        }
        catch (IOException e) {
            if (this.fFeedback == null) return false;
            if (!this.fFeedback.isDebugEnabled()) return false;
            this.fFeedback.debug("Error during recovery", e);
            return false;
        }
    }

    private boolean needRecovery() {
        return this.fUpdatingLockFile.exists();
    }

    public String getBackupFileLocation() {
        return ExtendedFile.safeGetCanonicalPath(this.fBackupFile);
    }

    public ExtendedFile getPropertyFile() {
        return new ExtendedFile(this.fPropertyFile);
    }

    public ExtendedFile getUpdatingLockFile() {
        return new ExtendedFile(this.fUpdatingLockFile);
    }

    public void setLockRetryIntervalProperty(PositiveLongConfigurationProperty prop) {
        this.fLockRetryIntervalMillis = prop;
    }

    public void setNumberLockRetriesProperty(PositiveIntegerConfigurationProperty prop) {
        this.fNumberLockRetries = prop;
    }
}

