/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.db.directives;

import com.wily.diagnos.cmp.classmatcher.DGDeepInheritedClassMatcher;
import com.wily.diagnos.cmp.classmatcher.DGDynamicExactClassMatcher;
import com.wily.diagnos.cmp.classmatcher.DGExactClassMatcher;
import com.wily.diagnos.cmp.classmatcher.IClassMatcher;
import com.wily.diagnos.cmp.directives.FlagName;
import com.wily.diagnos.cmp.directives.TracerName;
import com.wily.diagnos.cmp.directives.builder.CompilerSettingsBuilder;
import com.wily.diagnos.cmp.directives.builder.TracerGroupBuilder;
import com.wily.diagnos.cmp.directives.parser.DGInvalidFlagNameException;
import com.wily.diagnos.cmp.directives.parser.DGInvalidTracerNameException;
import com.wily.diagnos.cmp.methodmatcher.IMethodMatcher;
import com.wily.diagnos.cmp.methodmatcher.NamedMethodMatcher;
import com.wily.diagnos.cmp.tracer.builder.DynamicMethodTracerBuilder;
import com.wily.diagnos.cmp.tracer.builder.MethodTracerBuilder;
import com.wily.introscope.agent.db.IDynamicInstrumentationDatabaseConstants;
import com.wily.introscope.agent.db.directives.DatabaseDirectiveInfo;
import com.wily.introscope.agent.db.directives.IDatabaseDirective;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IClassSchemaPolicy;
import com.wily.util.classfile.IMethodName;
import com.wily.util.classfile.InvalidClassNameException;
import com.wily.util.classfile.InvalidMethodDescriptorException;
import com.wily.util.classfile.InvalidMethodNameException;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.util.text.ILocalizableMessage;
import com.wily.util.validate.ValidationException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class DatabaseDirective
implements IDatabaseDirective,
IDynamicInstrumentationDatabaseConstants {
    private static final String kInvalidFlag = "Diagnos_Parsing_Invalid_Flag_Name_Key";
    private static final MessageFormat kSmallTextFormat = new MessageFormat("TraceOneMethodWithlabelOfClass: {0} {1} \"{4}\" {5} {2} \"{3}\"");
    private static final MessageFormat kInheritTextFormat = new MessageFormat("TraceOneMethodWithlabelIfInherits: {0} {1} \"{4}\" {5} {2} \"{3}\"");
    final boolean fIsInterfaces;
    final int fLineNumber;
    final IMethodName fMethodName;
    final IClassName fClassName;
    final TracerName fTracerName;
    final String fFlagName;
    private final String fTracerResourceName;
    private final String fLabelName;
    private final boolean fPermanent;
    private final boolean fTemporary;

    public DatabaseDirective(IClassSchemaPolicy policy, IModuleFeedbackChannel moduleFeedbackChannel, DatabaseDirectiveInfo element) throws DGInvalidTracerNameException, InvalidClassNameException, InvalidMethodDescriptorException, InvalidMethodNameException {
        this.fLineNumber = element.getLineNumber();
        this.fClassName = policy.getClassName(element.getClassName());
        this.fMethodName = policy.getMethodName(element.getMethodName());
        this.fTracerResourceName = element.getResourceName();
        this.fTracerName = TracerName.getTracerName((String)element.getTracerType());
        this.fFlagName = element.getGroupName();
        this.fPermanent = element.isPermanent();
        this.fLabelName = element.getLabel();
        this.fTemporary = element.isTemporary();
        this.fIsInterfaces = element.isInterface();
    }

    public void IDirective_applyToSettings(CompilerSettingsBuilder builder) throws ValidationException {
        TracerGroupBuilder flag = null;
        try {
            if (this.getFlagName() != null) {
                flag = builder.getTracerGroupBuilder(this.getFlagName());
                flag.setDeclared(true);
                flag.setEnabled(true);
                flag.addClassMatcher((IClassMatcher)new DGExactClassMatcher(this.getClassName()));
            }
        }
        catch (DGInvalidFlagNameException dGInvalidFlagNameException) {
            throw new ValidationException((ILocalizableMessage)new FormattedLocalizableMessage(kInvalidFlag, this.fFlagName));
        }
        if (!this.fIsInterfaces) {
            builder.addTracer((MethodTracerBuilder)new DynamicMethodTracerBuilder(this.IDirective_getSource(), this.IDirective_getLineNumber(), (IClassMatcher)new DGDynamicExactClassMatcher(this.getClassName()), (IMethodMatcher)new NamedMethodMatcher(this.getMethodName()), this.getTracerName(), this.getTracerResourceName(), flag, this.fLabelName, this.fTemporary, this.fPermanent, this.getClassName()));
        } else {
            builder.addTracer((MethodTracerBuilder)new DynamicMethodTracerBuilder(this.IDirective_getSource(), this.IDirective_getLineNumber(), (IClassMatcher)new DGDeepInheritedClassMatcher(this.getClassName()), (IMethodMatcher)new NamedMethodMatcher(this.getMethodName()), this.getTracerName(), this.getTracerResourceName(), flag, this.fLabelName, this.fTemporary, this.fPermanent, this.getClassName()));
        }
    }

    private FlagName getFlagName() throws DGInvalidFlagNameException {
        return FlagName.getFlagName((String)this.fFlagName);
    }

    private TracerName getTracerName() {
        return this.fTracerName;
    }

    private IMethodName getMethodName() {
        return this.fMethodName;
    }

    private IClassName getClassName() {
        return this.fClassName;
    }

    public int IDirective_getLineNumber() {
        return this.fLineNumber;
    }

    public String IDirective_getSource() {
        return "Database";
    }

    private String getTracerResourceName() {
        return this.fTracerResourceName;
    }

    public String getText() {
        if (this.fIsInterfaces) {
            return kInheritTextFormat.format(new Object[]{this.fClassName.getReflectionFriendlyQualifiedNameString(), this.fMethodName, this.fTracerName, this.fTracerResourceName, this.fLabelName, this.fFlagName});
        }
        return kSmallTextFormat.format(new Object[]{this.fClassName.getReflectionFriendlyQualifiedNameString(), this.fMethodName, this.fTracerName, this.fTracerResourceName, this.fLabelName, this.fFlagName});
    }

    public List getTextLines() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.getText());
        return result;
    }

    public String getLabel() {
        return this.fLabelName;
    }
}

