/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.classfile.java;

import com.wily.util.classfile.InvalidClassNameException;
import com.wily.util.classfile.InvalidIdentifierException;
import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.util.text.SimpleLocalizableMessage;
import java.util.StringTokenizer;

public class ClassFileValidationUtilities {
    public static final String[] kJavaBooleanLiterals = new String[]{"true", "false"};
    public static final String kJavaNullLiteral = "null";
    public static final String[] kJavaLanguageKeywords = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"};
    private static final String[] kSpecialMethodNames = new String[]{"<init>", "<clinit>"};

    public static void validateRegularOrSpecialJavaMethodName(String identifier) throws InvalidIdentifierException {
        int i = 0;
        while (i < kSpecialMethodNames.length) {
            if (identifier.equals(kSpecialMethodNames[i])) {
                return;
            }
            ++i;
        }
        ClassFileValidationUtilities.validateSimpleJavaIdentifier(identifier);
    }

    public static void validateFullyQualifiedSlashSeparatedClassName(String name) throws InvalidClassNameException {
        try {
            ClassFileValidationUtilities.validateSlashSeparatedJavaIdentifiers(name);
        }
        catch (InvalidIdentifierException invalidIdentifierException) {
            throw new InvalidClassNameException(new FormattedLocalizableMessage("Class_File_Invalid_Class_Name", name), name);
        }
    }

    private static void validateSlashSeparatedJavaIdentifiers(String identifiers) throws InvalidIdentifierException {
        StringTokenizer tokenizer = new StringTokenizer(identifiers == null ? "" : identifiers, "/", true);
        boolean lastWasSeparator = true;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("/")) {
                if (lastWasSeparator) {
                    throw new InvalidIdentifierException(new SimpleLocalizableMessage("Class_File_Empty_Identifier"), identifiers);
                }
                lastWasSeparator = true;
                continue;
            }
            ClassFileValidationUtilities.validateSimpleJavaIdentifier(token);
            lastWasSeparator = false;
        }
        if (lastWasSeparator) {
            throw new InvalidIdentifierException(new SimpleLocalizableMessage("Class_File_Empty_Identifier"), identifiers);
        }
    }

    public static void validateSimpleJavaIdentifier(String identifier) throws InvalidIdentifierException {
        ClassFileValidationUtilities.validateCoreJavaIdentifier(identifier);
    }

    public static void validateCoreJavaIdentifier(String identifier) throws InvalidIdentifierException {
        if (identifier == null || identifier.length() == 0) {
            throw new InvalidIdentifierException(new SimpleLocalizableMessage("Class_File_Empty_Identifier"), identifier);
        }
        if (!Character.isJavaIdentifierStart(identifier.charAt(0))) {
            throw new InvalidIdentifierException(new FormattedLocalizableMessage("Class_File_Invalid_Identifier_Start", identifier), identifier);
        }
        int i = 1;
        while (i < identifier.length()) {
            char curChar = identifier.charAt(i);
            if (!Character.isJavaIdentifierPart(curChar)) {
                throw new InvalidIdentifierException(new FormattedLocalizableMessage("Class_File_Invalid_Identifier_Part", identifier), identifier);
            }
            ++i;
        }
    }
}

