/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.batch;

import com.wily.diagnos.cmp.directives.DirectivesFile;
import com.wily.diagnos.cmp.directives.DirectivesListFile;
import com.wily.util.io.ExtendedFile;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.text.IStringLocalizer;
import com.wily.util.text.SimpleLocalizableMessage;
import com.wily.util.validate.IValidatable;
import com.wily.util.validate.ValidationException;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;

public class CompilerEnvironment
extends IndexedProperties
implements IValidatable {
    private static final long serialVersionUID = -6276377230857023962L;
    public static final String kSourceClassKey = "SourceClass";
    public static final String kInstrumentedDestClassKey = "InstrumentedDestClass";
    public static final String kSourceJarKey = "SourceJar";
    public static final String kInstrumentedDestJarKey = "InstrumentedDestJar";
    public static final String kSourceDirectoryKey = "SourceFolder";
    public static final String kInstrumentedDestDirectoryKey = "InstrumentedDestFolder";
    public static final String kSourceAssemblyKey = "SourceAssembly";
    public static final String kInstrumentedDestAssemblyKey = "InstrumentedDestAssembly";
    public static final String kLogLocationKey = "LogLocation";
    public static final String kUserDirectivesFileKey = "UserDirectivesFile";
    public static final String kCopyItemsKey = "CopyItems";
    public static final String kFlushDirectoryKey = "FlushDirectory";
    public static final String kVerboseModeKey = "Verbose";
    public static final String kCommandLineUIModeKey = "CommandLineUI";
    public static final String kCommandLineHelpKey = "CommandLineHelp";
    private static final String kTrue = "true";
    private DirectivesFile fRequiredDirectivesFile = null;
    private DirectivesListFile fDirectivesListFile = null;
    private DirectivesFile[] fCustomDirectivesFiles = null;
    private IStringLocalizer fStringLocalizer;

    public CompilerEnvironment(IStringLocalizer localizer) {
        this.fStringLocalizer = localizer;
        this.setCopyItems(true);
        this.setVerboseMode(false);
        this.setHelpMode(false);
    }

    public IStringLocalizer getStringLocalizer() {
        return this.fStringLocalizer;
    }

    public void setRequiredDirectivesFile(DirectivesFile requiredDirectivesFile) {
        this.fRequiredDirectivesFile = requiredDirectivesFile;
    }

    public boolean hasRequiredDirectivesFile() {
        return this.fRequiredDirectivesFile != null;
    }

    public DirectivesFile getRequiredDirectivesFile() {
        return this.fRequiredDirectivesFile;
    }

    public void setDirectivesListFile(DirectivesListFile directivesListFile) {
        this.fDirectivesListFile = directivesListFile;
    }

    public boolean hasDirectivesListFile() {
        return this.fDirectivesListFile != null;
    }

    public DirectivesListFile getDirectivesListFile() {
        return this.fDirectivesListFile;
    }

    public void setCustomDirectivesFiles(DirectivesFile[] customDirectivesFiles) {
        this.fCustomDirectivesFiles = customDirectivesFiles;
    }

    public boolean hasCustomDirectivesFiles() {
        return this.fCustomDirectivesFiles != null;
    }

    public DirectivesFile[] getCustomDirectivesFiles() {
        return this.fCustomDirectivesFiles;
    }

    public void setUserDirectivesFiles(String[] directivesFileNameList) {
        this.putIndexedProperties(kUserDirectivesFileKey, directivesFileNameList);
    }

    public String[] getUserDirectivesFiles() {
        return this.getIndexedProperties(kUserDirectivesFileKey);
    }

    public boolean hasUserDirectivesFiles() {
        return this.getUserDirectivesFiles().length != 0;
    }

    public void setSourceClass(String sourceClassName) {
        this.put(kSourceClassKey, sourceClassName);
    }

    public String getSourceClass() {
        return this.getTrimmedProperty(kSourceClassKey);
    }

    public void removeSourceClass() {
        this.remove(kSourceClassKey);
    }

    public boolean hasSourceClass() {
        return this.getSourceClass() != null;
    }

    public void setInstrumentedDestinationClass(String instrumentedDestClassName) {
        this.put(kInstrumentedDestClassKey, instrumentedDestClassName);
    }

    public String getInstrumentedDestinationClass() {
        return this.getTrimmedProperty(kInstrumentedDestClassKey);
    }

    public void removeInstrumentedDestinationClass() {
        this.remove(kInstrumentedDestClassKey);
    }

    public boolean hasInstrumentedDestinationClass() {
        return this.getInstrumentedDestinationClass() != null;
    }

    public void setSourceJar(String sourceJarName) {
        this.put(kSourceJarKey, sourceJarName);
    }

    public String getSourceJar() {
        return this.getTrimmedProperty(kSourceJarKey);
    }

    public void removeSourceJar() {
        this.remove(kSourceJarKey);
    }

    public boolean hasSourceJar() {
        return this.getSourceJar() != null;
    }

    public void setInstrumentedDestinationJar(String instrumentedDestJarName) {
        this.put(kInstrumentedDestJarKey, instrumentedDestJarName);
    }

    public String getInstrumentedDestinationJar() {
        return this.getTrimmedProperty(kInstrumentedDestJarKey);
    }

    public void removeInstrumentedDestinationJar() {
        this.remove(kInstrumentedDestJarKey);
    }

    public boolean hasInstrumentedDestinationJar() {
        return this.getInstrumentedDestinationJar() != null;
    }

    public void setSourceDirectory(String sourceDirectoryName) {
        this.put(kSourceDirectoryKey, sourceDirectoryName);
    }

    public String getSourceDirectory() {
        return this.getTrimmedProperty(kSourceDirectoryKey);
    }

    public boolean hasSourceDirectory() {
        return this.getSourceDirectory() != null;
    }

    public void removeSourceDirectory() {
        this.remove(kSourceDirectoryKey);
    }

    public void setInstrumentedDestinationDirectory(String instrumentedDestDirectoryName) {
        this.put(kInstrumentedDestDirectoryKey, instrumentedDestDirectoryName);
    }

    public String getInstrumentedDestinationDirectory() {
        return this.getTrimmedProperty(kInstrumentedDestDirectoryKey);
    }

    public void removeInstrumentedDestinationDirectory() {
        this.remove(kInstrumentedDestDirectoryKey);
    }

    public boolean hasInstrumentedDestinationDirectory() {
        return this.getInstrumentedDestinationDirectory() != null;
    }

    public void setInstrumentedDestinationAssembly(String instrumentedDestJarName) {
        this.put(kInstrumentedDestAssemblyKey, instrumentedDestJarName);
    }

    public String getInstrumentedDestinationAssembly() {
        return this.getTrimmedProperty(kInstrumentedDestAssemblyKey);
    }

    public void removeInstrumentedDestinationAssembly() {
        this.remove(kInstrumentedDestAssemblyKey);
    }

    public boolean hasInstrumentedDestinationAssembly() {
        return this.getInstrumentedDestinationAssembly() != null;
    }

    public void setSourceAssembly(String sourceJarName) {
        this.put(kSourceAssemblyKey, sourceJarName);
    }

    public String getSourceAssembly() {
        return this.getTrimmedProperty(kSourceAssemblyKey);
    }

    public void removeSourceAssembly() {
        this.remove(kSourceAssemblyKey);
    }

    public boolean hasSourceAssembly() {
        return this.getSourceAssembly() != null;
    }

    public void setCopyItems(boolean newMode) {
        if (newMode) {
            this.put(kCopyItemsKey, kTrue);
        } else {
            this.remove(kCopyItemsKey);
        }
    }

    public boolean getCopyItems() {
        return this.getProperty(kCopyItemsKey) != null;
    }

    public void setFlushDirectory(boolean newMode) {
        if (newMode) {
            this.put(kFlushDirectoryKey, kTrue);
        } else {
            this.remove(kFlushDirectoryKey);
        }
    }

    public boolean getFlushDirectory() {
        return this.getProperty(kFlushDirectoryKey) != null;
    }

    public void setVerboseMode(boolean newMode) {
        if (newMode) {
            this.put(kVerboseModeKey, kTrue);
        } else {
            this.remove(kVerboseModeKey);
        }
    }

    public boolean getVerboseMode() {
        return this.getProperty(kVerboseModeKey) != null;
    }

    public boolean isVerbose() {
        return this.getVerboseMode();
    }

    public void setCommandLineUIMode(boolean newMode) {
        if (newMode) {
            this.put(kCommandLineUIModeKey, kTrue);
        } else {
            this.remove(kCommandLineUIModeKey);
        }
    }

    public boolean hasLogLocation() {
        return this.get(kLogLocationKey) != null;
    }

    public void setLogLocation(String location) {
        this.put(kLogLocationKey, location);
    }

    public String getLogLocation() {
        return (String)this.get(kLogLocationKey);
    }

    public File getLogFilePath() {
        File result = null;
        if (this.hasLogLocation()) {
            result = new File(this.getLogLocation());
        } else if (this.processingJarFile() || this.processingClassFile() || this.processingAssembly()) {
            File source = null;
            File dest = null;
            if (this.processingJarFile()) {
                source = ExtendedFile.getCanonicalFile(this.getSourceJar());
                dest = ExtendedFile.getCanonicalFile(this.getInstrumentedDestinationJar());
            } else if (this.processingAssembly()) {
                source = ExtendedFile.getCanonicalFile(this.getSourceAssembly());
                dest = ExtendedFile.getCanonicalFile(this.getInstrumentedDestinationAssembly());
            } else {
                source = ExtendedFile.getCanonicalFile(this.getSourceClass());
                dest = ExtendedFile.getCanonicalFile(this.getInstrumentedDestinationClass());
            }
            String lastSegmentOfSourceName = source.getName();
            String logName = String.valueOf(lastSegmentOfSourceName) + ".probebuilder.log";
            String destPath = dest.getParent();
            result = new File(destPath, logName);
        } else {
            File sourceDir = ExtendedFile.getCanonicalFile(this.getSourceDirectory());
            String lastSegmentOfSourceName = sourceDir.getName();
            String logName = String.valueOf(lastSegmentOfSourceName) + ".probebuilder.log";
            File destDir = ExtendedFile.getCanonicalFile(this.getInstrumentedDestinationDirectory());
            result = new File(destDir, logName);
        }
        return result;
    }

    public boolean getCommandLineUIMode() {
        return this.getProperty(kCommandLineUIModeKey) != null;
    }

    public boolean useCommandLineUI() {
        return this.getCommandLineUIMode();
    }

    public void setHelpMode(boolean newMode) {
        if (newMode) {
            this.put(kCommandLineHelpKey, kTrue);
        } else {
            this.remove(kCommandLineHelpKey);
        }
    }

    public boolean getHelpMode() {
        return this.getProperty(kCommandLineHelpKey) != null;
    }

    public boolean shouldGiveHelp() {
        return this.getHelpMode();
    }

    public boolean processingJarFile() {
        return this.hasSourceJar() || this.hasInstrumentedDestinationJar();
    }

    public boolean processingAssembly() {
        return this.hasSourceAssembly() || this.hasInstrumentedDestinationAssembly();
    }

    public boolean processingDirectory() {
        return this.hasSourceDirectory() || this.hasInstrumentedDestinationDirectory();
    }

    public boolean processingClassFile() {
        return this.hasSourceClass() || this.hasInstrumentedDestinationClass();
    }

    public String getTargetName() {
        if (this.processingDirectory()) {
            return this.getSourceDirectory();
        }
        if (this.processingJarFile()) {
            return this.getSourceJar();
        }
        if (this.processingClassFile()) {
            return this.getSourceClass();
        }
        if (this.processingAssembly()) {
            return this.getSourceAssembly();
        }
        return null;
    }

    public void validateDirectives() throws ValidationException {
        if (!this.hasUserDirectivesFiles() && !this.hasDirectivesListFile()) {
            this.throwValidationError("Probe_Builder_Validation_Exception_No_User_Directives_Specified_Error");
        }
    }

    public void validateDirectories() throws ValidationException {
        int count = 0;
        if (this.processingDirectory()) {
            ++count;
        }
        if (this.processingJarFile()) {
            ++count;
        }
        if (this.processingClassFile()) {
            ++count;
        }
        if (this.processingAssembly()) {
            ++count;
        }
        if (count == 0) {
            this.throwValidationError("Probe_Builder_Validation_Exception_No_Options_Specified_Error");
        }
        if (count > 1) {
            this.throwValidationError("Probe_Builder_Validation_Exception_Mixed_Directives_Error");
        }
        if (this.processingDirectory()) {
            if (!this.hasSourceDirectory()) {
                this.throwValidationError("Probe_Builder_Validation_Exception_Missing_Source_Dir_Error");
            }
            if (!this.hasInstrumentedDestinationDirectory()) {
                this.throwValidationError("Probe_Builder_Validation_Exception_Missing_Dest_Dir_Error");
            }
            File sourceDir = new File(this.getSourceDirectory());
            File targetDir = new File(this.getInstrumentedDestinationDirectory());
            if (!sourceDir.exists()) {
                this.throwValidationError("Probe_Builder_Validation_Exception_Source_Dir_Does_Not_Exist_Error");
            }
            if (!sourceDir.isDirectory()) {
                this.throwValidationError("Probe_Builder_Validation_Exception_Source_Dir_Not_A_Directory_Error");
            }
            this.confirmUnique(sourceDir, targetDir, "Probe_Builder_Validation_Exception_Same_Source_And_Dest_Dir_Error");
        } else if (this.processingJarFile()) {
            if (!this.hasSourceJar()) {
                this.throwValidationError("Probe_Builder_Validation_Exception_Missing_Source_Jar_Error");
            }
            if (!this.hasInstrumentedDestinationJar()) {
                this.throwValidationError("Probe_Builder_Validation_Exception_Missing_Dest_Jar_Error");
            }
            File sourceJar = new File(this.getSourceJar());
            File targetJar = new File(this.getInstrumentedDestinationJar());
            if (!sourceJar.exists()) {
                this.throwValidationError("Probe_Builder_Validation_Exception_Source_Jar_Does_Not_Exist_Error");
            }
            this.confirmUnique(sourceJar, targetJar, "Probe_Builder_Validation_Exception_Same_Source_And_Dest_Jar_Error");
            if (!ExtendedFile.getExtension(sourceJar).equalsIgnoreCase(ExtendedFile.getExtension(targetJar))) {
                this.throwValidationError("Probe_Builder_Validation_Exception_Incompatible_Archive_Types_Error");
            }
        } else if (this.processingAssembly()) {
            if (!this.hasSourceAssembly()) {
                this.throwValidationError("Probe_Builder_Validation_Exception_Missing_Source_Assembly_Error");
            }
            if (!this.hasInstrumentedDestinationAssembly()) {
                this.throwValidationError("Probe_Builder_Validation_Exception_Missing_Dest_Assembly_Error");
            }
            File sourceAssembly = new File(this.getSourceAssembly());
            File targetAssembly = new File(this.getInstrumentedDestinationAssembly());
            if (!sourceAssembly.exists()) {
                this.throwValidationError("Probe_Builder_Validation_Exception_Source_Jar_Does_Not_Exist_Error");
            }
            this.confirmUnique(sourceAssembly, targetAssembly, "Probe_Builder_Validation_Exception_Same_Source_And_Dest_Assembly_Error");
            if (!ExtendedFile.getExtension(sourceAssembly).equalsIgnoreCase(ExtendedFile.getExtension(targetAssembly))) {
                this.throwValidationError("Probe_Builder_Validation_Exception_Incompatible_Archive_Types_Error");
            }
        } else if (this.processingClassFile()) {
            if (!this.hasSourceClass()) {
                this.throwValidationError("Probe_Builder_Validation_Exception_Missing_Source_Class_Error");
            }
            if (!this.hasInstrumentedDestinationClass()) {
                this.throwValidationError("Probe_Builder_Validation_Exception_Missing_Dest_Class_Error");
            }
            File sourceClass = new File(this.getSourceClass());
            File targetClass = new File(this.getInstrumentedDestinationClass());
            if (!sourceClass.exists()) {
                this.throwValidationError("Probe_Builder_Validation_Exception_Source_Class_Does_Not_Exist_Error");
            }
            this.confirmUnique(sourceClass, targetClass, "Probe_Builder_Validation_Exception_Same_Source_And_Dest_Class_Error");
        } else {
            this.throwValidationError("Probe_Builder_Validation_Exception_Unknown_Validation_Error");
        }
    }

    private void throwValidationError(String messageKey) throws ValidationException {
        throw new ValidationException(new SimpleLocalizableMessage(messageKey));
    }

    public void IValidatable_validate(int validationConstraintFlags) throws ValidationException {
        this.IValidatable_validate();
    }

    public void IValidatable_validate() throws ValidationException {
        this.validateDirectives();
        this.validateDirectories();
    }

    private void confirmUnique(File source, File dest, String errorMessage) throws ValidationException {
        try {
            String sourceCanonicalPath = source.getCanonicalPath();
            String targetCanonicalPath = dest.getCanonicalPath();
            if (sourceCanonicalPath.equals(targetCanonicalPath)) {
                this.throwValidationError(errorMessage);
            }
        }
        catch (IOException iOException) {
            this.throwValidationError("Probe_Builder_Validation_Exception_Unknown_Validation_Error");
        }
    }

    public void debugLog(PrintStream stream) {
        stream.println("ProbeBuilderEnvironment debugLog:");
        stream.println("processingJarFile: " + this.processingJarFile());
        stream.println("source jar file: " + this.getSourceJar());
        stream.println("instrumented destination jar file: " + this.getInstrumentedDestinationJar());
        stream.println("processingDirectory: " + this.processingDirectory());
        stream.println("source directory: " + this.getSourceDirectory());
        stream.println("instrumented destination directory: " + this.getInstrumentedDestinationDirectory());
        stream.println("verbose: " + this.isVerbose());
        stream.println("give help: " + this.shouldGiveHelp());
    }
}

