/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.directives;

import com.wily.diagnos.cmp.directives.APlaceHolderResolver;
import com.wily.diagnos.cmp.directives.IDirectiveHandler;
import com.wily.util.io.ExtendedCharacterEncoding;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;

public class DirectivesFileParser {
    private DirectivesFileParser() {
    }

    public static void parse(File file, IDirectiveHandler handler) throws IOException {
        DirectivesFileParser.parse(new FileInputStream(file), false, handler);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void parse(InputStream input, boolean forceUtf8, IDirectiveHandler handler) throws IOException {
        LineNumberReader reader = DirectivesFileParser.loadReader(input, forceUtf8);
        try {
            String line = null;
            while ((line = DirectivesFileParser.getLine(reader, handler)) != null) {
                if (line.indexOf("${") != -1) {
                    line = APlaceHolderResolver.getInstance().resolvePlaceHolder(line);
                }
                handler.IDirectiveHandler_handleDirective(line);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            reader.close();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        reader.close();
    }

    private static LineNumberReader loadReader(InputStream input, boolean forceUtf8) throws IOException {
        String encoding;
        InputStreamReader reader = null;
        reader = forceUtf8 ? ExtendedCharacterEncoding.getUTF8InputStreamReader(input) : ((encoding = System.getProperty("com.wily.introscope.default.encoding")) == null ? new InputStreamReader(input) : new InputStreamReader(input, encoding));
        return new LineNumberReader(reader);
    }

    private static String getLine(LineNumberReader reader, IDirectiveHandler handler) throws IOException {
        String line = reader.readLine();
        if (line != null) {
            handler.IDirectiveHandler_handleTextLine(line);
        }
        return line;
    }
}

