/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.directives;

import com.wily.diagnos.cmp.directives.DirectivesFile;
import com.wily.diagnos.cmp.directives.DirectivesFileParser;
import com.wily.diagnos.cmp.directives.DirectivesListFileException;
import com.wily.diagnos.cmp.directives.IDirectiveHandler;
import com.wily.diagnos.cmp.directives.builder.CompilerSettingsBuilder;
import com.wily.diagnos.cmp.directives.parser.DGParserException;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.personality.ICompilerPersonality;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.io.ExtendedFile;
import com.wily.util.resource.IResourceReader;
import com.wily.util.resource.InvalidResourceException;
import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.util.text.ILocalizableMessage;
import com.wily.util.text.IStringLocalizer;
import com.wily.util.text.LocalizedMessage;
import com.wily.util.validate.ValidationException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class DirectivesListFile
implements IDirectiveHandler {
    private static final char kCommentChar = '#';
    private static final String kMultipleTitleDirectives = "multiple title directives specified";
    private static final String kMultipleDescriptionDirectives = "multiple description directives specified";
    private static final String kMissingTitleDirective = "missing title directive";
    private static final String kMissingDescriptionDirective = "missing description directive";
    private static final String kInvalidListEntry = "invalid list entry encountered";
    private static final String kInvalidFileLocation = "invalid list file location";
    private static final String kEmptyList = "empty list";
    private static final String kInvalidEntryContents = "invalid list entry contents";
    private static final String kInvalidListContents = "invalid list contents";
    private String fTitle;
    private String fDescription;
    private Vector fList;
    private Vector fText;
    private DirectivesListFileException fSavedException;
    private File fSource;
    private File fRelativeDir;
    private String fResourceName;
    private IResourceReader fResourceReader;
    private final IModuleFeedbackChannel fFeedback;
    private final ICompilerLog fLog;
    private final IStringLocalizer fLocalizer;
    private final ICompilerPersonality fPersonality;

    private DirectivesListFile(IModuleFeedbackChannel feedback, ICompilerLog log, IStringLocalizer localizer, ICompilerPersonality personality) {
        this.fLog = log;
        this.fFeedback = feedback;
        this.fLocalizer = localizer;
        this.fPersonality = personality;
        this.fTitle = null;
        this.fDescription = null;
        this.fList = new Vector();
        this.fText = new Vector();
        this.fSavedException = null;
        this.fSource = null;
        this.fRelativeDir = null;
        this.fResourceReader = null;
    }

    public DirectivesListFile(IModuleFeedbackChannel feedback, ICompilerLog log, IStringLocalizer localizer, ICompilerPersonality personality, String name) throws DirectivesListFileException {
        this(feedback, log, localizer, personality, new File(name));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DirectivesListFile(IModuleFeedbackChannel feedback, ICompilerLog log, IStringLocalizer localizer, ICompilerPersonality personality, File file) throws DirectivesListFileException {
        this(feedback, log, localizer, personality);
        this.fSource = new File(ExtendedFile.safeGetCanonicalPath(file));
        try {
            this.fRelativeDir = this.getRelativeDirectory(this.fSource);
            this.parseFile(this.fSource);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.fRelativeDir = null;
            this.fSavedException = null;
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.fRelativeDir = null;
            this.fSavedException = null;
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DirectivesListFile(IModuleFeedbackChannel feedback, ICompilerLog log, IStringLocalizer localizer, ICompilerPersonality personality, IResourceReader resourceReader, String name) throws DirectivesListFileException {
        this(feedback, log, localizer, personality);
        this.fResourceName = name;
        this.fResourceReader = resourceReader;
        try {
            this.parseFile(this.fResourceReader, this.fResourceName);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.fSavedException = null;
            throw throwable;
        }
        {
            Object var7_9 = null;
            this.fSavedException = null;
            return;
        }
    }

    private IModuleFeedbackChannel getModuleFeedback() {
        return this.fFeedback;
    }

    private ICompilerLog getCompilerLog() {
        return this.fLog;
    }

    private IStringLocalizer getStringLocalizer() {
        return this.fLocalizer;
    }

    private ICompilerPersonality getPersonality() {
        return this.fPersonality;
    }

    private File getRelativeDirectory(File file) throws DirectivesListFileException {
        String dirStr = file.getParent();
        if (dirStr == null) {
            throw new DirectivesListFileException(kInvalidFileLocation, (ILocalizableMessage)new FormattedLocalizableMessage("Diagnos_Directives_List_File_Invalid_File_Location_Error", file.getAbsolutePath()));
        }
        return new File(dirStr);
    }

    private void parseFile(File file) throws DirectivesListFileException {
        try {
            DirectivesFileParser.parse(file, this);
            this.validateList();
        }
        catch (IOException ioe) {
            throw new DirectivesListFileException(ioe.getMessage(), (ILocalizableMessage)new FormattedLocalizableMessage("Diagnos_Directives_List_File_Unknown_IO_Error", file.getAbsolutePath(), ioe.getMessage()));
        }
    }

    private void parseFile(IResourceReader resourceReader, String name) throws DirectivesListFileException {
        String location = null;
        try {
            location = resourceReader.IResourceReader_getResourceLocation(name);
            InputStream input = resourceReader.IResourceReader_getResource(name);
            boolean forceUtf8 = !resourceReader.IResourceReader_isPlatformSpecific(name);
            DirectivesFileParser.parse(input, forceUtf8, this);
            this.validateList();
        }
        catch (InvalidResourceException ire) {
            throw new DirectivesListFileException(ire.getMessage(), ire.ILocalizableException_getLocalizableMessage());
        }
        catch (IOException ioe) {
            throw new DirectivesListFileException(ioe.getMessage(), (ILocalizableMessage)new FormattedLocalizableMessage("Diagnos_Directives_List_File_Unknown_IO_Error", location, ioe.getMessage()));
        }
    }

    public String getLocation() {
        if (this.fSource != null) {
            return ExtendedFile.safeGetCanonicalPath(this.fSource);
        }
        if (this.fResourceReader != null) {
            try {
                return this.fResourceReader.IResourceReader_getResourceLocation(this.fResourceName);
            }
            catch (InvalidResourceException invalidResourceException) {
                return this.fResourceName;
            }
        }
        return null;
    }

    private void validateList() throws DirectivesListFileException {
        if (this.fSavedException != null) {
            throw this.fSavedException;
        }
    }

    public void IDirectiveHandler_handleTextLine(String line) {
        this.fText.addElement(line);
    }

    public void IDirectiveHandler_handleDirective(String line) {
        if (this.fSavedException != null) {
            return;
        }
        if ((line = DirectivesListFile.stripComment(line)).length() == 0) {
            return;
        }
        if (line.startsWith("Title:")) {
            String value = line.substring("Title:".length()).trim();
            if (this.fTitle != null) {
                this.fSavedException = new DirectivesListFileException(kMultipleTitleDirectives, (ILocalizableMessage)new FormattedLocalizableMessage("Diagnos_Directives_List_File_Multiple_Title_Directives_Error", this.getLocation(), this.fTitle, value));
                return;
            }
            this.fTitle = value;
        } else if (line.startsWith("Description:")) {
            String value = line.substring("Description:".length()).trim();
            if (this.fDescription != null) {
                this.fSavedException = new DirectivesListFileException(kMultipleDescriptionDirectives, (ILocalizableMessage)new FormattedLocalizableMessage("Diagnos_Directives_List_File_Multiple_Description_Directives_Error", this.getLocation(), this.fDescription, value));
                return;
            }
            this.fDescription = value;
        } else if (this.fSource != null) {
            ExtendedFile curFile = new ExtendedFile(line);
            if (!curFile.isAbsolute()) {
                curFile = new ExtendedFile(this.fRelativeDir, line);
            }
            if (curFile.isDirectory() || !curFile.exists()) {
                this.fSavedException = new DirectivesListFileException(kInvalidListEntry, (ILocalizableMessage)new FormattedLocalizableMessage("Diagnos_Directives_List_File_Invalid_Entry_Error", this.getLocation(), line));
                return;
            }
            try {
                DirectivesFile file = new DirectivesFile(this.fPersonality, curFile.getFile());
                this.fList.addElement(file);
            }
            catch (DGParserException dgpe) {
                this.fSavedException = new DirectivesListFileException(kInvalidEntryContents, (ILocalizableMessage)new FormattedLocalizableMessage("Diagnos_Directives_List_File_Invalid_Entry_Contents_Error", new LocalizedMessage(this.getLocation()), dgpe.ILocalizableException_getLocalizableMessage()));
            }
            catch (IOException ioe) {
                this.fSavedException = new DirectivesListFileException(kInvalidEntryContents, (ILocalizableMessage)new FormattedLocalizableMessage("Diagnos_Directives_List_File_Invalid_Entry_Contents_Error", new LocalizedMessage(this.getLocation()), new LocalizedMessage(ioe.toString())));
            }
        } else {
            try {
                IResourceReader reader = this.fResourceReader.IResourceReader_getResourceReader(this.fResourceName);
                DirectivesFile file = new DirectivesFile(this.fPersonality, reader, line);
                this.fList.addElement(file);
            }
            catch (DGParserException dgpe) {
                this.fSavedException = new DirectivesListFileException(kInvalidEntryContents, (ILocalizableMessage)new FormattedLocalizableMessage("Diagnos_Directives_List_File_Invalid_Entry_Contents_Error", new LocalizedMessage(this.getLocation()), dgpe.ILocalizableException_getLocalizableMessage()));
            }
            catch (InvalidResourceException ire) {
                this.fSavedException = new DirectivesListFileException(kInvalidEntryContents, (ILocalizableMessage)new FormattedLocalizableMessage("Diagnos_Directives_List_File_Invalid_Entry_Contents_Error", new LocalizedMessage(this.getLocation()), ire.ILocalizableException_getLocalizableMessage()));
            }
            catch (IOException ioe) {
                this.fSavedException = new DirectivesListFileException(kInvalidEntryContents, (ILocalizableMessage)new FormattedLocalizableMessage("Diagnos_Directives_List_File_Invalid_Entry_Contents_Error", new LocalizedMessage(this.getLocation()), new LocalizedMessage(ioe.toString())));
            }
        }
    }

    private static String stripComment(String line) {
        if (line == null) {
            return line;
        }
        int commentStart = line.indexOf(35);
        if (commentStart != -1) {
            line = line.substring(0, commentStart);
        }
        return line.trim();
    }

    public void validateList(DirectivesFile additionalSettings) throws DirectivesListFileException {
        if (this.fTitle == null) {
            throw new DirectivesListFileException(kMissingTitleDirective, (ILocalizableMessage)new FormattedLocalizableMessage("Diagnos_Directives_List_File_Missing_Title_Error", this.getLocation()));
        }
        if (this.fDescription == null) {
            throw new DirectivesListFileException(kMissingDescriptionDirective, (ILocalizableMessage)new FormattedLocalizableMessage("Diagnos_Directives_List_File_Missing_Description_Error", this.getLocation()));
        }
        CompilerSettingsBuilder builder = new CompilerSettingsBuilder(this.getModuleFeedback(), this.getCompilerLog(), this.getStringLocalizer(), this.getPersonality());
        if (additionalSettings != null) {
            try {
                additionalSettings.applyDirectivesToSettings(builder);
            }
            catch (Throwable e) {
                throw new DirectivesListFileException("", (ILocalizableMessage)new LocalizedMessage(e.getMessage()));
            }
        }
        Iterator iterator = this.getDirectiveFiles();
        while (iterator.hasNext()) {
            DirectivesFile file = (DirectivesFile)iterator.next();
            try {
                file.applyDirectivesToSettings(builder);
            }
            catch (Throwable e) {
                throw new DirectivesListFileException("", (ILocalizableMessage)new LocalizedMessage(e.getMessage()));
            }
        }
        try {
            builder.validate();
        }
        catch (ValidationException ve) {
            throw new DirectivesListFileException(kInvalidListContents, (ILocalizableMessage)new FormattedLocalizableMessage("Diagnos_Directives_List_File_Invalid_List_Contents_Error", new LocalizedMessage(this.getLocation()), ve.getRequiredCondition()));
        }
    }

    public String getTitle() {
        return this.fTitle;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public Iterator getDirectiveFiles() {
        return this.fList.iterator();
    }

    public List getText() {
        return this.fText;
    }

    public int compareTo(Object o) {
        if (o instanceof DirectivesListFile) {
            return this.getTitle().compareTo(((DirectivesListFile)o).getTitle());
        }
        throw new ClassCastException("Invalid object compared to DirectivesListFile");
    }

    public String toString() {
        return this.getTitle();
    }
}

