/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.directives.parser;

import com.wily.diagnos.cmp.directives.IDirective;
import com.wily.diagnos.cmp.directives.InvalidDirectiveException;
import com.wily.diagnos.cmp.directives.parser.ConditionallyTraceOneMethodExactClassLabeledDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.ConditionallyTraceOneMethodIfInheritsLabeledDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.DGParserException;
import com.wily.diagnos.cmp.directives.parser.DoNotSkipMethodForClassDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.ISingleDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.IdentifyAllClassesDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.IdentifyAnnotatedClassDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.IdentifyCorbaClassDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.IdentifyDeepInheritedAnnotatedClassDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.IdentifyDeepInheritedClassDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.IdentifyExactClassDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.IdentifyFlagDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.IdentifyInheritedAnnotatedClassDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.IdentifyInheritedClassDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.IdentifyMatchingClassesDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.IdentifyTwoFlagIntersectionAsAggregateFlagDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.IdentifyTwoFlagUnionAsAggregateFlagDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.IncludeIntelligentInstrumentationPackagePrefixDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.InstrumentBootstrapClassDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.InstrumentPointDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.InstrumentTraceClassDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.MarkFlagNotToggledDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.NoticeConstructorCompletionIfFlaggedDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.NoticeFieldAssignmentIfFlaggedDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.NoticeObjectCreationIfFlaggedDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.NoticeScopedFieldAssignmentIfFlaggedDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.NoticeScopedObjectCreationIfFlaggedDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.SetFlagDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.SetTracerClassMappingDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.SetTracerOrderingDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.SetTracerParameterDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.SkipAnnotatedForFlagDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.SkipAssemblyDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.SkipAssemblyForFlagDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.SkipAssemblyPrefixDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.SkipAssemblyPrefixForFlagDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.SkipClassDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.SkipClassForFlagDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.SkipDynamicInstrumentationAssemblyDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.SkipDynamicInstrumentationAssemblyPrefixDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.SkipDynamicInstrumentationClassDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.SkipDynamicInstrumentationPackageDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.SkipDynamicInstrumentationPackagePrefixDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.SkipIfInheritedForFlagDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.SkipIntelligentInstrumentationPackagePrefixDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.SkipMatchingClassesForFlagDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.SkipMatchingMethodsForFlagDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.SkipMethodForClassDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.SkipMethodForFlagDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.SkipNamespacePrefixForFlagDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.SkipPackageDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.SkipPackageForFlagDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.SkipPackagePrefixDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.SkipPackagePrefixForFlagDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.SkipStaticMethodsForFlagDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.SubstituteClassDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.SubstituteClassIfFlaggedDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.SubstituteResultByNamedProxyIfFlaggedDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.SubstituteResultIfFlaggedDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.SubstituteStaticFieldDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.SubstituteStaticFieldIfFlaggedDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.SubstituteStaticMethodDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.SubstituteStaticMethodIfFlaggedDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.TraceAllComplexMethodsIfFlaggedDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.TraceAllComplexMethodsWithThresholdIfFlaggedDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.TraceAllMethodsExactClassDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.TraceAllMethodsIfCorbaDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.TraceAllMethodsIfFlaggedDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.TraceAllMethodsIfInheritsDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.TraceAllMethodsWithParametersIfFlaggedDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.TraceAllMethodsWithThresholdExactClassDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.TraceAllMethodsWithThresholdIfFlaggedDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.TraceAnnotatedMethodsIfFlaggedDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.TraceAnnotatedMethodsWithParametersIfFlaggedDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.TraceComplexMethodsIfFlaggedDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.TraceComplexMethodsWithParametersIfFlaggedDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.TraceComplexMethodsWithThresholdIfFlaggedDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.TraceMatchingMethodsIfFlaggedDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.TraceOneMethodExactClassDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.TraceOneMethodExactClassLabeledDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.TraceOneMethodIfCorbaDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.TraceOneMethodIfFlaggedDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.TraceOneMethodIfInheritsDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.TraceOneMethodIfInheritsLabeledDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.TraceOneMethodWithParametersExactClassDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.TraceOneMethodWithParametersIfCorbaDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.TraceOneMethodWithParametersIfFlaggedDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.TraceOneMethodWithParametersIfInheritsDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.TraceOneMethodWithThresholdExactClassDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.TraceOneMethodWithThresholdIfFlaggedDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.TraceRemoteMethodsExactClassDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.TraceRemoteMethodsIfCorbaDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.TraceRemoteMethodsIfFlaggedDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.TraceRemoteMethodsIfInheritsDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.TurnOffFlagDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.TurnOnFlagDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.UnknownDirectiveParser;
import com.wily.diagnos.personality.ICompilerPersonality;
import com.wily.util.classfile.ClassFileException;
import com.wily.util.text.ALocalizableException;
import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.util.text.ILocalizableMessage;
import com.wily.util.text.LocalizedMessage;
import com.wily.wilyassert.Assertion;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class DirectiveParser {
    private static final String kUnsupportedCharacterMessage = "Syntax Error - Directive contains unsupported character: ";
    private static Map sDirectivesLookup;
    private static ISingleDirectiveParser sUnknownDirectiveParser;

    static {
        DirectiveParser.buildDirectivesLookup();
    }

    private DirectiveParser() {
    }

    private static void buildDirectivesLookup() {
        sDirectivesLookup = new HashMap();
        sUnknownDirectiveParser = new UnknownDirectiveParser();
        DirectiveParser.addDirectiveParser(new InstrumentPointDirectiveParser());
        DirectiveParser.addDirectiveParser(new SubstituteClassDirectiveParser());
        DirectiveParser.addDirectiveParser(new SubstituteStaticFieldDirectiveParser());
        DirectiveParser.addDirectiveParser(new SubstituteStaticMethodDirectiveParser());
        DirectiveParser.addDirectiveParser(new InstrumentTraceClassDirectiveParser());
        DirectiveParser.addDirectiveParser(new SkipClassDirectiveParser());
        DirectiveParser.addDirectiveParser(new SkipMethodForClassDirectiveParser());
        DirectiveParser.addDirectiveParser(new DoNotSkipMethodForClassDirectiveParser());
        DirectiveParser.addDirectiveParser(new SkipMethodForFlagDirectiveParser());
        DirectiveParser.addDirectiveParser(new SkipStaticMethodsForFlagDirectiveParser());
        DirectiveParser.addDirectiveParser(new SkipPackageDirectiveParser());
        DirectiveParser.addDirectiveParser(new SkipPackagePrefixDirectiveParser());
        DirectiveParser.addDirectiveParser(new SkipAssemblyDirectiveParser());
        DirectiveParser.addDirectiveParser(new SkipAssemblyPrefixDirectiveParser());
        DirectiveParser.addDirectiveParser(new SkipAssemblyPrefixForFlagDirectiveParser());
        DirectiveParser.addDirectiveParser(new SkipAssemblyForFlagDirectiveParser());
        DirectiveParser.addDirectiveParser(new SetFlagDirectiveParser());
        DirectiveParser.addDirectiveParser(new TurnOnFlagDirectiveParser());
        DirectiveParser.addDirectiveParser(new TurnOffFlagDirectiveParser());
        DirectiveParser.addDirectiveParser(new MarkFlagNotToggledDirectiveParser());
        DirectiveParser.addDirectiveParser(new IdentifyExactClassDirectiveParser());
        DirectiveParser.addDirectiveParser(new IdentifyInheritedClassDirectiveParser());
        DirectiveParser.addDirectiveParser(new IdentifyDeepInheritedClassDirectiveParser());
        DirectiveParser.addDirectiveParser(new IdentifyMatchingClassesDirectiveParser());
        DirectiveParser.addDirectiveParser(new IdentifyCorbaClassDirectiveParser());
        DirectiveParser.addDirectiveParser(new IdentifyFlagDirectiveParser());
        DirectiveParser.addDirectiveParser(new IdentifyAllClassesDirectiveParser());
        DirectiveParser.addDirectiveParser(new IdentifyTwoFlagUnionAsAggregateFlagDirectiveParser());
        DirectiveParser.addDirectiveParser(new IdentifyTwoFlagIntersectionAsAggregateFlagDirectiveParser());
        DirectiveParser.addDirectiveParser(new IdentifyAnnotatedClassDirectiveParser());
        DirectiveParser.addDirectiveParser(new IdentifyInheritedAnnotatedClassDirectiveParser());
        DirectiveParser.addDirectiveParser(new IdentifyDeepInheritedAnnotatedClassDirectiveParser());
        DirectiveParser.addDirectiveParser(new SubstituteClassIfFlaggedDirectiveParser());
        DirectiveParser.addDirectiveParser(new SubstituteStaticFieldIfFlaggedDirectiveParser());
        DirectiveParser.addDirectiveParser(new SubstituteStaticMethodIfFlaggedDirectiveParser());
        DirectiveParser.addDirectiveParser(new SetTracerClassMappingDirectiveParser());
        DirectiveParser.addDirectiveParser(new SetTracerOrderingDirectiveParser());
        DirectiveParser.addDirectiveParser(new SetTracerParameterDirectiveParser());
        DirectiveParser.addDirectiveParser(new SubstituteResultIfFlaggedDirectiveParser());
        DirectiveParser.addDirectiveParser(new SubstituteResultByNamedProxyIfFlaggedDirectiveParser());
        DirectiveParser.addDirectiveParser(new NoticeConstructorCompletionIfFlaggedDirectiveParser());
        DirectiveParser.addDirectiveParser(new NoticeObjectCreationIfFlaggedDirectiveParser());
        DirectiveParser.addDirectiveParser(new NoticeFieldAssignmentIfFlaggedDirectiveParser());
        DirectiveParser.addDirectiveParser(new NoticeScopedObjectCreationIfFlaggedDirectiveParser());
        DirectiveParser.addDirectiveParser(new NoticeScopedFieldAssignmentIfFlaggedDirectiveParser());
        DirectiveParser.addDirectiveParser(new SkipAnnotatedForFlagDirectiveParser());
        DirectiveParser.addDirectiveParser(new SkipIfInheritedForFlagDirectiveParser());
        DirectiveParser.addDirectiveParser(new SkipClassForFlagDirectiveParser());
        DirectiveParser.addDirectiveParser(new SkipPackageForFlagDirectiveParser());
        DirectiveParser.addDirectiveParser(new SkipPackagePrefixForFlagDirectiveParser());
        DirectiveParser.addDirectiveParser(new SkipNamespacePrefixForFlagDirectiveParser());
        DirectiveParser.addDirectiveParser(new SkipMatchingClassesForFlagDirectiveParser());
        DirectiveParser.addDirectiveParser(new SkipMatchingMethodsForFlagDirectiveParser());
        DirectiveParser.addDirectiveParser(new InstrumentBootstrapClassDirectiveParser());
        DirectiveParser.addDirectiveParser(new TraceAllMethodsExactClassDirectiveParser());
        DirectiveParser.addDirectiveParser(new TraceAllMethodsIfInheritsDirectiveParser());
        DirectiveParser.addDirectiveParser(new TraceAllMethodsIfCorbaDirectiveParser());
        DirectiveParser.addDirectiveParser(new TraceAllMethodsIfFlaggedDirectiveParser());
        DirectiveParser.addDirectiveParser(new TraceAllComplexMethodsIfFlaggedDirectiveParser());
        DirectiveParser.addDirectiveParser(new TraceAllComplexMethodsWithThresholdIfFlaggedDirectiveParser());
        DirectiveParser.addDirectiveParser(new TraceComplexMethodsIfFlaggedDirectiveParser());
        DirectiveParser.addDirectiveParser(new TraceComplexMethodsWithParametersIfFlaggedDirectiveParser());
        DirectiveParser.addDirectiveParser(new TraceComplexMethodsWithThresholdIfFlaggedDirectiveParser());
        DirectiveParser.addDirectiveParser(new TraceRemoteMethodsExactClassDirectiveParser());
        DirectiveParser.addDirectiveParser(new TraceRemoteMethodsIfInheritsDirectiveParser());
        DirectiveParser.addDirectiveParser(new TraceRemoteMethodsIfCorbaDirectiveParser());
        DirectiveParser.addDirectiveParser(new TraceRemoteMethodsIfFlaggedDirectiveParser());
        DirectiveParser.addDirectiveParser(new TraceOneMethodExactClassDirectiveParser());
        DirectiveParser.addDirectiveParser(new TraceOneMethodExactClassLabeledDirectiveParser());
        DirectiveParser.addDirectiveParser(new ConditionallyTraceOneMethodExactClassLabeledDirectiveParser());
        DirectiveParser.addDirectiveParser(new TraceOneMethodIfInheritsLabeledDirectiveParser());
        DirectiveParser.addDirectiveParser(new ConditionallyTraceOneMethodIfInheritsLabeledDirectiveParser());
        DirectiveParser.addDirectiveParser(new TraceOneMethodIfInheritsDirectiveParser());
        DirectiveParser.addDirectiveParser(new TraceOneMethodIfCorbaDirectiveParser());
        DirectiveParser.addDirectiveParser(new TraceOneMethodIfFlaggedDirectiveParser());
        DirectiveParser.addDirectiveParser(new TraceOneMethodWithParametersExactClassDirectiveParser());
        DirectiveParser.addDirectiveParser(new TraceOneMethodWithParametersIfInheritsDirectiveParser());
        DirectiveParser.addDirectiveParser(new TraceOneMethodWithParametersIfCorbaDirectiveParser());
        DirectiveParser.addDirectiveParser(new TraceOneMethodWithParametersIfFlaggedDirectiveParser());
        DirectiveParser.addDirectiveParser(new TraceAllMethodsWithThresholdIfFlaggedDirectiveParser());
        DirectiveParser.addDirectiveParser(new TraceAllMethodsWithThresholdExactClassDirectiveParser());
        DirectiveParser.addDirectiveParser(new TraceOneMethodWithThresholdIfFlaggedDirectiveParser());
        DirectiveParser.addDirectiveParser(new TraceOneMethodWithThresholdExactClassDirectiveParser());
        DirectiveParser.addDirectiveParser(new TraceAnnotatedMethodsIfFlaggedDirectiveParser());
        DirectiveParser.addDirectiveParser(new TraceAnnotatedMethodsWithParametersIfFlaggedDirectiveParser());
        DirectiveParser.addDirectiveParser(new TraceAllMethodsWithParametersIfFlaggedDirectiveParser());
        DirectiveParser.addDirectiveParser(new TraceMatchingMethodsIfFlaggedDirectiveParser());
        DirectiveParser.addDirectiveParser(new SkipDynamicInstrumentationClassDirectiveParser());
        DirectiveParser.addDirectiveParser(new SkipDynamicInstrumentationPackageDirectiveParser());
        DirectiveParser.addDirectiveParser(new SkipDynamicInstrumentationPackagePrefixDirectiveParser());
        DirectiveParser.addDirectiveParser(new SkipDynamicInstrumentationAssemblyDirectiveParser());
        DirectiveParser.addDirectiveParser(new SkipDynamicInstrumentationAssemblyPrefixDirectiveParser());
        DirectiveParser.addDirectiveParser(new SkipIntelligentInstrumentationPackagePrefixDirectiveParser());
        DirectiveParser.addDirectiveParser(new IncludeIntelligentInstrumentationPackagePrefixDirectiveParser());
    }

    private static void addDirectiveParser(ISingleDirectiveParser parser) {
        String[] keywords = parser.ISingleDirectiveParser_getDirectiveKeywords();
        Assertion.wilyAssert(false);
        int i = 0;
        while (i < keywords.length) {
            String keyword = keywords[i].toLowerCase();
            Assertion.wilyAssert(false);
            sDirectivesLookup.put(keyword, parser);
            ++i;
        }
    }

    private static ISingleDirectiveParser getDirectiveParser(String token) {
        ISingleDirectiveParser result = (ISingleDirectiveParser)sDirectivesLookup.get(token.toLowerCase());
        if (result == null) {
            result = sUnknownDirectiveParser;
        }
        return result;
    }

    public static IDirective parse(ICompilerPersonality personality, String directive) throws DGParserException, IOException {
        return DirectiveParser.parse(personality, directive, null, -1);
    }

    public static IDirective parse(ICompilerPersonality personality, String sourceDirective, String sourceFile, int lineNumber) throws DGParserException, IOException {
        ISingleDirectiveParser parser = sUnknownDirectiveParser;
        String keyword = null;
        try {
            StreamTokenizer tokenizer = DirectiveParser.getTokenizer(sourceDirective);
            keyword = DirectiveParser.getKeyword(sourceDirective, tokenizer);
            if (keyword != null) {
                String[] arguments = DirectiveParser.getArguments(sourceDirective, tokenizer);
                parser = DirectiveParser.getDirectiveParser(keyword);
                return parser.ISingleDirectiveParser_parseDirective(personality.getClassSchemaPolicy(), keyword, arguments, sourceFile, lineNumber);
            }
        }
        catch (ClassFileException cfe) {
            DirectiveParser.rethrowWrappedException(cfe, parser, keyword, sourceFile, lineNumber);
        }
        catch (DGParserException dgpe) {
            DirectiveParser.rethrowWrappedException(dgpe, parser, keyword, sourceFile, lineNumber);
        }
        catch (InvalidDirectiveException ide) {
            DirectiveParser.rethrowWrappedException(ide, parser, keyword, sourceFile, lineNumber);
        }
        return null;
    }

    private static StreamTokenizer getTokenizer(String directive) {
        StringReader reader = new StringReader(directive);
        StreamTokenizer tokenizer = new StreamTokenizer(reader);
        DirectiveParser.initializeStream(tokenizer);
        return tokenizer;
    }

    private static String getKeyword(String directive, StreamTokenizer tokenizer) throws DGParserException, IOException {
        String keyword = DirectiveParser.getToken(tokenizer);
        return keyword;
    }

    private static String[] getArguments(String directive, StreamTokenizer tokenizer) throws DGParserException, IOException {
        Vector<String> results = new Vector<String>();
        String argument = null;
        while ((argument = DirectiveParser.getToken(tokenizer)) != null) {
            results.addElement(argument);
        }
        Object[] arguments = new String[results.size()];
        results.copyInto(arguments);
        return arguments;
    }

    private static String getToken(StreamTokenizer tokenizer) throws DGParserException, IOException {
        int tokenType = tokenizer.nextToken();
        if (tokenType == -3 || tokenType == 34 || tokenType == 39) {
            return tokenizer.sval;
        }
        if (tokenType != 10 && tokenType != -1) {
            String value = String.valueOf((char)tokenType);
            throw new DGParserException(kUnsupportedCharacterMessage + value, (ILocalizableMessage)new FormattedLocalizableMessage("Diagnos_Exception_Parsing_Unsupported_Character_Message", value, false));
        }
        return null;
    }

    private static void initializeStream(StreamTokenizer tokenizer) {
        tokenizer.resetSyntax();
        tokenizer.wordChars(97, 122);
        tokenizer.wordChars(65, 90);
        tokenizer.wordChars(160, 255);
        tokenizer.whitespaceChars(0, 32);
        tokenizer.quoteChar(34);
        tokenizer.quoteChar(39);
        tokenizer.commentChar(35);
        tokenizer.wordChars(47, 47);
        tokenizer.wordChars(92, 92);
        tokenizer.wordChars(46, 46);
        tokenizer.wordChars(58, 58);
        tokenizer.wordChars(95, 95);
        tokenizer.wordChars(45, 45);
        tokenizer.wordChars(48, 57);
        tokenizer.wordChars(60, 62);
        tokenizer.wordChars(36, 36);
        tokenizer.wordChars(43, 43);
        tokenizer.wordChars(96, 96);
        tokenizer.wordChars(40, 40);
        tokenizer.wordChars(41, 41);
        tokenizer.wordChars(47, 47);
        tokenizer.wordChars(59, 59);
        tokenizer.wordChars(91, 91);
        tokenizer.wordChars(93, 93);
        tokenizer.wordChars(44, 44);
        tokenizer.wordChars(33, 33);
        tokenizer.wordChars(38, 38);
        tokenizer.wordChars(42, 42);
        tokenizer.wordChars(123, 123);
        tokenizer.wordChars(125, 125);
    }

    private static void rethrowWrappedException(ALocalizableException e, ISingleDirectiveParser parser, String keyword, String sourceFile, int lineNumber) throws DGParserException {
        String message = "Syntax Error: " + e.getMessage() + ".";
        FormattedLocalizableMessage localizableMessage = null;
        localizableMessage = parser.ISingleDirectiveParser_hasHelpMessage() ? new FormattedLocalizableMessage("Diagnos_Exception_Parsing_Syntax_Error_With_Help_Wrapper", e.ILocalizableException_getLocalizableMessage(), parser.ISingleDirectiveParser_getHelpMessage(keyword)) : new FormattedLocalizableMessage("Diagnos_Exception_Parsing_Syntax_Error_Wrapper", e.ILocalizableException_getLocalizableMessage());
        if (sourceFile != null) {
            message = "(" + sourceFile + ":" + lineNumber + ") " + message;
            localizableMessage = new FormattedLocalizableMessage("Diagnos_Exception_Parsing_Location_Specific_Wrapper", new LocalizedMessage(sourceFile), new LocalizedMessage(String.valueOf(lineNumber)), localizableMessage);
        }
        throw new DGParserException(message, e, localizableMessage);
    }
}

