/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.transform.builder;

import com.wily.diagnos.cmp.directives.TracerGroup;
import com.wily.diagnos.cmp.directives.builder.TracerGroupBuilder;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.cmp.transform.ITransformation;
import com.wily.diagnos.cmp.transform.SubstituteClassTransformation;
import com.wily.diagnos.cmp.transform.builder.ITransformationBuilder;
import com.wily.util.classfile.IClassName;
import java.util.Map;

public final class SubstituteClassTransformationBuilder
implements ITransformationBuilder {
    private final TracerGroupBuilder fTracerGroupBuilder;
    private final IClassName fSourceClass;
    private final IClassName fReplacementClass;

    public SubstituteClassTransformationBuilder(IClassName sourceClass, IClassName replacementClass) {
        this(null, sourceClass, replacementClass);
    }

    public SubstituteClassTransformationBuilder(TracerGroupBuilder flag, IClassName sourceClass, IClassName replacementClass) {
        this.fTracerGroupBuilder = flag;
        this.fSourceClass = sourceClass;
        this.fReplacementClass = replacementClass;
    }

    public TracerGroupBuilder getTracerGroupBuilder() {
        return this.fTracerGroupBuilder;
    }

    public IClassName getSourceClass() {
        return this.fSourceClass;
    }

    public IClassName getReplacementClass() {
        return this.fReplacementClass;
    }

    public ITransformation generateTransformation(ICompilerLog log, IClassName instrumentationClass, Map tracerGroups) {
        TracerGroup tracerGroup = this.getTracerGroupBuilder() == null ? null : this.getTracerGroupBuilder().lookupTracerGroup(tracerGroups);
        return new SubstituteClassTransformation(log, tracerGroup, this.getSourceClass(), this.getReplacementClass());
    }
}

