/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.remote.arf;

import java.util.ArrayList;
import java.util.Iterator;

public class ArfWriter {
    final ArrayList fWriters = new ArrayList(12);

    public void addWriterEntry(String name, IWriter writer) {
        this.fWriters.add(new ArfWriterEntry(name, writer));
    }

    void clearEntries() {
        this.fWriters.clear();
    }

    public String write(Object o) {
        StringBuffer b = new StringBuffer();
        b.append('{');
        Iterator i = this.fWriters.iterator();
        while (i.hasNext()) {
            ArfWriterEntry e = (ArfWriterEntry)i.next();
            e.fWriter.write(o, b);
        }
        b.append('}');
        return b.toString();
    }

    private static StringBuffer handleFirstField(StringBuffer b) {
        if (b.charAt(b.length() - 1) != '{') {
            b.append(',');
        }
        return b;
    }

    public static StringBuffer writeStringParam(StringBuffer b, String name, String value) {
        ArfWriter.handleFirstField(b);
        b.append('\"');
        b.append(name);
        b.append("\":\"");
        b.append(value);
        b.append('\"');
        return b;
    }

    public static StringBuffer writeObjectParam(StringBuffer b, String name, String value) {
        ArfWriter.handleFirstField(b);
        b.append('\"');
        b.append(name);
        b.append("\":");
        b.append(value);
        return b;
    }

    public static StringBuffer writeIntParam(StringBuffer b, String name, int value) {
        ArfWriter.handleFirstField(b);
        b.append('\"');
        b.append(name);
        b.append("\":");
        b.append(value);
        return b;
    }

    public static StringBuffer writeLongParam(StringBuffer b, String name, long value) {
        ArfWriter.handleFirstField(b);
        b.append('\"');
        b.append(name);
        b.append("\":");
        b.append(value);
        return b;
    }

    public static class ArfWriterEntry {
        String fName;
        IWriter fWriter;

        public ArfWriterEntry(String name, IWriter writer) {
            this.fName = name;
            this.fWriter = writer;
        }
    }

    public static interface IWriter {
        public void write(Object var1, StringBuffer var2);
    }
}

