/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.intelligent;

import com.wily.introscope.agent.trace.ProbeInformation;
import com.wily.introscope.agent.trace.intelligent.DeepTraceConfigurations;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class VisibilityGapManager {
    public static ConcurrentHashMap<Integer, Integer> methodByTracerCode = new ConcurrentHashMap();
    public static ConcurrentHashMap<ProbeInformation, Integer> methodByProbeInfo = new ConcurrentHashMap();
    private static AtomicInteger methodByTracerCodeMax = new AtomicInteger(0);
    private static AtomicInteger methodByProbeInfoMax = new AtomicInteger(0);

    public static void addMethodWithVisibilityGap(int tracerCode) {
        if (methodByTracerCodeMax.get() < DeepTraceConfigurations.fVisibilityGapMaxMethodsReported) {
            methodByTracerCodeMax.incrementAndGet();
            methodByTracerCode.put(tracerCode, 0);
        }
    }

    public static void addMethodWithVisibilityGap(ProbeInformation probeInfo) {
        if (methodByProbeInfoMax.get() < DeepTraceConfigurations.fVisibilityGapMaxMethodsReported) {
            methodByProbeInfoMax.incrementAndGet();
            methodByProbeInfo.put(probeInfo, 0);
        }
    }

    public static void clear() {
        methodByProbeInfo.clear();
        methodByTracerCode.clear();
        methodByTracerCodeMax.set(0);
        methodByProbeInfoMax.set(0);
    }
}

