/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.api.instrument;

import com.wily.introscope.api.instrument.Exception.AgentAttachException;
import com.wily.introscope.api.instrument.utils.AttachDetachUtilities;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

public class AgentCommand {
    private boolean fDisplayVM;
    private boolean fAgentAttached;
    private boolean fAgentDeactivated;
    private boolean fRedefineClass;
    private String fVMDisplayName;
    private String fVMId;
    private String fAgentProperty;
    private String fAgentLocation;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public AgentCommand() throws Exception {
        this.initializeCommandLineStream();
        this.initializeProperties();
    }

    public void initializeCommandLineStream() throws Exception {
        String fileOut = System.getProperty("out.file");
        FileOutputStream fStream = null;
        if (fileOut != null) {
            fStream = new FileOutputStream(fileOut);
            PrintStream printStream = new PrintStream(fStream);
            System.setErr(printStream);
            System.setOut(printStream);
        }
    }

    public void initializeProperties() {
        String agentAttached = System.getProperty("com.wily.introscope.agentAttach");
        this.fAgentAttached = agentAttached != null && agentAttached.toLowerCase().equals("true");
        String agentDeactivated = System.getProperty("com.wily.introscope.agentDeactivated");
        this.fAgentDeactivated = agentDeactivated != null && agentDeactivated.toLowerCase().equals("true");
        String shouldDisplay = System.getProperty("com.wily.introscope.displayVirtualMachines");
        this.fDisplayVM = shouldDisplay != null && shouldDisplay.toLowerCase().equals("true");
        String displayName = System.getProperty("com.wily.introscope.virtualMachineDisplayName");
        this.fVMDisplayName = displayName != null && !displayName.trim().equals("") ? displayName : null;
        String displayId = System.getProperty("com.wily.introscope.virtualMachineId");
        this.fVMId = displayId != null && !displayId.trim().equals("") ? displayId : null;
        String agentProperty = System.getProperty("com.wily.introscope.agentProfile");
        this.fAgentProperty = agentProperty != null && !agentProperty.trim().equals("") ? agentProperty : "IntroscopeAgent.profile";
        String agentLocation = System.getProperty("com.wily.introscope.agentLocation");
        this.fAgentLocation = agentLocation != null && !agentLocation.trim().equals("") ? agentLocation : "./Agent.jar";
        String redefineClass = System.getProperty("com.wily.introscope.agentRedefineClasses");
        this.fRedefineClass = redefineClass == null || !redefineClass.trim().equals("false");
    }

    public boolean isAgentAttachedOn() {
        return this.fAgentAttached;
    }

    public boolean isAgentDeactivatedOn() {
        return this.fAgentDeactivated;
    }

    public boolean isVMDisplayOn() {
        return this.fDisplayVM;
    }

    public String getVMDisplayName() {
        return this.fVMDisplayName;
    }

    public String getVMId() {
        return this.fVMId;
    }

    public String getAgentLocation() {
        return this.fAgentLocation;
    }

    public String getAgentProfileLocation() {
        return this.fAgentProperty;
    }

    public boolean getRedefineClass() {
        return this.fRedefineClass;
    }

    public void displayVMs() {
        String shouldDisplay = System.getProperty("com.wily.introscope.displayVirtualMachines");
        if (shouldDisplay != null || shouldDisplay.toLowerCase().equals("true")) {
            AttachDetachUtilities.printVMList();
        }
    }

    public void attach() throws AgentAttachException {
        if (this.getVMDisplayName() == null && this.getVMId() == null) {
            throw new AgentAttachException("Agent Attach Needs a valid Virtual Machine ID or Display Name Specified to Attach");
        }
        if (this.getAgentLocation() == null) {
            throw new AgentAttachException("Agent Attach Needs a valid Agent location to Attach");
        }
        AttachDetachUtilities.attach(this.getVMDisplayName(), this.getVMId(), this.getAgentLocation(), this.getAgentProfileLocation(), this.getRedefineClass(), null);
    }

    public void deactivate() {
        System.out.println("********Deactivate*************");
    }

    public void displayUsage() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\nPlease Specify the Paticular Property in order to Execute Agent Attach:\n");
        buffer.append("************************************************************************");
        buffer.append("\nDisplay VMs for Attach: com.wily.introscope.displayVirtualMachines\n");
        buffer.append("\nTurn on agent attach: com.wily.introscope.agentAttach\n");
        buffer.append("\nAttach agent to specific VM by id: com.wily.introscope.virtualMachineId\n");
        buffer.append("\nAttach agent to specific VM by name: com.wily.introscope.virtualMachineDisplayName\n");
        buffer.append("\nSpecify agent property: com.wily.introscope.agentProfile\n");
        buffer.append("\nSpecify agent location: com.wily.introscope.agentLocation\n");
        buffer.append("\nSpecify tools.jar location: com.wily.introscope.toolsLocation or add it in the wily tools directory\n");
        buffer.append("\nTo not execute class reinstrumentation then set com.wily.introscope.agentRedefineClasses to false\n");
        System.out.println(buffer);
    }

    private void loadClassTest() throws ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        classLoader.loadClass("com.sun.tools.attach.VirtualMachine");
        classLoader.loadClass("com.sun.tools.attach.VirtualMachineDescriptor");
    }

    public void loadTools() throws AgentAttachException {
        String toolsFilePath = System.getProperty("com.wily.introscope.toolsLocation");
        if (toolsFilePath != null) {
            try {
                File file = new File(toolsFilePath);
                if (!file.isFile() || file.getName().indexOf("tools.jar") < 0) {
                    throw new AgentAttachException("Please specify file name tools.jar for property com.wily.introscope.toolsLocation");
                }
                URL url = file.toURL();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.net.URLClassLoader");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Class<?> sysClazz = clazz;
                Class[] classArray = new Class[1];
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("java.net.URL");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz2;
                Method method = sysClazz.getDeclaredMethod("addURL", classArray);
                method.setAccessible(true);
                URLClassLoader sysLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
                method.invoke((Object)sysLoader, url);
            }
            catch (MalformedURLException mue) {
                throw new AgentAttachException(mue.getMessage(), mue);
            }
            catch (NoSuchMethodException nsme) {
                throw new AgentAttachException(nsme.getMessage(), nsme);
            }
            catch (InvocationTargetException ite) {
                throw new AgentAttachException(ite.getMessage(), ite);
            }
            catch (IllegalAccessException iae) {
                throw new AgentAttachException(iae.getMessage(), iae);
            }
            try {
                this.loadClassTest();
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new AgentAttachException("Jar tools.jar version does not support agent attach.  Please specify a valid tools.jar");
            }
        }
        try {
            this.loadClassTest();
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AgentAttachException("Jar tools.jar version does not support agent attach.  Please specify the path of the tools.jarlocation with property: com.wily.introscope.toolsLocation or add it in the wily tools directory");
        }
    }

    public static void main(String[] args) throws Exception {
        AgentCommand agentCommand = new AgentCommand();
        boolean success = false;
        try {
            agentCommand.loadTools();
            if (agentCommand.isVMDisplayOn()) {
                agentCommand.displayVMs();
                success = true;
            }
            if (agentCommand.isAgentAttachedOn() && agentCommand.isAgentDeactivatedOn()) {
                success = false;
                System.out.println("Please specify attach or detach agent and not both\n");
            } else if (agentCommand.isAgentAttachedOn()) {
                agentCommand.attach();
                success = true;
            } else if (agentCommand.isAgentDeactivatedOn()) {
                agentCommand.deactivate();
                success = true;
            }
            if (!success) {
                agentCommand.displayUsage();
            }
        }
        catch (AgentAttachException aae) {
            System.out.println("Agent Attaching Failed.");
            System.out.println(aae.getMessage());
            aae.printStackTrace();
            System.out.println();
            agentCommand.displayUsage();
        }
    }
}

