/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.autoprobe.loading;

import com.wily.diagnos.personality.ICompilerPersonality;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.autoprobe.loading.ADirectiveLoader;
import com.wily.introscope.autoprobe.loading.IDirectiveLoader;
import com.wily.util.resource.IResourceReader;
import com.wily.util.text.IStringLocalizer;
import java.io.File;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public abstract class ASignedDirectiveLoader
extends ADirectiveLoader
implements IDirectiveLoader {
    private Set publicKeys = this.getPublicKeys();
    private static final int kBufSize = 1024;
    public static byte[] tempBuf = new byte[1024];

    protected ASignedDirectiveLoader(IAgent agent, IStringLocalizer localizer, IResourceReader resourceReader, String path, String[] directivesFiles, ICompilerPersonality personality) {
        super(agent, localizer, resourceReader, path, directivesFiles, personality);
    }

    public List extractAndVerify(JarFile jarFile) {
        ArrayList verifiedEntries = new ArrayList();
        boolean isJarValid = true;
        Enumeration<JarEntry> jarEntries = jarFile.entries();
        while (jarEntries.hasMoreElements() && isJarValid) {
            JarEntry entry = jarEntries.nextElement();
            isJarValid &= this.verifySingleEntry(entry, jarFile, this.publicKeys, verifiedEntries);
        }
        if (!isJarValid) {
            verifiedEntries = null;
        }
        return verifiedEntries;
    }

    private boolean verifySingleEntry(JarEntry entry, JarFile file, Set keys, List verifiedList) {
        Certificate[] certs;
        boolean hasValidated = false;
        if (entry.isDirectory() || entry.getName().toLowerCase().startsWith("meta-inf")) {
            hasValidated = true;
        } else if (this.verifyStream(entry, file) && (certs = entry.getCertificates()) != null) {
            int i = 0;
            while (i < certs.length && !hasValidated) {
                Iterator it = keys.iterator();
                while (it.hasNext() && !hasValidated) {
                    try {
                        PublicKey key = (PublicKey)it.next();
                        certs[i].verify(key);
                        hasValidated = true;
                        verifiedList.add(entry);
                    }
                    catch (Exception exception) {}
                }
                ++i;
            }
        }
        if (!hasValidated) {
            this.getFeedback().warn(this.getLocalizer().IStringLocalizer_getFormattedLocalizedString("Directive_Loader_Validation_Failed_No_Key_Match", entry.getName()));
        }
        return hasValidated;
    }

    /*
     * Exception decompiling
     */
    private boolean verifyStream(JarEntry entry, JarFile file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 78->81)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Set getPublicKeys() {
        HashSet<PublicKey> result = new HashSet<PublicKey>();
        try {
            File thisJarFile = new File(this.getPath());
            JarFile jFile = new JarFile(thisJarFile);
            Enumeration<JarEntry> entries = jFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                this.verifyStream(entry, jFile);
                Certificate[] certs = entry.getCertificates();
                if (certs == null) continue;
                int i = 0;
                while (i < certs.length) {
                    result.add(certs[i].getPublicKey());
                    ++i;
                }
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                this.getFeedback().error("An exception occurred getting public keys.");
                this.getFeedback().verbose(t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
        return result;
    }
}

