/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.install;

import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.text.IStringLocalizer;
import com.wily.util.version.IVersion;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Locale;

public class IntroscopeInstallation {
    private static final String sFileSeparator = System.getProperty("file.separator");
    private String fFullyQualifiedBaseDir;

    public IntroscopeInstallation(String installBaseDirPath) throws IOException {
        File installBaseDir = new File(installBaseDirPath);
        if (!installBaseDir.exists() || !installBaseDir.isDirectory()) {
            throw new FileNotFoundException("Introscope Install directory not found at: " + installBaseDirPath);
        }
        this.fFullyQualifiedBaseDir = installBaseDir.getAbsolutePath();
    }

    public IntroscopeInstallation() throws IOException {
        this(System.getProperty("com.wily.introscope.installPath", "."));
    }

    public File getInstallationRootDirectory() {
        return this.getInstallationSubDirectory(0);
    }

    public String getInstallationRootDirectoryPath() {
        return this.fFullyQualifiedBaseDir;
    }

    public String getInstallationSubDirectoryPath(int whichDirectory) {
        String path = this.getRootInstallPath();
        switch (whichDirectory) {
            case 0: {
                break;
            }
            case 1: {
                path = String.valueOf(path) + sFileSeparator + "bin";
                break;
            }
            case 2: {
                path = String.valueOf(path) + sFileSeparator + "lib";
                break;
            }
            case 15: {
                path = String.valueOf(path) + sFileSeparator + "license";
                break;
            }
            case 21: {
                path = String.valueOf(path) + sFileSeparator + "images";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                path = String.valueOf(path) + sFileSeparator + "help";
                String lang = Locale.getDefault().getLanguage();
                File helpFolder = new File(String.valueOf(path) + sFileSeparator + lang);
                if (!helpFolder.isDirectory()) break;
                path = String.valueOf(path) + sFileSeparator + lang;
                break;
            }
            case 19: {
                path = String.valueOf(path) + sFileSeparator + "snmp";
                break;
            }
            case 14: {
                path = String.valueOf(path) + sFileSeparator + "examples";
                break;
            }
            case 22: {
                path = String.valueOf(path) + sFileSeparator + "ext";
                break;
            }
            case 24: {
                path = String.valueOf(path) + sFileSeparator + "reports";
                break;
            }
            case 25: {
                path = String.valueOf(path) + sFileSeparator + "scripts";
                break;
            }
            default: {
                path = String.valueOf(path) + sFileSeparator + "config";
                path = this.getConfigSubDirectoryPath(path, whichDirectory);
            }
        }
        return path;
    }

    public String getConfigSubDirectoryPath(String configPath, int whichDirectory) {
        String path = configPath;
        switch (whichDirectory) {
            case 6: {
                break;
            }
            case 8: {
                path = String.valueOf(path) + sFileSeparator + "modules";
                break;
            }
            case 9: {
                path = String.valueOf(path) + sFileSeparator + "modules-backup";
                break;
            }
            case 10: {
                path = String.valueOf(path) + sFileSeparator + "internal";
                break;
            }
            case 12: {
                path = String.valueOf(path) + sFileSeparator + "internal" + sFileSeparator + "console";
                break;
            }
            case 11: {
                path = String.valueOf(path) + sFileSeparator + "internal" + sFileSeparator + "logs";
                break;
            }
            case 13: {
                path = String.valueOf(path) + sFileSeparator + "shutoff";
                break;
            }
            case 16: {
                path = String.valueOf(path) + sFileSeparator + "systempbd";
                break;
            }
            case 17: {
                path = String.valueOf(path) + sFileSeparator + "custompbd";
                break;
            }
            case 20: {
                path = String.valueOf(path) + sFileSeparator + "internal" + sFileSeparator + "server";
                break;
            }
            case 18: {
                path = String.valueOf(path) + sFileSeparator + "internal" + sFileSeparator + "server" + sFileSeparator + "snmp";
                break;
            }
            case 26: {
                path = String.valueOf(path) + sFileSeparator + "internal" + sFileSeparator + "server" + sFileSeparator + "scripts";
                break;
            }
            case 27: {
                path = String.valueOf(path) + sFileSeparator + "internal" + sFileSeparator + "server" + sFileSeparator + "users";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected key " + whichDirectory);
            }
        }
        return path;
    }

    public File getConfigSubDirectory(String configPath, int whichDirectory) {
        return new File(this.getConfigSubDirectoryPath(configPath, whichDirectory));
    }

    public File getInstallationSubDirectory(int whichDirectory) {
        return new File(this.getInstallationSubDirectoryPath(whichDirectory));
    }

    public File getWizardSystemDirectivesDirectory() {
        return new File(this.getInstallationSubDirectoryPath(16));
    }

    public File getWizardCustomDirectivesDirectory() {
        return new File(this.getInstallationSubDirectoryPath(17));
    }

    private String getRootInstallPath() {
        return this.fFullyQualifiedBaseDir;
    }

    public void writeInstallationBanner(IStringLocalizer localizer, IModuleFeedbackChannel feedback, String productName, IVersion version) {
        feedback.info(localizer.IStringLocalizer_getFormattedLocalizedString("FormattedIntroscopeInstallationRootDirectoryString", this.getInstallationRootDirectoryPath()));
    }
}

