/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.soa.wm.tn.agent.tracers;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.soaextension.webmethods.util.WMUtils;
import com.wily.util.properties.AttributeListing;

public class TNServiceExecutionTracer
extends ASingleInstanceTracerFactory {
    public TNServiceExecutionTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public void ITracer_finishTrace(int arg0, InvocationData data) {
        long responseTime = data.getWallClockElapsedTime();
        String componentname = this.formatParameterizedName(data);
        DataAccumulatorFactory factory = this.getAgent().IAgent_getDataAccumulatorFactory();
        String probeMethodName = data.getProbeInformation().getProbeIdentification().getProbeMethodName();
        String strARTMetricname = String.valueOf(componentname) + "|" + probeMethodName + ":Average Response Time (ms)";
        factory.safeGetLongAverageDataAccumulator(strARTMetricname).ILongAggregatingDataAccumulator_recordDataPoint(responseTime);
        String strRPIMetricname = String.valueOf(componentname) + "|" + probeMethodName + ":Responses Per Interval";
        factory.safeGetLongIntervalCounterDataAccumulator(strRPIMetricname).ILongIntervalCounterDataAccumulator_addSingleIncident();
        try {
            Object objTask = data.getInvocationObject();
            Object objPending = objTask.getClass().getMethod("isPending", new Class[0]).invoke(objTask, new Object[0]);
            if (objPending != null) {
                Boolean cfr_ignored_0 = (Boolean)objPending;
            }
            if ((objPending = objTask.getClass().getMethod("isComplete", new Class[0]).invoke(objTask, new Object[0])) != null && ((Boolean)objPending).booleanValue()) {
                strRPIMetricname = String.valueOf(componentname) + ":Tasks Completed  Per Interval";
                factory.safeGetLongIntervalCounterDataAccumulator(strRPIMetricname).ILongIntervalCounterDataAccumulator_addSingleIncident();
            }
            if ((objPending = objTask.getClass().getMethod("isFailed", new Class[0]).invoke(objTask, new Object[0])) != null && ((Boolean)objPending).booleanValue()) {
                strRPIMetricname = String.valueOf(componentname) + ":Task Failures Per Interval";
                factory.safeGetLongIntervalCounterDataAccumulator(strRPIMetricname).ILongIntervalCounterDataAccumulator_addSingleIncident();
            }
        }
        catch (Exception e) {
            WMUtils.getLogger().error((Throwable)e);
        }
    }

    public void ITracer_startTrace(int arg0, InvocationData data) {
        try {
            data.storeWallClockStartTime();
        }
        catch (Exception e) {
            WMUtils.getLogger().error((Throwable)e);
        }
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }
}

