/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.soa.wm.tn.agent.tracers;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.soaextension.webmethods.util.WMUtils;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.Field;

public class TNServiceThreadTracer
extends ASingleInstanceTracerFactory {
    public TNServiceThreadTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    private Field getServiceField(Object objInvocationObject) throws SecurityException, NoSuchFieldException {
        Field fldService = null;
        try {
            fldService = objInvocationObject.getClass().getDeclaredField("service");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            fldService = objInvocationObject.getClass().getSuperclass().getDeclaredField("service");
        }
        return fldService;
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        try {
            Object objInvocationObject = data.getInvocationObject();
            Field fldNSService = this.getServiceField(objInvocationObject);
            fldNSService.setAccessible(true);
            Object objNSName = fldNSService.get(objInvocationObject);
            if (objNSName == null || !objNSName.toString().equals("wm.tn.route:invokeWrapper")) {
                WMUtils.getLogger().debug("TNServiceThreadTracer.Does not match NSName as wm.tn.route:invokeWrapper..Hence return");
                data.put("tn-service-thread", (Object)"N");
                return;
            }
            data.put("tn-service-thread", (Object)"Y");
            data.storeWallClockStartTime();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        String isTNServiceThread = (String)data.get("tn-service-thread");
        if (isTNServiceThread != null && isTNServiceThread.equals("Y")) {
            long responseTime = data.getWallClockElapsedTime();
            String componentname = this.formatParameterizedName(data);
            DataAccumulatorFactory factory = this.getAgent().IAgent_getDataAccumulatorFactory();
            WMUtils.getLogger().debug("TNServiceThreadTracer.ITracer_finishTrace():" + data.getProbeInformation().getTracerCount());
            String strARTMetricname = String.valueOf(componentname) + ":Average Response Time (ms)";
            factory.safeGetLongAverageDataAccumulator(strARTMetricname).ILongAggregatingDataAccumulator_recordDataPoint(responseTime);
            String strRPIMetricname = String.valueOf(componentname) + ":Responses Per Interval";
            factory.safeGetLongIntervalCounterDataAccumulator(strRPIMetricname).ILongIntervalCounterDataAccumulator_addSingleIncident();
        }
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }
}

