/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.webmethods.bproc.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.errors.ErrorSnapshotFeatureFactory;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.spec.metric.ESEException;
import com.wily.soaextension.webmethods.bproc.BPCache;
import com.wily.soaextension.webmethods.util.WMUtils;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;

public class BPMethodExceptionTracer
extends ASingleInstanceTracerFactory {
    private static final String kProbeMethod_handleSubprocessDone = "handleSubprocessDone";
    private static final String kProbeMethod_requestFail = "requestFail";
    private static final String kProbeMethod_handleServiceError = "handleServiceError";
    private static final String kProbeMethod_invokeWrapper = "invokeWrapper";
    private IAgent fAgent;

    public BPMethodExceptionTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.fAgent = agent;
    }

    public void ITracer_finishTrace(int i, InvocationData data) {
        String strProbeMethodName = null;
        DataAccumulatorFactory factory = null;
        try {
            factory = this.getDataAccumulatorFactory();
            strProbeMethodName = data.getProbeInformation().getProbeIdentification().getProbeMethodName();
            if (strProbeMethodName.equals(kProbeMethod_invokeWrapper)) {
                WMUtils.getLogger().debug("BPMethodExceptionTracer.ITracer_finishTrace, invokeWrapper has been invoked");
                if (data.hasInvocationThrownException()) {
                    Throwable error = data.getInvocationThrownException();
                    String errorMessage = error.getMessage();
                    String name = this.formatParameterizedName(data);
                    if (ErrorSnapshotFeatureFactory.flagErrorInManagedApplication((String)errorMessage)) {
                        this.getAgent().IAgent_getComponentTracer().noteBoundaryError();
                        WMUtils.getLogger().debug("BPMethodExceptionTracer.ITracer_finishTrace Adding Snapshot from invokeWrapper");
                    }
                    factory.getLongIntervalCounterDataAccumulator(name).ILongIntervalCounterDataAccumulator_addSingleIncident();
                    WMUtils.getLogger().debug("BPMethodExceptionTracer.ITracer_finishTrace Adding EPI for invokeWrapper" + name);
                }
            } else if (strProbeMethodName.equals(kProbeMethod_handleServiceError)) {
                WMUtils.getLogger().debug("BPMethodExceptionTracer.ITracer_finishTrace, handleServiceError has been invoked");
                Throwable error = (Throwable)data.getInvocationParameterAsObject(0);
                String name = this.formatParameterizedName(data);
                String errorMessage = error.getMessage();
                if (ErrorSnapshotFeatureFactory.flagErrorInManagedApplication((String)errorMessage)) {
                    this.getAgent().IAgent_getComponentTracer().noteBoundaryError();
                    WMUtils.getLogger().debug("BPMethodExceptionTracer.ITracer_finishTrace Adding Snapshot from handleServiceError");
                    factory.getLongIntervalCounterDataAccumulator(name).ILongIntervalCounterDataAccumulator_addSingleIncident();
                    WMUtils.getLogger().debug("BPMethodExceptionTracer.ITracer_finishTrace Adding EPI for handleServiceError " + name);
                }
                WMUtils.getLogger().debug("BPMethodExceptionTracer.ITracer_finishTrace stopped EPI for handleServiceError " + name);
            } else if (strProbeMethodName.equals(kProbeMethod_requestFail)) {
                WMUtils.getLogger().debug("BPMethodExceptionTracer.ITracer_finishTrace, requestFail has been invoked");
                String strMetricResourceName = this.formatParameterizedName(data);
                if (!strMetricResourceName.contains("UnknownStep")) {
                    String EPIMetric = String.valueOf(strMetricResourceName) + ":" + "Errors Per Interval";
                    factory.safeGetLongIntervalCounterDataAccumulator(EPIMetric).ILongIntervalCounterDataAccumulator_addSingleIncident();
                    WMUtils.getLogger().debug("BPMethodExceptionTracer.ITracer_finishTrace Adding EPI for requestFail" + EPIMetric);
                }
            }
        }
        catch (ESEException eSEException) {
            Assertion.wilyFail((String)"Metric type conflict");
        }
        catch (Throwable t) {
            WMUtils.handleError(this.fAgent, "ERROR_IN_BPMETHODEXCEPTIONTRACER", t);
        }
    }

    public void ITracer_startTrace(int i, InvocationData data) {
        String strProbeMethodName = data.getProbeInformation().getProbeIdentification().getProbeMethodName();
        if (strProbeMethodName.equals(kProbeMethod_handleSubprocessDone)) {
            BPCache.setStepId((String)data.getInvocationParameterAsObject(3));
        }
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }
}

