/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.webmethods.webservices.nameformatter;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.INameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.soaextension.webmethods.util.WMUtils;
import com.wily.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class WSFaultNameFormatter
implements INameFormatter {
    private IAgent fAgent;

    public WSFaultNameFormatter(IAgent agent) {
        this.fAgent = agent;
    }

    protected IAgent getAgent() {
        return this.fAgent;
    }

    public String INameFormatter_format(String name, InvocationData data) {
        try {
            String wsname = "";
            String operation = "";
            Object wsdObj = null;
            String soapactionObj = null;
            wsdObj = data.getInvocationParameterAsObject(3);
            soapactionObj = (String)data.getInvocationParameterAsObject(6);
            name = this.getWsName(name, wsname, operation, wsdObj, soapactionObj);
        }
        catch (Exception e) {
            WMUtils.handleError(this.getAgent(), "ERROR_IN_NAMEFORMATTER", e);
            WMUtils.getLogger().debug("Error in Nameformatter:" + e.getMessage());
        }
        return name;
    }

    protected String getWsName(String name, String wsname, String operation, Object wsdObj, Object soapactionObj) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        if (wsdObj != null && soapactionObj != null) {
            Class[] clArr = new Class[]{String.class};
            Object[] obArr = new Object[]{soapactionObj};
            Method binderMth = WMUtils.getFindBinderonWSD(wsdObj, clArr);
            Object binderObj = binderMth.invoke(wsdObj, obArr);
            Method targetNS = WMUtils.getTargetNSonWSD(wsdObj);
            wsname = (String)targetNS.invoke(wsdObj, new Object[0]);
            if (binderObj != null) {
                operation = (String)WMUtils.invokeDeclaredMethodOnObject(binderObj, "findOperationName", clArr, obArr);
            } else {
                WMUtils.getLogger().debug("Got Binder Object as null");
            }
        } else {
            WMUtils.getLogger().debug("WSD Object or SoapAction Object is null");
        }
        WMUtils.getLogger().debug("WSFaultNameFormatter Server::WebService Namespace:" + wsname);
        WMUtils.getLogger().debug("WSFaultNameFormatter Server::WebService Operation:" + operation);
        if (name.indexOf("{namespace}", 0) >= 0) {
            if ((wsname = WMUtils.formatToBeResourceSafe(wsname)) == null || wsname.equals("")) {
                wsname = "UnknownService";
            }
            name = StringUtils.replace((String)name, (String)"{namespace}", (String)wsname);
        }
        if (name.indexOf("{operationname}", 0) >= 0) {
            if ((operation = WMUtils.formatToBeResourceSafe(operation)) == null || operation.equals("")) {
                operation = "UnknownOperation";
            }
            name = StringUtils.replace((String)name, (String)"{operationname}", (String)operation);
        }
        return name;
    }
}

