/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class LazyMap
implements Map {
    private static final DoWithKeyValue createEntry = new DoWithKeyValue(){

        public Object doWithKeyValue(Object key, Object value) {
            return new LazyMapEntry(key, value);
        }
    };
    private static final DoWithKeyValue createValue = new DoWithKeyValue(){

        public Object doWithKeyValue(Object key, Object value) {
            return value;
        }
    };
    public static final Object NULL = new Object();
    private final ILazyMapProvider provider;
    private final Set fAdditionalKeys;
    private final Set fKeys;
    protected volatile Map fMap;
    private volatile boolean hasBeenDevirtualized = false;
    private volatile int devirtualizedElementsCount = 0;
    private final boolean hasStrictKeyCheck;
    private volatile int staticSize;

    public LazyMap(ILazyMapProvider provider) {
        this(provider, new HashMap(), new HashSet(), true);
    }

    public LazyMap(ILazyMapProvider provider, Map map) {
        this(provider, map, new HashSet(), true);
    }

    public LazyMap(ILazyMapProvider provider, Map map, Set additionalKeys, boolean hasStrictKeyCheckAndSize) {
        this.provider = provider;
        this.fMap = map;
        this.fAdditionalKeys = additionalKeys;
        this.hasStrictKeyCheck = hasStrictKeyCheckAndSize;
        this.fKeys = provider.getKeySet();
        if (!hasStrictKeyCheckAndSize) {
            provider.warn("Lazy map initialized with not strict check on keys. Size() method will not be reliable");
        }
    }

    public LazyMap(ILazyMapProvider provider, Set additionalKeys) {
        this(provider, new HashMap(), additionalKeys, true);
    }

    public int size() {
        if (this.hasBeenDevirtualized) {
            return this.fMap.size();
        }
        return this.fMap.size() + this.getStaticSize() - this.devirtualizedElementsCount;
    }

    private int getStaticSize() {
        if (this.staticSize == 0) {
            this.staticSize = this.fKeys.size() + this.fAdditionalKeys.size();
        }
        return this.staticSize;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean containsKey(Object key) {
        return this.fMap.containsKey(key) || this.containsVirtualKey(key);
    }

    private boolean containsVirtualKey(Object key) {
        return this.fAdditionalKeys.contains(key) || this.fKeys.contains(key);
    }

    public boolean containsValue(Object value) {
        this.provider.warn("containsValue is not implemented");
        return false;
    }

    public Object get(Object key) {
        if (this.fMap.containsKey(key)) {
            Object inTheMap = this.fMap.get(key);
            if (inTheMap == NULL) {
                return null;
            }
            return inTheMap;
        }
        if (this.hasStrictKeyCheck) {
            if (this.containsVirtualKey(key)) {
                try {
                    Object inTheProvider = this.provider.get(key);
                    if (inTheProvider == null) {
                        this.fMap.put(key, NULL);
                    } else {
                        this.fMap.put(key, inTheProvider);
                    }
                    ++this.devirtualizedElementsCount;
                    return inTheProvider;
                }
                catch (DoesNotHaveTheKeyException doesNotHaveTheKeyException) {
                    this.provider.warn("The key " + key + " is marked in the virtual set of keys but it has not been satisfied by the virtual provider");
                    return null;
                }
            }
            return null;
        }
        try {
            Object inTheProvider = this.provider.get(key);
            if (inTheProvider == null) {
                this.fMap.put(key, NULL);
            } else {
                this.fMap.put(key, inTheProvider);
            }
            ++this.devirtualizedElementsCount;
            return inTheProvider;
        }
        catch (DoesNotHaveTheKeyException doesNotHaveTheKeyException) {
            return null;
        }
    }

    public Object put(Object key, Object value) {
        Object result = this.fMap.put(key, value);
        if (this.hasStrictKeyCheck && this.containsVirtualKey(key) && result == null) {
            ++this.devirtualizedElementsCount;
        }
        return result;
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException("LazyMap does not support remove");
    }

    public void putAll(Map t) {
        this.fMap.putAll(t);
    }

    public void clear() {
        this.hasBeenDevirtualized = false;
        this.devirtualizedElementsCount = 0;
        this.fMap.clear();
    }

    public Set keySet() {
        HashSet result = new HashSet();
        result.addAll(this.fMap.keySet());
        result.addAll(this.fAdditionalKeys);
        result.addAll(this.fKeys);
        return result;
    }

    protected Set getProviderKeys() {
        return this.fKeys;
    }

    protected Set getAdditionalKeys() {
        return this.fAdditionalKeys;
    }

    public Collection values() {
        return this.deVirtualize(createValue);
    }

    private Set deVirtualize(DoWithKeyValue createValue) {
        Object value;
        Object key;
        this.hasBeenDevirtualized = true;
        HashSet<Object> result = new HashSet<Object>();
        HashSet addedKeys = new HashSet();
        Iterator<Object> i = this.fKeys.iterator();
        while (i.hasNext()) {
            key = i.next();
            value = this.get(key);
            addedKeys.add(key);
            if (value == null || value == NULL) continue;
            result.add(createValue.doWithKeyValue(key, value));
        }
        i = this.fAdditionalKeys.iterator();
        while (i.hasNext()) {
            key = i.next();
            value = this.get(key);
            addedKeys.add(key);
            if (value == null || value == NULL) continue;
            result.add(createValue.doWithKeyValue(key, value));
        }
        i = this.fMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = (Map.Entry)i.next();
            if (addedKeys.contains(e.getKey())) continue;
            result.add(createValue.doWithKeyValue(e.getKey(), e.getValue()));
        }
        return result;
    }

    public Set entrySet() {
        return this.deVirtualize(createEntry);
    }

    public void changeMap(Map newSupportMap) {
        if (newSupportMap == this) {
            throw new IllegalArgumentException("Cannot have myself as support map");
        }
        newSupportMap.putAll(this.fMap);
        this.fMap = newSupportMap;
        this.hasBeenDevirtualized = false;
        this.devirtualizedElementsCount = 0;
    }

    private static abstract class DoWithKeyValue {
        private DoWithKeyValue() {
        }

        public abstract Object doWithKeyValue(Object var1, Object var2);
    }

    public static final class DoesNotHaveTheKeyException
    extends Exception {
    }

    public static interface ILazyMapProvider {
        public void warn(String var1);

        public Set getKeySet();

        public Object get(Object var1) throws DoesNotHaveTheKeyException;
    }

    private static final class LazyMapEntry
    implements Map.Entry {
        final Object key;
        final Object value;

        LazyMapEntry(Object k, Object v) {
            this.key = k;
            this.value = v;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            return value;
        }
    }
}

