/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.extension;

import com.wily.util.extension.JarExtension;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.io.ExtendedFile;
import com.wily.util.properties.IndexedProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;

public final class EagerAllPermissionsClassLoader
extends JarExtension.AllPermissionsClassLoader {
    private static final String kExtensionFileSuffix = ".jar";
    private static final String kClassListFileSuffix = ".cls";
    private static final String kForceRewriteClassListProperty = "introscope.agent.extensions.eagerloader";
    private static final String kForceRewriteClassListPropertyEnabled = "enabled";
    private static final String kForceRewriteClassListPropertyDisabled = "disabled";
    private static final String kForceRewriteClassListPropertyBuild = "build";
    private static final String kForceRewriteClassListPropertyRegenerate = "regenerate";
    private static final String kForceRewriteClassListPropertyCached = "cached";
    public static volatile boolean sIsEagerClassLoaderEnabled;
    private static volatile boolean sIsRegenerateBuildClassList;
    private static volatile boolean sIsRegenerateNewClassList;
    private static volatile boolean sIsCached;
    private ExtendedFile fExtensionFile;
    private PrintStream fOutStream = null;
    private volatile boolean fClassListLoaded = false;
    private volatile boolean fSaveLoadedClasses;
    private volatile int fRepeatedClassCount = 0;
    private HashMap fAlreadyLoadedClasses;
    private Object fLock;
    private IModuleFeedbackChannel fFeedback;

    public static void setProperties(IndexedProperties properties) {
        String sysPropVal = System.getProperty(kForceRewriteClassListProperty);
        sIsEagerClassLoaderEnabled = !kForceRewriteClassListPropertyDisabled.equalsIgnoreCase(sysPropVal);
        sIsRegenerateBuildClassList = kForceRewriteClassListPropertyBuild.equalsIgnoreCase(sysPropVal);
        sIsRegenerateNewClassList = kForceRewriteClassListPropertyRegenerate.equalsIgnoreCase(sysPropVal);
        sIsCached = kForceRewriteClassListPropertyCached.equalsIgnoreCase(sysPropVal);
        if (sysPropVal == null && properties != null) {
            String propVal = properties.getProperty(kForceRewriteClassListProperty, kForceRewriteClassListPropertyEnabled);
            sIsEagerClassLoaderEnabled = !kForceRewriteClassListPropertyDisabled.equalsIgnoreCase(propVal);
            sIsCached = kForceRewriteClassListPropertyCached.equalsIgnoreCase(propVal);
        }
    }

    public EagerAllPermissionsClassLoader(URL[] classpath, ClassLoader parent, ExtendedFile extensionFile, IModuleFeedbackChannel feedback) {
        super(classpath, parent);
        this.fExtensionFile = extensionFile;
        this.fAlreadyLoadedClasses = null;
        this.fLock = new Object();
        this.fFeedback = feedback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preLoadClasses() {
        Object object = this.fLock;
        synchronized (object) {
            if (!this.fClassListLoaded) {
                if (sIsCached || sIsRegenerateBuildClassList || sIsRegenerateNewClassList) {
                    this.fAlreadyLoadedClasses = new HashMap(100);
                }
                this.fClassListLoaded = true;
                this.fSaveLoadedClasses = this.loadListOfForcedClassNames();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object;
        Class clazz = null;
        if (sIsCached) {
            object = this.fLock;
            synchronized (object) {
                if (!this.fSaveLoadedClasses && this.fClassListLoaded) {
                    clazz = (Class)this.fAlreadyLoadedClasses.get(name);
                }
            }
        }
        if (clazz == null) {
            clazz = super.loadClass(name, resolve);
        }
        if (this.fSaveLoadedClasses && clazz != null) {
            object = this.fLock;
            synchronized (object) {
                if (!this.fAlreadyLoadedClasses.containsKey(name)) {
                    this.fAlreadyLoadedClasses.put(name, null);
                    this.saveForcedClassName(name);
                } else {
                    ++this.fRepeatedClassCount;
                }
            }
        }
        return clazz;
    }

    private boolean loadListOfForcedClassNames() {
        String extensionFilePath = this.fExtensionFile.getAbsolutePath();
        String extensionFileName = this.fExtensionFile.getName();
        int suffixIndex = extensionFilePath.length();
        if (extensionFilePath.endsWith(kExtensionFileSuffix)) {
            suffixIndex -= kExtensionFileSuffix.length();
        }
        String classListFilePath = extensionFilePath.substring(0, suffixIndex).concat(kClassListFileSuffix);
        File forcedClassNames = new File(classListFilePath);
        BufferedReader stream = null;
        boolean internal = false;
        boolean regenerate = false;
        if (sIsRegenerateBuildClassList) {
            internal = true;
            regenerate = true;
        } else if (sIsRegenerateNewClassList) {
            regenerate = true;
        }
        if (!regenerate) {
            try {
                if (!forcedClassNames.canRead()) {
                    String classListFileName = forcedClassNames.getName();
                    InputStream resStream = this.getResourceAsStream(classListFileName);
                    if (resStream != null) {
                        stream = new BufferedReader(new InputStreamReader(resStream));
                    }
                } else {
                    stream = new BufferedReader(new FileReader(forcedClassNames));
                }
            }
            catch (FileNotFoundException e) {
                this.fFeedback.error(e);
            }
        }
        if (stream != null) {
            try {
                String line = stream.readLine();
                int loaded = 0;
                int total = 0;
                while (line != null) {
                    if (line.startsWith("#")) {
                        line = stream.readLine();
                        continue;
                    }
                    try {
                        ++total;
                        Class<?> clazz = Class.forName(line, false, this);
                        if (sIsCached && this.fAlreadyLoadedClasses != null) {
                            this.fAlreadyLoadedClasses.put(line, clazz);
                        }
                        ++loaded;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        this.fFeedback.debug("EagerClassLoader(" + extensionFileName + "): NoClassDefFoundError loading " + line);
                    }
                    catch (ClassCircularityError classCircularityError) {
                        this.fFeedback.debug("EagerClassLoader(" + extensionFileName + "): ClassCircularityError loading " + line);
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        this.fFeedback.debug("EagerClassLoader(" + extensionFileName + "): UnsatisfiedLinkError loading " + line);
                    }
                    line = stream.readLine();
                }
                this.fFeedback.info("EagerClassLoader(" + extensionFileName + "): Pre-loaded " + loaded + " classes.");
                this.fFeedback.debug("EagerClassLoader(" + extensionFileName + "): Failed to pre-load " + (total - loaded) + " classes.");
                stream.close();
            }
            catch (IOException e) {
                this.fFeedback.error(e);
            }
            return false;
        }
        try {
            FileOutputStream outStream = new FileOutputStream(forcedClassNames);
            this.fOutStream = new PrintStream(outStream);
            this.writeClassFileHeader(extensionFileName, internal);
            this.fFeedback.info("EagerClassLoader(" + extensionFileName + "): Running in discovery mode.");
            this.fFeedback.info("EagerClassLoader(" + extensionFileName + "): Saving class list to " + forcedClassNames);
        }
        catch (FileNotFoundException e) {
            this.fFeedback.error(e);
        }
        return true;
    }

    private void saveForcedClassName(String name) {
        if (this.fOutStream != null) {
            this.fOutStream.println(name);
            this.fOutStream.flush();
        }
    }

    private void writeClassFileHeader(String extensionName, boolean internal) {
        this.fOutStream.println("########################################################################");
        this.fOutStream.println("# Introscope Agent Extension Class Loader Pre-load Class List File");
        this.fOutStream.println("#");
        if (internal) {
            this.fOutStream.println("# @@@INTROSCOPE_FULL_RELEASE_NAME_PLACE_HOLDER@@@");
            this.fOutStream.println("# @@@INTROSCOPE_COPYRIGHT_STRING_PLACE_HOLDER@@@");
            this.fOutStream.println("# @@@INTROSCOPE_REGISTERED_TRADEMARK_STRING_PLACE_HOLDER@@@");
        } else {
            this.fOutStream.println("# CA Wily Introscope(R) ");
            this.fOutStream.println("# Copyright (c) 2012 CA. All Rights Reserved.");
            this.fOutStream.println("# Introscope(R) is a registered trademark of CA.");
        }
        this.fOutStream.println("#");
        this.fOutStream.println("# Generated for " + extensionName + " on " + new Date().toString());
        this.fOutStream.println("########################################################################");
    }
}

