/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;

public class StreamCopier {
    private static final int kChunkSize = 4096;

    public static void copy(InputStream in, OutputStream out) throws IOException {
        StreamCopier.copy(in, out, 4096);
    }

    public static void copy(InputStream in, OutputStream out, int chunkSize) throws IOException {
        byte[] buffer = new byte[chunkSize];
        int readSize = 0;
        try {
            do {
                if ((readSize = in.read(buffer)) == -1) continue;
                out.write(buffer, 0, readSize);
                out.flush();
            } while (readSize != -1);
        }
        catch (EOFException eOFException) {}
    }

    public static void copy(InputStreamReader in, StringWriter out) throws IOException {
        char[] buffer = new char[4096];
        int readSize = 0;
        do {
            if ((readSize = in.read(buffer, 0, buffer.length)) == -1) continue;
            out.write(buffer, 0, readSize);
        } while (readSize != -1);
        out.flush();
    }
}

