/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.task;

import com.wily.util.task.AsynchExecutionQueue;
import com.wily.util.task.IExecutionQueue;
import com.wily.util.task.ITask;
import com.wily.util.task.ITaskCompletionHandler;
import com.wily.util.task.TaskAlreadyStartedException;
import com.wily.util.task.TaskException;
import com.wily.util.task.TaskStillRunningException;
import com.wily.util.thread.DefaultThreadFactory;
import com.wily.util.thread.IThreadFactory;
import java.util.Enumeration;
import java.util.Vector;

public abstract class ATask
implements ITask {
    private static final String kTaskThreadName = "Task Thread";
    private static final String kNoCurrentTaskThread = "There is not a current task thread";
    protected static final int kNewState = 0;
    protected static final int kRunningState = 1;
    protected static final int kFinishedState = 2;
    protected static final int kExceptionState = 3;
    private int fState;
    private Thread fTaskThread;
    private Vector fTaskCompletionHandlers;
    private TaskException fTaskException;
    private IExecutionQueue fExecutionQueue;
    private final Object fQueueLock = new TaskQueueLock();
    private final Object fStateLock = new TaskStateLock();

    public ATask() {
        this.initialize();
    }

    private Object getQueueLock() {
        return this.fQueueLock;
    }

    protected Object getStateLock() {
        return this.fStateLock;
    }

    protected void initialize() {
        this.fState = 0;
        this.fTaskThread = null;
        this.fTaskException = null;
    }

    public synchronized void ITask_startTask() throws TaskAlreadyStartedException {
        this.ITask_startTask(kTaskThreadName, false);
    }

    public synchronized void ITask_startTask(boolean isDaemon) throws TaskAlreadyStartedException {
        this.ITask_startTask(kTaskThreadName, isDaemon);
    }

    public synchronized void ITask_startTask(String name, boolean isDaemon) throws TaskAlreadyStartedException {
        this.ITask_startTask(name, new DefaultThreadFactory(isDaemon));
    }

    public synchronized void ITask_startTask(String name, IThreadFactory factory) throws TaskAlreadyStartedException {
        if (this.fTaskThread != null) {
            throw new TaskAlreadyStartedException();
        }
        this.fTaskThread = factory.IThreadFactory_createNewThread(name, new CoreTask());
        this.fTaskThread.start();
    }

    protected abstract void doTask() throws TaskException;

    public boolean ITask_isStarted() {
        return this.fTaskThread != null;
    }

    public boolean ITask_wasSuccessful() {
        return this.getState() == 2;
    }

    public boolean ITask_wasFailed() {
        return this.getState() == 3;
    }

    public boolean ITask_isCompleted() {
        int state = this.getState();
        return this.isFinishedState(state);
    }

    public TaskException ITask_getException() {
        return this.fTaskException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ITask_resetTask() throws TaskStillRunningException {
        Object object = this.getStateLock();
        synchronized (object) {
            if (this.ITask_isStarted() && !this.ITask_isCompleted()) {
                throw new TaskStillRunningException();
            }
            this.initialize();
        }
    }

    public synchronized void ITask_addTaskCompletionHandler(ITaskCompletionHandler taskCompletionHandler) {
        if (this.fTaskCompletionHandlers == null) {
            this.fTaskCompletionHandlers = new Vector(1);
        }
        this.fTaskCompletionHandlers.addElement(taskCompletionHandler);
    }

    void notifyTaskCompletionHandlers() {
        if (this.fTaskCompletionHandlers != null) {
            Enumeration taskCompletionHandlers = this.fTaskCompletionHandlers.elements();
            while (taskCompletionHandlers.hasMoreElements()) {
                ITaskCompletionHandler taskCompletionHandler = (ITaskCompletionHandler)taskCompletionHandlers.nextElement();
                this.notifyCompletionHandler(taskCompletionHandler);
            }
        }
    }

    protected void notifyCompletionHandler(ITaskCompletionHandler handler) {
        switch (this.getState()) {
            case 2: {
                handler.ITaskCompletionHandler_taskFinished();
                break;
            }
            case 3: {
                handler.ITaskCompletionHandler_taskFailed(this.fTaskException);
            }
        }
    }

    protected boolean isValidState(int state) {
        return state >= 0 && state <= 3;
    }

    protected synchronized int getPriority() {
        if (this.fTaskThread == null) {
            throw new IllegalArgumentException(kNoCurrentTaskThread);
        }
        return this.fTaskThread.getPriority();
    }

    protected synchronized void setPriority(int newPriority) {
        if (this.fTaskThread == null) {
            throw new IllegalArgumentException(kNoCurrentTaskThread);
        }
        this.fTaskThread.setPriority(newPriority);
    }

    protected synchronized void interruptTask() {
        if (this.fTaskThread == null) {
            throw new IllegalArgumentException(kNoCurrentTaskThread);
        }
        this.fTaskThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void hasException(TaskException te) {
        this.fTaskException = te;
        Object object = this.getStateLock();
        synchronized (object) {
            this.setState(3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forceFinished() {
        Object object = this.getStateLock();
        synchronized (object) {
            int state = this.getState();
            if (!this.isFinishedState(state)) {
                this.setState(2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAsRunning() {
        Object object = this.getStateLock();
        synchronized (object) {
            int state = this.getState();
            if (state == 0) {
                this.setState(1);
            }
        }
    }

    protected void setState(int state) {
        if (this.isValidState(state)) {
            this.fState = state;
            this.getStateLock().notifyAll();
        }
    }

    protected int getState() {
        return this.fState;
    }

    protected boolean isFinishedState(int state) {
        return state == 2 || state == 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ITask_setExecutionQueue(IExecutionQueue queue) {
        Object object = this.getQueueLock();
        synchronized (object) {
            this.fExecutionQueue = queue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IExecutionQueue ITask_getExecutionQueue() {
        Object object = this.getQueueLock();
        synchronized (object) {
            if (this.fExecutionQueue == null) {
                this.fExecutionQueue = new AsynchExecutionQueue();
            }
        }
        return this.fExecutionQueue;
    }

    private class CoreTask
    implements Runnable {
        private CoreTask() {
        }

        public void run() {
            try {
                ATask.this.setAsRunning();
                ATask.this.doTask();
                ATask.this.forceFinished();
            }
            catch (TaskException te) {
                ATask.this.hasException(te);
            }
            ATask.this.notifyTaskCompletionHandlers();
        }
    }

    private static final class TaskQueueLock {
        private TaskQueueLock() {
        }
    }

    private static final class TaskStateLock {
        private TaskStateLock() {
        }
    }
}

