/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.directives;

import com.wily.diagnos.cmp.directives.ADirective;
import com.wily.diagnos.cmp.directives.FlagName;
import com.wily.diagnos.cmp.directives.InvalidDirectiveException;
import com.wily.diagnos.cmp.directives.builder.CompilerSettingsBuilder;
import com.wily.diagnos.cmp.directives.builder.TracerGroupBuilder;
import com.wily.diagnos.cmp.transform.builder.SubstituteStaticMethodTransformationBuilder;
import com.wily.util.classfile.FullyQualifiedMethodName;
import com.wily.util.classfile.IMethodSignature;
import com.wily.util.text.ILocalizableMessage;
import com.wily.util.text.SimpleLocalizableMessage;

public final class SubstituteStaticMethodIfFlaggedDirective
extends ADirective {
    private static final String kMethodDescriptorsMustBeIdenticalMessage = "Method descriptors must be identical";
    private final FlagName fFlagName;
    private final FullyQualifiedMethodName fSourceMethod;
    private final FullyQualifiedMethodName fReplacementMethod;

    public SubstituteStaticMethodIfFlaggedDirective(String source, int lineNumber, FlagName flagName, FullyQualifiedMethodName sourceMethod, FullyQualifiedMethodName replacementMethod) throws InvalidDirectiveException {
        super(source, lineNumber);
        this.validateParameters(sourceMethod, replacementMethod);
        this.fFlagName = flagName;
        this.fSourceMethod = sourceMethod;
        this.fReplacementMethod = replacementMethod;
    }

    private void validateParameters(FullyQualifiedMethodName sourceMethod, FullyQualifiedMethodName replacementMethod) throws InvalidDirectiveException {
        IMethodSignature replacementDescriptor;
        IMethodSignature sourceDescriptor = sourceMethod.getMethodName().getSignature();
        if (!sourceDescriptor.equals(replacementDescriptor = replacementMethod.getMethodName().getSignature())) {
            throw new InvalidDirectiveException(kMethodDescriptorsMustBeIdenticalMessage, (ILocalizableMessage)new SimpleLocalizableMessage("Diagnos_Exception_Parsing_Substitute_Method_Descriptors_Must_Match"));
        }
    }

    private FlagName getFlagName() {
        return this.fFlagName;
    }

    private FullyQualifiedMethodName getSourceMethod() {
        return this.fSourceMethod;
    }

    private FullyQualifiedMethodName getReplacementMethod() {
        return this.fReplacementMethod;
    }

    protected void applyToSettings(CompilerSettingsBuilder builder) {
        TracerGroupBuilder tracerGroupBuilder = builder.getTracerGroupBuilder(this.getFlagName());
        builder.addTransformation(new SubstituteStaticMethodTransformationBuilder(tracerGroupBuilder, this.getSourceMethod(), this.getReplacementMethod()));
    }
}

