/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.tracer;

import com.wily.diagnos.cmp.tracer.DGAggregateAllParameterMethodTracer;
import com.wily.diagnos.cmp.tracer.DGAggregateMethodTracer;
import com.wily.diagnos.cmp.tracer.MethodTracer;
import com.wily.diagnos.cmp.tracer.MethodTracerAggregatorPluginFactory;
import java.util.Collection;
import java.util.Iterator;

public class MethodTracerAggregator {
    public static DGAggregateMethodTracer aggregateForIntelligentInstrumentation(MethodTracer intelligentTracer) {
        DGAggregateMethodTracer aggregate = MethodTracerAggregatorPluginFactory.getAggregator("intelligentAggregator");
        if (intelligentTracer != null) {
            aggregate.addTracer(intelligentTracer);
            return aggregate;
        }
        return null;
    }

    public static DGAggregateMethodTracer aggregate(Collection tracers) {
        if (tracers.size() == 0) {
            return null;
        }
        String aggregatorName = MethodTracerAggregator.containsCustomAggregator(tracers);
        if (aggregatorName != null) {
            DGAggregateMethodTracer aggregate = MethodTracerAggregatorPluginFactory.getAggregator(aggregatorName);
            Iterator iterator = tracers.iterator();
            while (iterator.hasNext()) {
                aggregate.addTracer((MethodTracer)iterator.next());
            }
            if (MethodTracerAggregator.needsStubbing(tracers)) {
                aggregate.setNeedsStubbing(true);
            }
            return aggregate;
        }
        if (MethodTracerAggregator.needsParameters(tracers)) {
            DGAggregateAllParameterMethodTracer aggregate = new DGAggregateAllParameterMethodTracer();
            Iterator iterator = tracers.iterator();
            while (iterator.hasNext()) {
                aggregate.addTracer((MethodTracer)iterator.next());
            }
            if (MethodTracerAggregator.needsStubbing(tracers)) {
                aggregate.setNeedsStubbing(true);
            }
            return aggregate;
        }
        DGAggregateMethodTracer aggregate = new DGAggregateMethodTracer();
        Iterator iterator = tracers.iterator();
        while (iterator.hasNext()) {
            aggregate.addTracer((MethodTracer)iterator.next());
        }
        return aggregate;
    }

    private static String containsCustomAggregator(Collection tracers) {
        Iterator iterator = tracers.iterator();
        String tracerAggregator = null;
        while (iterator.hasNext()) {
            MethodTracer tracer = (MethodTracer)iterator.next();
            tracerAggregator = tracer.hasCustomAggregator();
            if (tracerAggregator == null) continue;
            return tracerAggregator;
        }
        return tracerAggregator;
    }

    private static boolean needsParameters(Collection tracers) {
        Iterator iterator = tracers.iterator();
        while (iterator.hasNext()) {
            MethodTracer tracer = (MethodTracer)iterator.next();
            if (!tracer.needsParameterAccess()) continue;
            return true;
        }
        return false;
    }

    private static boolean needsStubbing(Collection tracers) {
        Iterator iterator = tracers.iterator();
        while (iterator.hasNext()) {
            MethodTracer tracer = (MethodTracer)iterator.next();
            if (!tracer.needsStubbing()) continue;
            return true;
        }
        return false;
    }
}

