/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.personality.java.classfile.attributes;

import com.wily.diagnos.cmp.classfile.DGClassModificationException;
import com.wily.diagnos.personality.java.classfile.DGMethod;
import com.wily.diagnos.personality.java.classfile.attributes.DGAttribute;
import com.wily.diagnos.personality.java.classfile.attributes.stackmapframe.DGAppendFrame;
import com.wily.diagnos.personality.java.classfile.attributes.stackmapframe.DGChopFrame;
import com.wily.diagnos.personality.java.classfile.attributes.stackmapframe.DGFullFrame;
import com.wily.diagnos.personality.java.classfile.attributes.stackmapframe.DGObjectVariableInfo;
import com.wily.diagnos.personality.java.classfile.attributes.stackmapframe.DGSameFrame;
import com.wily.diagnos.personality.java.classfile.attributes.stackmapframe.DGSameFrameExtended;
import com.wily.diagnos.personality.java.classfile.attributes.stackmapframe.DGSameLocalsOneStackItemFrame;
import com.wily.diagnos.personality.java.classfile.attributes.stackmapframe.DGSameLocalsOneStackItemFrameExtended;
import com.wily.diagnos.personality.java.classfile.attributes.stackmapframe.DGStackMapFrame;
import com.wily.diagnos.personality.java.classfile.attributes.stackmapframe.DGVerificationTypeInfo;
import com.wily.diagnos.personality.java.classfile.attributes.stackmapframe.DGVerificationTypeInfoArray;
import com.wily.diagnos.personality.java.classfile.bytecode.DGByteCode;
import com.wily.diagnos.personality.java.classfile.bytecode.DGLocalVar;
import com.wily.diagnos.personality.java.classfile.constants.DGConstantPool;
import com.wily.util.classfile.InvalidMethodDescriptorException;
import com.wily.util.classfile.java.ClassFileFieldDescriptor;
import com.wily.util.classfile.java.ClassFileMethodDescriptor;
import com.wily.util.text.ILocalizableMessage;
import com.wily.util.text.SimpleLocalizableMessage;
import com.wily.wilyassert.Assertion;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class DGStackMapTable
extends DGAttribute {
    public static final String kStackMapTableName = "StackMapTable";
    public static final int kJavaVersionRequired = 50;
    public static final String kThisVariableDescriptor = "T";
    private static final String kStackMapTableException = "Unable to build consistent Stack Map Table";
    private int fSize;
    DGStackMapFrame fInitialFrame;
    private List fFrames;

    public DGStackMapTable(DGConstantPool constantPool) throws DGClassModificationException {
        super(constantPool.addUtfIfNecessary(kStackMapTableName), kStackMapTableName, new byte[0]);
        this.fInitialFrame = null;
        this.fFrames = new ArrayList(0);
        this.fSize = this.size();
    }

    public DGStackMapTable(DGConstantPool constantPool, int nameIndex, String name, byte[] data) throws IOException {
        super(nameIndex, name, data);
        int offset = 0;
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
        int numberOfEntries = in.readUnsignedShort();
        this.fFrames = new ArrayList(numberOfEntries);
        int i = 0;
        while (i < numberOfEntries) {
            int frameType = in.readUnsignedByte();
            if (frameType <= 63) {
                this.fFrames.add(new DGSameFrame(in, frameType, offset));
            } else if (frameType <= 127) {
                this.fFrames.add(new DGSameLocalsOneStackItemFrame(in, frameType, offset));
            } else if (frameType == 247) {
                this.fFrames.add(new DGSameLocalsOneStackItemFrameExtended(in, frameType, offset));
            } else if (frameType >= 248 && frameType <= 250) {
                this.fFrames.add(new DGChopFrame(in, frameType, offset));
            } else if (frameType == 251) {
                this.fFrames.add(new DGSameFrameExtended(in, frameType, offset));
            } else if (frameType >= 252 && frameType <= 254) {
                this.fFrames.add(new DGAppendFrame(in, frameType, offset));
            } else if (frameType == 255) {
                this.fFrames.add(new DGFullFrame(in, frameType, offset));
            }
            offset = ((DGStackMapFrame)this.fFrames.get(i)).getOffset();
            ++i;
        }
        this.fInitialFrame = null;
        this.fSize = this.size();
    }

    public String toString() {
        StringBuffer result = new StringBuffer("[");
        if (this.fInitialFrame != null) {
            result.append("Init(");
            result.append(this.fInitialFrame);
            result.append(") ");
        }
        int i = 0;
        while (i < this.fFrames.size()) {
            if (i != 0) {
                result.append(", ");
            }
            result.append(this.fFrames.get(i));
            ++i;
        }
        result.append("]");
        return result.toString();
    }

    void debug_showMap(PrintWriter output) {
        output.println("StackFrameMap=" + this);
    }

    public int size() {
        int len = 2;
        int i = 0;
        while (i < this.fFrames.size()) {
            len += ((DGStackMapFrame)this.fFrames.get(i)).size();
            ++i;
        }
        return len;
    }

    private int updateSize() {
        int newSize = this.size();
        int diff = newSize - this.fSize;
        this.fSize = newSize;
        return diff;
    }

    public void writeContent(DataOutputStream out) throws IOException {
        out.writeShort(this.fFrames.size());
        int i = 0;
        while (i < this.fFrames.size()) {
            ((DGStackMapFrame)this.fFrames.get(i)).write(out);
            ++i;
        }
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeShort(this.fCPI_name);
        out.writeInt(this.size());
        this.writeContent(out);
    }

    private void recalculateAllOffsetsFromNewDelta() {
        int offset = 0;
        int i = 0;
        while (i < this.fFrames.size()) {
            offset = ((DGStackMapFrame)this.fFrames.get(i)).updateOffset(offset);
            ++i;
        }
    }

    public int insertCode(int pc, int codeLength, boolean startOfBasicBlock) {
        DGStackMapFrame frame;
        int i = 0;
        while (i < this.fFrames.size()) {
            boolean isFrameAfterPC;
            frame = (DGStackMapFrame)this.fFrames.get(i);
            boolean bl = startOfBasicBlock ? frame.getOffset() > pc : (isFrameAfterPC = frame.getOffset() >= pc);
            if (isFrameAfterPC) {
                this.fFrames.set(i, frame.addToOffsetDelta(codeLength));
                this.recalculateAllOffsetsFromNewDelta();
                break;
            }
            ++i;
        }
        i = 0;
        while (i < this.fFrames.size()) {
            frame = (DGStackMapFrame)this.fFrames.get(i);
            frame.updateTypeOffsets(pc, codeLength);
            ++i;
        }
        return this.updateSize();
    }

    public int addSameFrame(int pc) throws DGClassModificationException {
        if (this.fFrames.size() == 0 || pc < ((DGStackMapFrame)this.fFrames.get(0)).getOffset()) {
            return this.addSameFrameAsFirst(pc);
        }
        if (pc > ((DGStackMapFrame)this.fFrames.get(this.fFrames.size() - 1)).getOffset()) {
            return this.addSameFrameAsLast(pc);
        }
        int index = 0;
        while (index < this.fFrames.size()) {
            DGStackMapFrame frame = (DGStackMapFrame)this.fFrames.get(index);
            if (pc > frame.getOffset()) {
                int prevOffset = frame.getOffset();
                int delta = pc - prevOffset - 1;
                if (delta < 0 || index >= this.fFrames.size() - 1) {
                    throw new DGClassModificationException(kStackMapTableException, (ILocalizableMessage)new SimpleLocalizableMessage(kStackMapTableException));
                }
                DGStackMapFrame nextFrame = (DGStackMapFrame)this.fFrames.get(index + 1);
                if (delta <= 63) {
                    this.fFrames.add(index + 1, new DGSameFrame(prevOffset, delta));
                } else {
                    this.fFrames.add(index + 1, new DGSameFrameExtended(prevOffset, delta));
                }
                int nextOffset = nextFrame.getOffset();
                int nextDelta = nextOffset - pc - 1;
                nextFrame.setOffsetDelta(nextDelta);
                nextFrame.updateOffset(pc);
                return this.updateSize();
            }
            ++index;
        }
        throw new DGClassModificationException(kStackMapTableException, (ILocalizableMessage)new SimpleLocalizableMessage(kStackMapTableException));
    }

    public int addSameFrameAsFirst(int pc) throws DGClassModificationException {
        int nextOffset = 0;
        int nextDelta = 0;
        int delta = pc;
        DGStackMapFrame nextFrame = null;
        if (this.fFrames.size() != 0 && (nextDelta = (nextOffset = (nextFrame = (DGStackMapFrame)this.fFrames.get(0)).getOffset()) - pc - 1) < 0) {
            throw new DGClassModificationException(kStackMapTableException, (ILocalizableMessage)new SimpleLocalizableMessage(kStackMapTableException));
        }
        if (delta <= 63) {
            this.fFrames.add(0, new DGSameFrame(0, delta));
        } else {
            this.fFrames.add(0, new DGSameFrameExtended(0, delta));
        }
        if (nextFrame != null) {
            nextFrame.setOffsetDelta(nextDelta);
            nextFrame.updateOffset(pc);
        }
        return this.updateSize();
    }

    public int addSameFrameAsLast(int pc) throws DGClassModificationException {
        int delta;
        int prevoffset;
        if (this.fFrames.size() == 0) {
            prevoffset = 0;
            delta = pc;
        } else {
            prevoffset = ((DGStackMapFrame)this.fFrames.get(this.fFrames.size() - 1)).getOffset();
            delta = pc - prevoffset - 1;
            if (delta < 0) {
                throw new DGClassModificationException(kStackMapTableException, (ILocalizableMessage)new SimpleLocalizableMessage(kStackMapTableException));
            }
        }
        if (delta <= 63) {
            this.fFrames.add(new DGSameFrame(prevoffset, delta));
        } else {
            this.fFrames.add(new DGSameFrameExtended(prevoffset, delta));
        }
        return this.updateSize();
    }

    public int addInitialFrame(int pc, DGMethod method) {
        int delta;
        int prevoffset;
        if (this.fFrames.size() == 0) {
            prevoffset = 0;
            delta = pc;
        } else {
            prevoffset = ((DGStackMapFrame)this.fFrames.get(this.fFrames.size() - 1)).getOffset();
            delta = pc - prevoffset - 1;
            if (delta < 0) {
                return 0;
            }
        }
        DGFullFrame frame = this.createInitialFrame(method, false);
        frame.updateOffset(prevoffset);
        frame.addToOffsetDelta(delta);
        this.fFrames.add(frame);
        return this.updateSize();
    }

    public int addCatchClauseFrame(int pc, DGMethod method, boolean uninitializedThis) throws DGClassModificationException {
        int delta;
        int prevoffset;
        if (this.fFrames.size() == 0) {
            prevoffset = 0;
            delta = pc;
        } else {
            prevoffset = ((DGStackMapFrame)this.fFrames.get(this.fFrames.size() - 1)).getOffset();
            delta = pc - prevoffset - 1;
            if (delta < 0) {
                return 0;
            }
        }
        DGFullFrame initialFrame = this.createInitialFrame(method, uninitializedThis);
        int cpiThrowable = method.getConstantPool().addClassReferenceIfNecessary("java.lang.Throwable");
        DGObjectVariableInfo throwableTypeInfo = new DGObjectVariableInfo(cpiThrowable);
        DGSameLocalsOneStackItemFrameExtended sameLocals = new DGSameLocalsOneStackItemFrameExtended(0, 0, throwableTypeInfo);
        DGFullFrame frame = new DGFullFrame(initialFrame, sameLocals);
        if (!uninitializedThis) {
            DGVerificationTypeInfoArray array = frame.getLocals();
            int i = 0;
            while (i < array.size()) {
                array.setTypeInfo(i, (byte)0, 0);
                ++i;
            }
        }
        frame.updateOffset(prevoffset);
        frame.addToOffsetDelta(delta);
        this.fFrames.add(frame);
        return this.updateSize();
    }

    private DGFullFrame createInitialFrame(DGMethod method, boolean uninitializedThis) {
        int prevoffset = 0;
        int delta = 0;
        int numthis = 0;
        int numargs = 0;
        int numlocals = 0;
        int numstack = 0;
        if (!method.isClassConstructor() && !method.isStatic()) {
            numthis = 1;
        }
        ClassFileMethodDescriptor descriptor = null;
        try {
            descriptor = new ClassFileMethodDescriptor(method.getTypeDescriptor());
        }
        catch (InvalidMethodDescriptorException invalidMethodDescriptorException) {
            Assertion.wilyAssert(false);
            return null;
        }
        numargs = descriptor.getArgumentCount();
        numlocals = numthis + numargs;
        DGVerificationTypeInfoArray locals = new DGVerificationTypeInfoArray(numlocals);
        if (numthis > 0) {
            if (method.isInstanceConstructor() && uninitializedThis) {
                locals.setTypeInfo(0, (byte)6, 0);
            } else {
                locals.setTypeInfo(0, (byte)7, method.getDGClass().getClassCPI());
            }
        }
        int i = 0;
        while (i < descriptor.getArgumentCount()) {
            ClassFileFieldDescriptor argType = descriptor.getArgumentAt(i);
            locals.setTypeInfo(i + numthis, DGVerificationTypeInfo.getTypeInfo(argType), DGVerificationTypeInfo.getTypeArg(argType, method.getConstantPool()));
            ++i;
        }
        DGVerificationTypeInfoArray stack = new DGVerificationTypeInfoArray(numstack);
        DGFullFrame frame = new DGFullFrame(prevoffset, delta, numlocals, locals, numstack, stack);
        return frame;
    }

    public void convertAllToFullFrameAfterPC(DGMethod method, int pc) {
        DGFullFrame prevFullFrame;
        this.fInitialFrame = this.createInitialFrame(method, false);
        DGStackMapFrame prevFrame = prevFullFrame = (DGFullFrame)this.fInitialFrame;
        int i = 0;
        while (i < this.fFrames.size()) {
            DGStackMapFrame frame = (DGStackMapFrame)this.fFrames.get(i);
            boolean doConvert = false;
            if (frame instanceof DGAppendFrame || frame instanceof DGChopFrame) {
                doConvert = true;
            }
            if (frame.getOffset() > pc && !(frame instanceof DGFullFrame)) {
                doConvert = true;
            }
            if (doConvert) {
                frame = new DGFullFrame(prevFullFrame, prevFrame, frame);
                this.fFrames.set(i, frame);
            }
            if ((prevFrame = frame) instanceof DGFullFrame) {
                prevFullFrame = prevFrame;
            }
            ++i;
        }
    }

    private void convertToFullFrameAfterPC(DGMethod method, int pc) {
        DGFullFrame prevFullFrame;
        this.fInitialFrame = this.createInitialFrame(method, false);
        DGStackMapFrame prevFrame = prevFullFrame = (DGFullFrame)this.fInitialFrame;
        boolean firstAfterPCFound = false;
        int i = 0;
        while (i < this.fFrames.size()) {
            DGStackMapFrame frame = (DGStackMapFrame)this.fFrames.get(i);
            boolean doConvert = false;
            if (frame instanceof DGAppendFrame || frame instanceof DGChopFrame) {
                doConvert = true;
            }
            if (frame.getOffset() > pc && !firstAfterPCFound) {
                firstAfterPCFound = true;
                if (!(frame instanceof DGFullFrame)) {
                    doConvert = true;
                }
            }
            if (doConvert) {
                frame = new DGFullFrame(prevFullFrame, prevFrame, frame);
                this.fFrames.set(i, frame);
            }
            if ((prevFrame = frame) instanceof DGFullFrame) {
                prevFullFrame = prevFrame;
            }
            ++i;
        }
    }

    public int addLocalVariables(int pc, DGByteCode code, DGMethod method) throws DGClassModificationException {
        List localsAdded = code.getLocalVariables();
        int addedSize = 0;
        if (localsAdded != null && localsAdded.size() > 0) {
            int i = 0;
            while (i < localsAdded.size()) {
                DGLocalVar var = (DGLocalVar)localsAdded.get(i);
                String descriptor = var.getDescriptor();
                if (descriptor.startsWith("L")) {
                    addedSize += this.addLocalObjectReference(pc + var.getRelativePCofFirstStore(), var.getSlot(), method.getConstantPool().addClassReferenceIfNecessary(descriptor.substring(1, descriptor.length() - 1)), method);
                } else if (descriptor.equals(kThisVariableDescriptor)) {
                    addedSize += this.addLocalThisReference(pc + var.getRelativePCofFirstStore(), var.getSlot(), method);
                } else {
                    Assertion.wilyAssert(false, "StackMap: Unexpected local variable type");
                }
                ++i;
            }
        }
        return addedSize;
    }

    public int addLocalObjectReference(int pc, int slot, int pciObject, DGMethod method) {
        if (this.fInitialFrame == null) {
            this.convertToFullFrameAfterPC(method, pc);
        }
        int i = 0;
        while (i < this.fFrames.size()) {
            DGStackMapFrame frame = (DGStackMapFrame)this.fFrames.get(i);
            if (frame.getOffset() > pc && frame instanceof DGFullFrame) {
                DGFullFrame full = (DGFullFrame)frame;
                full.addLocalObjectReferenceVariable(slot, pciObject);
            }
            ++i;
        }
        return this.updateSize();
    }

    public int addLocalThisReference(int pc, int slot, DGMethod method) {
        if (this.fInitialFrame == null) {
            this.convertToFullFrameAfterPC(method, pc);
        }
        int i = 0;
        while (i < this.fFrames.size()) {
            DGStackMapFrame frame = (DGStackMapFrame)this.fFrames.get(i);
            if (frame.getOffset() > pc && frame instanceof DGFullFrame) {
                DGFullFrame full = (DGFullFrame)frame;
                full.addLocalThisVariable(slot);
            }
            ++i;
        }
        return this.updateSize();
    }

    public int addStackMapFrame(int pc, DGMethod method, int handlerOffset, boolean frameConversion) throws DGClassModificationException {
        DGStackMapFrame frame;
        int delta;
        int prevoffset;
        if (this.fFrames.size() == 0) {
            prevoffset = 0;
            delta = pc;
        } else {
            prevoffset = ((DGStackMapFrame)this.fFrames.get(this.fFrames.size() - 1)).getOffset();
            delta = pc - prevoffset - 1;
            if (delta < 0) {
                return 0;
            }
        }
        if (frameConversion) {
            this.convertAllToFullFrameAfterPC(method, handlerOffset - 1);
        }
        if ((frame = this.getStackFrame(handlerOffset)) instanceof DGFullFrame) {
            DGFullFrame fullframe = this.createFullFrame(prevoffset, delta, ((DGFullFrame)frame).getLocals(), ((DGFullFrame)frame).getStack());
            this.fFrames.add(fullframe);
        }
        return this.updateSize();
    }

    DGStackMapFrame getStackFrame(int offset) {
        DGStackMapFrame frame = null;
        int i = 0;
        while (i < this.fFrames.size()) {
            frame = (DGStackMapFrame)this.fFrames.get(i);
            if (frame.getOffset() == offset) break;
            ++i;
        }
        return frame;
    }

    private DGFullFrame createFullFrame(int prevoffset, int delta, DGVerificationTypeInfoArray locals, DGVerificationTypeInfoArray stack) {
        int numlocals = locals.getNumElements();
        int numstack = stack.getNumElements();
        DGFullFrame frame = new DGFullFrame(prevoffset, delta, numlocals, locals, numstack, stack);
        return frame;
    }
}

