/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.personality.java.compiler;

import com.wily.diagnos.cmp.DGCompilationFailedException;
import com.wily.diagnos.cmp.batch.DGFileSettings;
import com.wily.diagnos.cmp.directives.DGCompilerSettings;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.cmp.ui.ICompilerUI;
import com.wily.diagnos.personality.java.compiler.DGStreamBatchCompiler;
import com.wily.util.io.ExtendedFile;
import com.wily.util.io.LazyFileOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DGClassCompiler
extends DGStreamBatchCompiler {
    private static final String kStartingFile = "Starting class file ";
    private static final String kFinishedFile = "Finished class file ";
    private static final String kAbortedMessage = "Processing aborted for ";
    private static final String kErrorMessage = "Processing stopped because of error for ";
    private File fSourceFile;
    private File fDestFile;

    public DGClassCompiler(DGCompilerSettings settings, DGFileSettings fileSettings, ICompilerUI ui, ICompilerLog log, File sourceFile, File destFile) {
        super(settings, fileSettings, ui, log);
        this.initialize(sourceFile, destFile);
    }

    private void initialize(File sourceFile, File destFile) {
        this.fSourceFile = sourceFile;
        this.fDestFile = destFile;
        this.prepare(sourceFile.getName(), 1);
    }

    protected void compileClassFiles() throws DGCompilationFailedException {
        this.logMessage("");
        this.logTitleMessage(kStartingFile + ExtendedFile.safeGetCanonicalPath(this.fSourceFile));
        try {
            this.pauseIfNecessary();
            if (this.shouldStop()) {
                this.logErrorMessage(kAbortedMessage + ExtendedFile.safeGetCanonicalPath(this.fSourceFile));
                this.cancel();
                return;
            }
            try {
                if (this.isClassFile(this.fSourceFile)) {
                    this.handleClassFile(this.fSourceFile, this.fDestFile);
                } else {
                    this.skipFile(this.fSourceFile.getPath());
                }
            }
            catch (IOException ioe) {
                this.logException(this.fSourceFile.getPath(), ioe);
                throw new DGCompilationFailedException(12);
            }
            this.logTitleMessage(kFinishedFile + ExtendedFile.safeGetCanonicalPath(this.fSourceFile));
            this.logMessage("");
        }
        catch (DGCompilationFailedException dgcfe) {
            this.logErrorMessage(kErrorMessage + ExtendedFile.safeGetCanonicalPath(this.fSourceFile));
            this.logMessage("");
            throw dgcfe;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleClassFile(File source, File dest) throws DGCompilationFailedException, IOException {
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(source), 16384);
            try {
                BufferedOutputStream out = new BufferedOutputStream(new LazyFileOutputStream(dest), 16384);
                try {
                    this.compileClassFile(in, out, source.getName());
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    ((OutputStream)out).close();
                    throw throwable;
                }
                {
                    Object var5_8 = null;
                    ((OutputStream)out).close();
                }
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                ((InputStream)in).close();
                throw throwable;
            }
            {
                Object var7_11 = null;
                ((InputStream)in).close();
                return;
            }
        }
        catch (DGCompilationFailedException dgcfe) {
            switch (dgcfe.getOption()) {
                case 10: {
                    this.fileCopy(source, dest);
                    return;
                }
                case 11: {
                    this.skipFile(source.getPath());
                    return;
                }
            }
            throw dgcfe;
        }
    }
}

