/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.bizrecording;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.bizrecording.BizRecordingSession;
import com.wily.introscope.agent.connection.ConnectedServer;
import com.wily.introscope.agent.connection.IServerConnectionNotification;
import com.wily.introscope.agent.connection.IsengardServerConnectionManager;
import com.wily.introscope.spec.server.beans.bizrecording.EMBizRecordingCallbackWrapper;
import com.wily.isengard.container.BeanActivationException;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.IRegisteredBehavior;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.properties.hot.BooleanConfigurationProperty;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class BizRecordingAdministrator {
    private static final long kDefaultTimeoutInMillis = 60000L;
    private final IAgent fAgent;
    private final HashMap fSessions;
    private static volatile boolean initialized = false;
    private static BizRecordingAdministrator instance = null;
    static /* synthetic */ Class class$0;

    public static synchronized BizRecordingAdministrator getBizRecordingAdministrator(IAgent agent) {
        if (!initialized) {
            initialized = true;
            BooleanConfigurationProperty bizRecordingEnabledProp = new BooleanConfigurationProperty("introscope.agent.bizRecording.enabled", Boolean.TRUE, "Agent_BizRecording_Enabled", false, false, agent.IAgent_getModuleFeedback(), new Module("BizRecordingAdministrator"), agent.IAgent_getStringLocalizer()){};
            agent.IAgent_getConfigurationManager().add(bizRecordingEnabledProp);
            boolean bizRecordingEnabled = (Boolean)bizRecordingEnabledProp.getValue();
            if (bizRecordingEnabled) {
                instance = new BizRecordingAdministrator(agent);
            }
        }
        return instance;
    }

    private BizRecordingAdministrator(IAgent agent) {
        this.fAgent = agent;
        this.fSessions = new HashMap();
        BizRecordingRegistrationRunnable target = new BizRecordingRegistrationRunnable();
        IRegisteredBehavior behavior = this.fAgent.IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)target, "Register BizRecording Bean", true, 1000L, System.currentTimeMillis() + 2000L);
        target.setBehavior(behavior);
    }

    public IAgent getAgent() {
        return this.fAgent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getBizRecordingSessions() {
        Map result;
        long currentTime = System.currentTimeMillis();
        HashMap hashMap = this.fSessions;
        synchronized (hashMap) {
            Iterator itr = this.fSessions.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                BizRecordingSession params = (BizRecordingSession)entry.getValue();
                if (currentTime <= params.getCreationTime() + params.getTimeout()) continue;
                itr.remove();
            }
            result = (Map)this.fSessions.clone();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBizRecordingSession(String sessionId, String ipFilter, String languageFilter, String timeout, EMBizRecordingCallbackWrapper callback) {
        long timeoutInMillis = 60000L;
        try {
            timeoutInMillis = Integer.parseInt(timeout);
        }
        catch (NumberFormatException numberFormatException) {}
        BizRecordingSession param = new BizRecordingSession(this.fAgent, sessionId, ipFilter, languageFilter, timeoutInMillis, callback);
        HashMap hashMap = this.fSessions;
        synchronized (hashMap) {
            if (!this.fSessions.containsKey(sessionId)) {
                this.fSessions.put(sessionId, param);
            }
        }
        this.fAgent.IAgent_getModuleFeedback().debug("BizRecording session " + sessionId + "(" + ipFilter + ", " + languageFilter + ") added");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBizRecordingSession(String sessionId) {
        HashMap hashMap = this.fSessions;
        synchronized (hashMap) {
            this.fSessions.remove(sessionId);
        }
        this.fAgent.IAgent_getModuleFeedback().debug("BizRecording session " + sessionId + " removed");
    }

    private void debug_addBizRecordingSessions() {
        this.addBizRecordingSession("001", "127.0.0.1", "*", "100000", null);
        this.addBizRecordingSession("002", "127.0.0.1", "en-us", "100000", null);
        this.addBizRecordingSession("003", "127.0.0.1", "en-wilycem", "100000", null);
    }

    class BizRecordingRegistrationRunnable
    implements ITimestampedRunnable,
    IServerConnectionNotification {
        private IRegisteredBehavior fBehavior = null;
        private boolean fInitialized = false;

        BizRecordingRegistrationRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void ITimestampedRunnable_execute(long nowInMillis) {
            if (!this.fInitialized) {
                IsengardServerConnectionManager connection = BizRecordingAdministrator.this.fAgent.IAgent_getIsengardServerConnection();
                if (connection == null) {
                    return;
                }
                connection.addConnectionObserver(this);
                this.fInitialized = true;
            }
            BizRecordingRegistrationRunnable bizRecordingRegistrationRunnable = this;
            synchronized (bizRecordingRegistrationRunnable) {
                if (this.fBehavior != null) {
                    this.fBehavior.close();
                }
            }
        }

        public void connectionUp() {
            try {
                IsengardServerConnectionManager connection = BizRecordingAdministrator.this.fAgent.IAgent_getIsengardServerConnection();
                if (connection == null) {
                    return;
                }
                ConnectedServer server = connection.getConnectedServer();
                if (server == null) {
                    return;
                }
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.wily.introscope.agent.bizrecording.BizRecordingServiceBean");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                server.addBean(clazz, BizRecordingAdministrator.this.fAgent);
            }
            catch (BeanActivationException beanActivationException) {}
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connectionDown() {
            HashMap hashMap = BizRecordingAdministrator.this.fSessions;
            synchronized (hashMap) {
                BizRecordingAdministrator.this.fSessions.clear();
            }
        }

        public synchronized void setBehavior(IRegisteredBehavior behavior) {
            this.fBehavior = behavior;
        }
    }
}

