/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.environment;

import com.wily.introscope.agent.environment.CallbackAlreadySetException;
import com.wily.introscope.agent.environment.CallbackFailedPermanentlyException;
import com.wily.introscope.agent.environment.CallbackFailedTemporarilyException;
import com.wily.introscope.agent.environment.IAppserverEnvironmentInfoCallback;
import com.wily.introscope.agent.environment.NetworkInterfaceDescriptor;
import com.wily.introscope.agent.environment.NetworkInterfaceDescriptorFactory;
import com.wily.introscope.agent.environment.NetworkInterfaceSpecifier;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.hot.BooleanConfigurationProperty;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.properties.hot.IntegerConfigurationProperty;
import com.wily.util.resource.IResource;
import com.wily.util.text.IStringLocalizer;
import com.wily.util.text.SimpleLocalizableMessage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class EnvironmentAdministrator {
    private static final String UNKNOWN_HOST = "Unknown Host";
    private static final String UNKNOWN_IP_ADDRESS = "Unknown IP Address";
    private final Module module;
    private final IModuleFeedbackChannel feedback;
    private final String fHostname;
    private final String fFullyQualifiedHostName;
    private final String fIPAddress;
    private IAppserverEnvironmentInfoCallback fAppserverEnvironmentInfo;
    private final Object fAppserverEnvironmentInfoLock;
    private final boolean lookupCanonicalHostname;
    private NetworkInterfaceSpecifier networkInterfaceSpecifier;
    private final NetworkInterfaceDescriptorFactory nidFactory;
    private final List fEnvironmentChangeListeners;
    private final int ipFamilyOrder;
    private final String subNetworksPath;
    private final String fallbackDomainName;
    static /* synthetic */ Class class$0;

    public EnvironmentAdministrator(IResource profileResource, ConfigurationManager configManager, Module module, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        InputStream subNetworksStream;
        block15: {
            this.fAppserverEnvironmentInfo = null;
            this.fAppserverEnvironmentInfoLock = new Object();
            this.networkInterfaceSpecifier = null;
            this.fEnvironmentChangeListeners = new ArrayList();
            this.module = module;
            this.feedback = feedback;
            BooleanConfigurationProperty lookupCanonicalHostnameParam = this.createLookupCanonicalHostname(module, feedback, localizer);
            configManager.add(lookupCanonicalHostnameParam);
            this.lookupCanonicalHostname = (Boolean)lookupCanonicalHostnameParam.getValue();
            ConfigurationProperty fallbackDomainNameParam = this.createFallbackDomainNameConfigProperty(module, feedback, localizer);
            configManager.add(fallbackDomainNameParam);
            this.fallbackDomainName = (String)fallbackDomainNameParam.getValue();
            String fqdn = this.calculateFullyQualifiedDomainName();
            if (fqdn.indexOf(46) < 0 && !StringUtils.isEmpty(this.fallbackDomainName)) {
                fqdn = String.valueOf(fqdn) + "." + this.fallbackDomainName;
            }
            this.fFullyQualifiedHostName = fqdn;
            ConfigurationProperty hostNameProperty = new ConfigurationProperty("introscope.agent.hostName", null, null, null, false, true, feedback, module, localizer);
            configManager.add(hostNameProperty);
            String overridenHostName = (String)hostNameProperty.getValue();
            this.fHostname = overridenHostName != null ? overridenHostName : (this.lookupCanonicalHostname ? this.fFullyQualifiedHostName : this.calculateHostname());
            this.fIPAddress = this.calculateIPAddress();
            ConfigurationProperty netInterfaceNameProperty = new ConfigurationProperty("introscope.agent.primary.net.interface.name", null, null, null, true, true, feedback, module, localizer){

                public Object convert(String s) {
                    return new NetworkInterfaceSpecifier(s);
                }

                public void set(Object v) {
                    EnvironmentAdministrator.this.setNetworkInterfaceSpecifier((NetworkInterfaceSpecifier)v);
                    EnvironmentAdministrator.this.notifyEnvironmentChangeListeners();
                }
            };
            configManager.add(netInterfaceNameProperty);
            IntegerConfigurationProperty ipFamilyOrderParam = this.createIPFamilyOrderConfigProperty(module, feedback, localizer);
            configManager.add(ipFamilyOrderParam);
            this.ipFamilyOrder = (Integer)ipFamilyOrderParam.getValue();
            ConfigurationProperty subNetworksPathParam = this.createSubNetworksPathConfigProperty(module, feedback, localizer);
            configManager.add(subNetworksPathParam);
            this.subNetworksPath = (String)subNetworksPathParam.getValue();
            subNetworksStream = null;
            if (this.subNetworksPath == null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.wily.introscope.agent.environment.SubNetworks");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                subNetworksStream = clazz.getResourceAsStream("SubNetworks.txt");
            } else {
                File snFile = new File(this.subNetworksPath);
                if (!snFile.isAbsolute()) {
                    snFile = new File(String.valueOf(new File(profileResource.IResource_getLocation()).getParent()) + File.separator + this.subNetworksPath);
                }
                if (profileResource.IResource_isFileResource()) {
                    try {
                        subNetworksStream = new FileInputStream(snFile);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        if (!feedback.isDebugEnabled(module)) break block15;
                        feedback.debug(module, localizer.IStringLocalizer_getFormattedLocalizedString("Agent_SubNetworks_File_Not_Found", snFile.getName()));
                    }
                }
            }
        }
        if (subNetworksStream == null && feedback.isDebugEnabled(module)) {
            feedback.debug(module, "Sub networks definitions not found");
        }
        this.nidFactory = new NetworkInterfaceDescriptorFactory(module, feedback, localizer, subNetworksStream);
        if (subNetworksStream != null) {
            try {
                subNetworksStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private String calculateFullyQualifiedDomainName() {
        try {
            InetAddress local = InetAddress.getLocalHost();
            return local.getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return UNKNOWN_HOST;
        }
    }

    private String calculateHostname() {
        try {
            InetAddress local = InetAddress.getLocalHost();
            return this.trimDomain(local.getHostName());
        }
        catch (UnknownHostException unknownHostException) {
            return UNKNOWN_HOST;
        }
    }

    private String calculateIPAddress() {
        try {
            InetAddress local = InetAddress.getLocalHost();
            return local.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            return UNKNOWN_IP_ADDRESS;
        }
    }

    private BooleanConfigurationProperty createLookupCanonicalHostname(Module module, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        return new BooleanConfigurationProperty("introscope.agent.display.hostName.as.fqdn", Boolean.FALSE, "Agent_HostName_As_FQDN", false, false, feedback, module, localizer){};
    }

    private IntegerConfigurationProperty createIPFamilyOrderConfigProperty(Module module, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        return new IntegerConfigurationProperty("introscope.agent.ip.family.order", new Integer(1), null, null, false, false, feedback, module, localizer){};
    }

    private ConfigurationProperty createSubNetworksPathConfigProperty(Module module, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        return new ConfigurationProperty("introscope.agent.subnetworks.path", null, null, null, false, true, feedback, module, localizer){};
    }

    private ConfigurationProperty createFallbackDomainNameConfigProperty(Module module, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        return new ConfigurationProperty("introscope.agent.fallback.domain.name", null, null, null, false, true, feedback, module, localizer){};
    }

    private String trimDomain(String hostname) {
        int dotIndex = hostname.indexOf(46);
        if (dotIndex > 0) {
            hostname = hostname.substring(0, dotIndex);
        }
        return hostname;
    }

    public String getHostname() {
        return this.fHostname;
    }

    public String getFullyQualifiedHostname() {
        return this.fFullyQualifiedHostName;
    }

    public String getIPAddress() {
        return this.fIPAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAppserverEnvironmentInfoCallback(IAppserverEnvironmentInfoCallback appInfo) throws CallbackAlreadySetException {
        Object object = this.fAppserverEnvironmentInfoLock;
        synchronized (object) {
            if (this.fAppserverEnvironmentInfo != null) {
                throw new CallbackAlreadySetException();
            }
            this.fAppserverEnvironmentInfo = appInfo;
        }
    }

    public String getAppserverGeneratedAgentName() throws CallbackFailedTemporarilyException, CallbackFailedPermanentlyException {
        Object object = this.fAppserverEnvironmentInfoLock;
        synchronized (object) {
            if (this.fAppserverEnvironmentInfo == null) {
                throw new CallbackFailedTemporarilyException(new SimpleLocalizableMessage("Agent_Appserver_Agent_Naming_Callback_Not_Set_Message"));
            }
            try {
                return this.fAppserverEnvironmentInfo.IAppserverEnvironmentInfoCallback_getAgentName();
            }
            catch (CallbackFailedTemporarilyException cfte) {
                throw cfte;
            }
            catch (CallbackFailedPermanentlyException cfpe) {
                throw cfpe;
            }
        }
    }

    public Map calculateNetInterfaceProperties() {
        NetworkInterfaceSpecifier requiredInterface = this.getNetworkInterfaceSpecifier();
        NetworkInterfaceDescriptor netInterface = null;
        if (requiredInterface == null) {
            NetworkInterfaceDescriptor[] nids = this.nidFactory.getAllNetworkInterfaces(this.ipFamilyOrder);
            if (nids != null) {
                netInterface = nids[0];
            }
        } else {
            netInterface = this.nidFactory.findNetworkInterface(requiredInterface);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        if (netInterface != null) {
            String domainName;
            if (netInterface.getIpAddressFamily() != null && netInterface.getIpAddressAsString() != null) {
                result.put(netInterface.getIpAddressFamily(), netInterface.getIpAddressAsString());
            }
            if (netInterface.getMacAddress() != null) {
                result.put("MacAddress", netInterface.getMacAddress());
            }
            if (netInterface.getHostName() != null) {
                result.put("HostName", netInterface.getHostName());
            }
            if (StringUtils.isEmpty(domainName = netInterface.getDomainName())) {
                domainName = this.fallbackDomainName;
            }
            if (domainName != null) {
                result.put("DomainName", domainName);
            }
        } else {
            this.feedback.warn(this.module, "No network interfaces found, no primary network interface will be configured");
        }
        if (this.feedback.isDebugEnabled()) {
            if (result.size() == 0) {
                this.feedback.debug(this.module, "Environment empty");
            } else {
                Set keys = result.keySet();
                Iterator i = keys.iterator();
                while (i.hasNext()) {
                    String key = (String)i.next();
                    String value = (String)result.get(key);
                    this.feedback.debug(this.module, "Environment: '" + key + "'='" + value + "'");
                }
            }
        }
        return result;
    }

    public synchronized void setNetworkInterfaceSpecifier(NetworkInterfaceSpecifier netInterfaceName) {
        this.networkInterfaceSpecifier = netInterfaceName;
    }

    public synchronized NetworkInterfaceSpecifier getNetworkInterfaceSpecifier() {
        return this.networkInterfaceSpecifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEnvironmentChangeListener(IEnvironmentChangeListener listener) {
        List list = this.fEnvironmentChangeListeners;
        synchronized (list) {
            this.fEnvironmentChangeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyEnvironmentChangeListeners() {
        List list = this.fEnvironmentChangeListeners;
        synchronized (list) {
            Iterator it = this.fEnvironmentChangeListeners.iterator();
            while (it.hasNext()) {
                IEnvironmentChangeListener listener = (IEnvironmentChangeListener)it.next();
                listener.environmentChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEnvironmentChangeListener(IEnvironmentChangeListener listener) {
        List list = this.fEnvironmentChangeListeners;
        synchronized (list) {
            this.fEnvironmentChangeListeners.remove(listener);
        }
    }

    public static interface IEnvironmentChangeListener {
        public void environmentChanged();
    }
}

