/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.intelligent;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.stat.ILongMonotonicallyIncreasingCounterDataAccumulator;
import com.wily.introscope.agent.trace.cas.AAgentMetricArray;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ISharedMetricHolder;
import com.wily.introscope.agent.trace.cas.IUpdater;
import com.wily.introscope.agent.trace.cas.RepositoryFactory;
import com.wily.introscope.agent.trace.cas.UpdaterFactory;
import com.wily.introscope.agent.trace.intelligent.AutoTracingClampHelper;
import com.wily.introscope.agent.trace.intelligent.Logger;
import com.wily.introscope.agent.trace.intelligent.frontend.FrontEndCandidateAnalyzer;
import com.wily.introscope.spec.metric.AgentMetric;

public class SustainabilityMetricsHelper {
    public static volatile boolean sIsSustainabilityEnabled = false;
    public static final ASharedMetricsHolder kSharedMetricHolder = new ASharedMetricsHolder();
    private static volatile RepositoryFactory sRepositoryFactory = null;
    private static DataAccumulatorFactory sDaf;
    public static final String sSustainabilityBaseMetricName = "Agent Stats|Sustainability|Deep Tracing";
    public static final String sAutoTracingSustainabilityBaseMetricName = "Agent Stats|Sustainability|Deep Tracing|Auto Tracing";
    public static final String sEntryPointDetectionSustainabilityBaseMetricName = "Agent Stats|Sustainability|Deep Tracing|Entry Point Detection";
    public static final String kInstrumentedMethodsMetricName = "Agent Stats|Sustainability|Deep Tracing:Instrumented Methods Count";
    public static final String kAnalyzedMethodsMetricName = "Agent Stats|Sustainability|Deep Tracing:Analyzed Methods Count";
    public static final String kProbeInfoMapSizeMetricName = "Agent Stats|Sustainability|Deep Tracing:ProbeInfo Collection Size";
    public static final String kMaxInstrumentableMethodsMetricName = "Agent Stats|Sustainability|Deep Tracing:Max Instrumentable Methods Count";
    public static final String kInstrumentationLevelMetricName = "Agent Stats|Sustainability|Deep Tracing|Instrumentation Level:Current Instrumentation Level";
    public static final String kProcessedClassesMetricName = "Agent Stats|Sustainability|Deep Tracing:Classes Processed Per Interval";
    public static final String kAverageDeepComponentPerTxnMetricName = "Agent Stats|Sustainability|Deep Tracing:Average Deep Component Count Per Transaction";
    public static final String kAverageComponentPerTxnMetricName = "Agent Stats|Sustainability|Deep Tracing:Average Component Count Per Transaction";
    public static final String kAverageComponentArraySizeMetricName = "Agent Stats|Sustainability|Deep Tracing:Average Component Array Size";
    public static final IUpdater kIntAverageUpdater;
    public static volatile IRepository sAverageDeepComponentPerTxnRep;
    public static volatile IRepository sAverageComponentPerTxnRep;
    public static volatile IRepository sAverageComponentArraySizeRep;
    public static final String kClampedAutoTracesName = "Agent Stats|Sustainability|Deep Tracing|Auto Tracing:Clamped Traces";
    public static final String kSentAutoTracesName = "Agent Stats|Sustainability|Deep Tracing|Auto Tracing:Sent Traces";
    public static final String kInitialCandidatesName = "Agent Stats|Sustainability|Deep Tracing|Entry Point Detection:Initial Candidates Current";
    public static final String kInitialCandidatesTotalName = "Agent Stats|Sustainability|Deep Tracing|Entry Point Detection:Initial Candidates Total";
    public static final String kTrackedCandidatesName = "Agent Stats|Sustainability|Deep Tracing|Entry Point Detection:Tracked Candidates Current";
    public static final String kTrackedCandidatesTotalName = "Agent Stats|Sustainability|Deep Tracing|Entry Point Detection:Tracked Candidates Total";
    public static final String kBlacklistedCandidatesTotalName = "Agent Stats|Sustainability|Deep Tracing|Entry Point Detection:Candidates Discarded";
    public static final String kPersistedEntryPointsTotalName = "Agent Stats|Sustainability|Deep Tracing|Entry Point Detection:Entry Points Discovered";
    public static final String kBlacklistedEntryPointsTotalName = "Agent Stats|Sustainability|Deep Tracing|Entry Point Detection:Entry Points Discarded";
    public static final String kEvaluatedStacksTotalName = "Agent Stats|Sustainability|Deep Tracing|Entry Point Detection:Analyzed Stack Snapshots";
    public static final String kStackSnapshotQueueLenName = "Agent Stats|Sustainability|Deep Tracing|Entry Point Detection:Stack Snapshot Queue Length";
    public static final String kTrackedStacksName = "Agent Stats|Sustainability|Deep Tracing|Entry Point Detection:Tracked Threads";
    private static ILongMonotonicallyIncreasingCounterDataAccumulator sInitialCandidatesTotal;
    private static ILongMonotonicallyIncreasingCounterDataAccumulator sTrackedCandidatesTotal;
    private static ILongMonotonicallyIncreasingCounterDataAccumulator sBlacklistedCandidatesTotal;
    private static ILongMonotonicallyIncreasingCounterDataAccumulator sPersistedEntryPointsTotal;
    private static ILongMonotonicallyIncreasingCounterDataAccumulator sBlacklistedEntryPointsTotal;
    private static ILongMonotonicallyIncreasingCounterDataAccumulator sAnalyzedStacksTotal;
    public static final String kInstrumentedMethodsCount = "Agent Stats|Sustainability|Deep Tracing|Entry Point Detection:Total Entry Points";
    public static final String kSkippedMethodsCount = "Agent Stats|Sustainability|Deep Tracing|Entry Point Detection:Total Entry Points Discarded";
    private static IAgent sAgent;

    static {
        kIntAverageUpdater = UpdaterFactory.getCombiningUpdater();
        sAverageDeepComponentPerTxnRep = null;
        sAverageComponentPerTxnRep = null;
        sAverageComponentArraySizeRep = null;
        sAgent = null;
    }

    public static void initializeSustainabilityRepositories() {
        sAverageDeepComponentPerTxnRep = sRepositoryFactory.safeGetLongAverageDataAccumulator(kAverageDeepComponentPerTxnMetricName, kSharedMetricHolder);
        sAverageComponentPerTxnRep = sRepositoryFactory.safeGetLongAverageDataAccumulator(kAverageComponentPerTxnMetricName, kSharedMetricHolder);
        sAverageComponentArraySizeRep = sRepositoryFactory.safeGetLongAverageDataAccumulator(kAverageComponentArraySizeMetricName, kSharedMetricHolder);
    }

    public static void initializeSustainabilityAccumulators() {
        sInitialCandidatesTotal = sDaf.safeGetLongMonotonicallyIncreasingCounterDataAccumulator(kInitialCandidatesTotalName);
        sTrackedCandidatesTotal = sDaf.safeGetLongMonotonicallyIncreasingCounterDataAccumulator(kTrackedCandidatesTotalName);
        sBlacklistedCandidatesTotal = sDaf.safeGetLongMonotonicallyIncreasingCounterDataAccumulator(kBlacklistedCandidatesTotalName);
        sPersistedEntryPointsTotal = sDaf.safeGetLongMonotonicallyIncreasingCounterDataAccumulator(kPersistedEntryPointsTotalName);
        sBlacklistedEntryPointsTotal = sDaf.safeGetLongMonotonicallyIncreasingCounterDataAccumulator(kBlacklistedEntryPointsTotalName);
        sAnalyzedStacksTotal = sDaf.safeGetLongMonotonicallyIncreasingCounterDataAccumulator(kEvaluatedStacksTotalName);
    }

    public static void setSustainabilityEnabled(boolean value) {
        sIsSustainabilityEnabled = value;
        if (sIsSustainabilityEnabled) {
            if (sAgent == null) {
                try {
                    sAgent = AgentShim.getAgent();
                }
                catch (AgentNotAvailableException e) {
                    Logger.logException(e);
                }
            }
            if (sAgent != null) {
                if (sDaf == null) {
                    sDaf = sAgent.IAgent_getDataAccumulatorFactory();
                    SustainabilityMetricsHelper.initializeSustainabilityAccumulators();
                }
                if (sRepositoryFactory == null && sDaf != null) {
                    sRepositoryFactory = new RepositoryFactory(sAgent.IAgent_getDataAccumulatorFactory(), true);
                    SustainabilityMetricsHelper.initializeSustainabilityRepositories();
                }
            }
            if (sRepositoryFactory == null) {
                sIsSustainabilityEnabled = false;
            }
        }
    }

    public static void reportDeepTraceSustainabilityMetrics(int deepCount, int elementCount, int stackLen) {
        if (sIsSustainabilityEnabled) {
            sAverageDeepComponentPerTxnRep.update(kIntAverageUpdater, (long)deepCount, 0L, 0);
            sAverageComponentPerTxnRep.update(kIntAverageUpdater, (long)elementCount, 0L, 0);
            sAverageComponentArraySizeRep.update(kIntAverageUpdater, (long)stackLen, 0L, 0);
        }
    }

    public static void reportAutoTracingSustainibilityMetrics(int tracesMatched) {
        if (sDaf == null) {
            return;
        }
        int clampLimit = AutoTracingClampHelper.fClampLimit;
        int clampedTraces = 0;
        int sentTraces = tracesMatched;
        if (tracesMatched > clampLimit) {
            clampedTraces = tracesMatched - clampLimit;
            sentTraces = clampLimit;
        }
        sDaf.safeGetLongIntervalCounterDataAccumulator(kClampedAutoTracesName).ILongAggregatingDataAccumulator_recordDataPoint(clampedTraces);
        sDaf.safeGetLongIntervalCounterDataAccumulator(kSentAutoTracesName).ILongAggregatingDataAccumulator_recordDataPoint(sentTraces);
    }

    public static void reportInitialCandidateSustainabilityMetrics() {
        if (sIsSustainabilityEnabled) {
            sDaf.safeGetLongFluctuatingCounterDataAccumulator(kInitialCandidatesName).ILongCounterDataAccumulator_setValue(FrontEndCandidateAnalyzer.fInitalFrontendMap.size());
        }
    }

    public static void reportTrackedCandidateSustainabilityMetrics() {
        if (sIsSustainabilityEnabled) {
            sDaf.safeGetLongFluctuatingCounterDataAccumulator(kTrackedCandidatesName).ILongCounterDataAccumulator_setValue(FrontEndCandidateAnalyzer.fCandidatePerformanceMap.size());
            if (FrontEndCandidateAnalyzer.fDeepStacks != null) {
                sDaf.safeGetLongFluctuatingCounterDataAccumulator(kTrackedStacksName).ILongCounterDataAccumulator_setValue(FrontEndCandidateAnalyzer.fDeepStacks.getSize());
            }
        }
    }

    public static void reportInitialCandidate() {
        if (sIsSustainabilityEnabled) {
            sInitialCandidatesTotal.ILongMonotonicallyIncreasingCounterDataAccumulator_increment();
        }
    }

    public static void reportInstrumentedMethodsPersisted(int val) {
        if (sIsSustainabilityEnabled) {
            sDaf.safeGetLongFluctuatingCounterDataAccumulator(kInstrumentedMethodsCount).ILongCounterDataAccumulator_setValue(val);
        }
    }

    public static void reportSkippedMethodsPersisted(int val) {
        if (sIsSustainabilityEnabled) {
            sDaf.safeGetLongFluctuatingCounterDataAccumulator(kSkippedMethodsCount).ILongCounterDataAccumulator_setValue(val);
        }
    }

    public static void reportTrackedCandidate() {
        if (sIsSustainabilityEnabled) {
            sTrackedCandidatesTotal.ILongMonotonicallyIncreasingCounterDataAccumulator_increment();
        }
    }

    public static void reportBlacklistedCandidate() {
        if (sIsSustainabilityEnabled) {
            sBlacklistedCandidatesTotal.ILongMonotonicallyIncreasingCounterDataAccumulator_increment();
        }
    }

    public static void reportPersistedEntryPoint() {
        if (sIsSustainabilityEnabled) {
            sPersistedEntryPointsTotal.ILongMonotonicallyIncreasingCounterDataAccumulator_increment();
        }
    }

    public static void reportBlacklistedEntryPoint() {
        if (sIsSustainabilityEnabled) {
            sBlacklistedEntryPointsTotal.ILongMonotonicallyIncreasingCounterDataAccumulator_increment();
        }
    }

    public static void reportAnalyzedStacks(int num) {
        if (sIsSustainabilityEnabled) {
            sAnalyzedStacksTotal.ILongMonotonicallyIncreasingCounterDataAccumulator_add(num);
        }
    }

    public static void reportStackQueueLength(int len) {
        if (sIsSustainabilityEnabled) {
            sDaf.safeGetLongFluctuatingCounterDataAccumulator(kStackSnapshotQueueLenName).ILongCounterDataAccumulator_setValue(len);
        }
    }

    public static void reportDeepInstrumentationMetrics(int instrumentedMethods, int analyzedMethods, int probeInfoSize, int maxIntrumentableMethods, int instrumentationLevel, long classesProcessed) {
        if (sIsSustainabilityEnabled) {
            sDaf.safeGetIntegerFluctuatingCounterDataAccumulator(kInstrumentedMethodsMetricName).IIntegerCounterDataAccumulator_setValue(instrumentedMethods);
            sDaf.safeGetIntegerFluctuatingCounterDataAccumulator(kAnalyzedMethodsMetricName).IIntegerCounterDataAccumulator_setValue(analyzedMethods);
            sDaf.safeGetIntegerFluctuatingCounterDataAccumulator(kProbeInfoMapSizeMetricName).IIntegerCounterDataAccumulator_setValue(probeInfoSize);
            sDaf.safeGetIntegerFluctuatingCounterDataAccumulator(kMaxInstrumentableMethodsMetricName).IIntegerCounterDataAccumulator_setValue(maxIntrumentableMethods);
            sDaf.safeGetIntegerFluctuatingCounterDataAccumulator(kInstrumentationLevelMetricName).IIntegerCounterDataAccumulator_setValue(instrumentationLevel);
            sDaf.safeGetLongIntervalCounterDataAccumulator(kProcessedClassesMetricName).ILongAggregatingDataAccumulator_recordDataPoint(classesProcessed);
        }
    }

    private static class ASharedMetricsHolder
    implements ISharedMetricHolder {
        AAgentMetricArray metric;
        IRepository rep;

        private ASharedMetricsHolder() {
        }

        @Override
        public void addMetric(AgentMetric addedMetric, IRepository structure) {
            this.rep = structure;
            this.metric = AAgentMetricArray.getInstance(addedMetric);
        }

        @Override
        public void addMetric(AgentMetric[] addedMetric, IRepository structure) {
            this.rep = structure;
            this.metric = AAgentMetricArray.getInstance(addedMetric);
        }
    }
}

