/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.transactiontrace.websphere;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.transactiontrace.IPlatformCrossProcessDataHelper;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.introscope.spec.server.transactiontrace.GUIDGenerator;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.naming.ConfigurationException;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;

public class WebSpherePlatformCrossProcessDataHelper
implements IPlatformCrossProcessDataHelper {
    private int checkCountdown;
    private static final int kCountdownInitialValue = 500;
    private IModuleFeedbackChannel feedback;
    private int hashcode;
    private Set badThreads;
    private static int inWASContextStatus;
    private static WebSphereWorkAreaReflectionHelper sHelper;
    private static final String kWorkAreaName = "com.wily.introscope.transactiontrace.WorkAreaName";
    public static final String kWorkAreaJNDIName = "java:comp/websphere/UserWorkArea";
    private static ThreadLocal fWorkAreasThreadLocal;
    private static IModuleFeedbackChannel feedbackChannel;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        fWorkAreasThreadLocal = new ThreadLocal(){

            protected Object initialValue() {
                return new PerThreadWorkAreas();
            }
        };
        inWASContextStatus = 2;
        sHelper = new WebSphereWorkAreaReflectionHelper();
    }

    public WebSpherePlatformCrossProcessDataHelper(IModuleFeedbackChannel feedback) {
        this.feedback = feedback;
        this.checkCountdown = 500;
        this.badThreads = Collections.synchronizedSet(new HashSet());
        this.hashcode = this.getClass().getName().hashCode();
    }

    public int isValidForPlatform() throws NameNotFoundException {
        String threadName = Thread.currentThread().getName();
        int result = inWASContextStatus;
        if (this.badThreads.contains(threadName)) {
            return inWASContextStatus;
        }
        if (result == 2 && this.checkCountdown > 0) {
            --this.checkCountdown;
            InitialContext jndi = null;
            try {
                jndi = new InitialContext();
                Object workAreaObj = jndi.lookup(kWorkAreaJNDIName);
                if (workAreaObj != null) {
                    result = inWASContextStatus = 0;
                    this.checkCountdown = 500;
                }
            }
            catch (ConfigurationException configurationException) {
                this.badThreads.add(threadName);
            }
            catch (NameNotFoundException nnfe) {
                throw nnfe;
            }
            catch (NamingException ne) {
                try {
                    AgentShim.getAgent().IAgent_getModuleFeedback().error(ne);
                }
                catch (AgentNotAvailableException e1) {
                    e1.printStackTrace();
                }
            }
            if (this.checkCountdown <= 0) {
                this.feedback.warn("WebSphere cross-process support: Unable to access the UserWorkArea service for 500 attempts.");
                this.checkCountdown = 500;
            }
        }
        return result;
    }

    public static void setInWASContext() {
        inWASContextStatus = 2;
    }

    public boolean initialize(IModuleFeedbackChannel feedback) {
        boolean result;
        block10: {
            result = false;
            try {
                if (this.isValidForPlatform() == 0) {
                    PerThreadWorkAreas workAreas = (PerThreadWorkAreas)fWorkAreasThreadLocal.get();
                    Object workAreaObj = workAreas.getWorkArea();
                    if (workAreaObj == null) {
                        workAreaObj = WebSpherePlatformCrossProcessDataHelper.sHelper.createNewWorkArea();
                        workAreas.setWorkArea(workAreaObj);
                    } else {
                        workAreas.incrementWorkAreas();
                        if (feedback.isDebugEnabled()) {
                            feedback.debug("Added a new work area for this thread: " + Thread.currentThread() + ", total areas now: " + workAreas.numOfWorkAreas);
                        }
                    }
                    if (workAreaObj != null) {
                        result = WebSpherePlatformCrossProcessDataHelper.sHelper.initialize(feedback);
                    }
                }
            }
            catch (NameNotFoundException e) {
                try {
                    AgentShim.getAgent().IAgent_getModuleFeedback().error(e);
                }
                catch (AgentNotAvailableException e1) {
                    e1.printStackTrace();
                }
            }
            catch (Exception e) {
                if (!feedback.isDebugEnabled()) break block10;
                feedback.debug(e);
            }
        }
        return result;
    }

    private static final Object getWorkAreaObject() {
        PerThreadWorkAreas workAreas = (PerThreadWorkAreas)fWorkAreasThreadLocal.get();
        return workAreas.getWorkArea();
    }

    public void teardown(IModuleFeedbackChannel feedback) {
        try {
            if (this.isValidForPlatform() == 0) {
                WebSpherePlatformCrossProcessDataHelper.sHelper.teardown(feedback);
            }
        }
        catch (NameNotFoundException e) {
            try {
                AgentShim.getAgent().IAgent_getModuleFeedback().error(e);
            }
            catch (AgentNotAvailableException e1) {
                e1.printStackTrace();
            }
        }
    }

    public SharedCrossProcessData getCurrentCrossProcessData(boolean create, IModuleFeedbackChannel feedback) {
        SharedCrossProcessData result = null;
        try {
            if (this.isValidForPlatform() == 0) {
                result = sHelper.getCrossProcessObject(create, feedback);
            }
        }
        catch (NameNotFoundException e) {
            try {
                AgentShim.getAgent().IAgent_getModuleFeedback().error(e);
            }
            catch (AgentNotAvailableException e1) {
                e1.printStackTrace();
            }
        }
        return result;
    }

    public int compareTo(Object other) {
        return other.hashCode() - this.hashcode;
    }

    public void incrementAndPropagateSequenceId(IModuleFeedbackChannel feedback) {
        try {
            SharedCrossProcessData cache = AgentShim.getAgent().IAgent_getComponentTracer().getCrossProcessDataCache();
            if (cache != null) {
                cache.incrementSequenceId();
            }
            sHelper.setCrossProcessObject(cache, feedback);
        }
        catch (AgentNotAvailableException agentNotAvailableException) {}
    }

    public int getPlatformType() {
        return 1;
    }

    private static final class PerThreadWorkAreas {
        private int numOfWorkAreas = 0;
        private Object workAreaObject = null;

        PerThreadWorkAreas() {
        }

        Object getWorkArea() {
            return this.workAreaObject;
        }

        void setWorkArea(Object wa) {
            if (this.workAreaObject != null) {
                try {
                    AgentShim.getAgent().IAgent_getModuleFeedback().warn("setWorkArea(); no need to set new work area; work area is already present; numOfWorkAreas: " + this.numOfWorkAreas);
                }
                catch (AgentNotAvailableException e) {
                    e.printStackTrace();
                }
            }
            this.workAreaObject = wa;
            this.incrementWorkAreas();
        }

        void incrementWorkAreas() {
            ++this.numOfWorkAreas;
            try {
                if (AgentShim.getAgent().IAgent_getModuleFeedback().isDebugEnabled()) {
                    AgentShim.getAgent().IAgent_getModuleFeedback().warn("incrementWorkAreas() after: " + this.numOfWorkAreas);
                }
            }
            catch (AgentNotAvailableException e) {
                e.printStackTrace();
            }
        }

        void decrementWorkAreas() {
            if (this.numOfWorkAreas > 0) {
                --this.numOfWorkAreas;
                if (this.numOfWorkAreas == 0) {
                    this.workAreaObject = null;
                    try {
                        if (AgentShim.getAgent().IAgent_getModuleFeedback().isDebugEnabled()) {
                            AgentShim.getAgent().IAgent_getModuleFeedback().debug("decrementWorkAreas(): number of work areas has been made zero");
                        }
                    }
                    catch (AgentNotAvailableException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                try {
                    AgentShim.getAgent().IAgent_getModuleFeedback().warn("decrementWorkAreas(): number of work areas are already zero");
                }
                catch (AgentNotAvailableException e) {
                    e.printStackTrace();
                }
            }
            try {
                if (AgentShim.getAgent().IAgent_getModuleFeedback().isDebugEnabled()) {
                    AgentShim.getAgent().IAgent_getModuleFeedback().debug("decrementWorkAreas() after: " + this.numOfWorkAreas);
                }
            }
            catch (AgentNotAvailableException e) {
                e.printStackTrace();
            }
        }
    }

    private static class WebSphereWorkAreaReflectionHelper {
        private Method getMethod;
        private Method setMethod;
        private Method beginMethod;
        private Method completeMethod;
        private Method removeMethod;
        private boolean valid = true;
        private static final String kGetMethodName = "get";
        private static final Class[] kGetMethodSignature;
        private static final String kSetMethodName = "set";
        private static final Class[] kSetMethodSignature;
        private static final String kBeginMethodName = "begin";
        private static final Class[] kBeginMethodSignature;
        private static final String kCompleteMethodName = "complete";
        private static final Class[] kCompleteMethodSignature;
        private static final String kRemoveMethodName = "remove";
        private static final Class[] kRemoveMethodSignature;
        private static final String kPropertyKey = "com.wily.introscope.spec.server.transactiontrace.websphere.WorkAreaPropertyKey";

        static {
            Class[] classArray = new Class[1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            kGetMethodSignature = classArray;
            Class[] classArray2 = new Class[2];
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray2[0] = clazz2;
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("java.io.Serializable");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray2[1] = clazz3;
            kSetMethodSignature = classArray2;
            kBeginMethodSignature = kGetMethodSignature;
            kCompleteMethodSignature = new Class[0];
            kRemoveMethodSignature = kGetMethodSignature;
        }

        WebSphereWorkAreaReflectionHelper() {
        }

        private boolean initialize(IModuleFeedbackChannel feedback) {
            boolean result;
            block3: {
                result = false;
                try {
                    Object workAreaObj = WebSpherePlatformCrossProcessDataHelper.getWorkAreaObject();
                    if (workAreaObj != null) {
                        Object[] beginArgs = new Object[]{WebSpherePlatformCrossProcessDataHelper.kWorkAreaName};
                        this.beginMethod.invoke(workAreaObj, beginArgs);
                        result = true;
                    }
                }
                catch (Throwable t) {
                    if (!feedback.isDebugEnabled()) break block3;
                    feedback.debug("WebspherePlatformCrossProcessDataHelper: initialize unable to access workArea " + t);
                }
            }
            return result;
        }

        private void teardown(IModuleFeedbackChannel feedback) {
            block8: {
                if (feedback.isDebugEnabled()) {
                    feedback.debug("WebspherePlatformCrossProcessDataHelper: teardown actual tearing down started for thread: " + Thread.currentThread());
                }
                PerThreadWorkAreas workAreas = (PerThreadWorkAreas)fWorkAreasThreadLocal.get();
                Object workAreaObj = workAreas.getWorkArea();
                workAreas.decrementWorkAreas();
                if (workAreaObj != null) {
                    block7: {
                        try {
                            Object[] removeArgs = new Object[]{kPropertyKey};
                            this.removeMethod.invoke(workAreaObj, removeArgs);
                        }
                        catch (Throwable t) {
                            if (!feedback.isDebugEnabled()) break block7;
                            feedback.debug("WebspherePlatformCrossProcessDataHelper: teardown unable to access workArea for remove" + t.getCause());
                        }
                    }
                    try {
                        Object[] completeArgs = new Object[]{};
                        this.completeMethod.invoke(workAreaObj, completeArgs);
                        if (feedback.isDebugEnabled()) {
                            feedback.debug("WebspherePlatformCrossProcessDataHelper: teardown actual tearing down complete for thread: " + Thread.currentThread());
                        }
                    }
                    catch (Throwable t) {
                        if (!feedback.isDebugEnabled()) break block8;
                        feedback.debug("WebspherePlatformCrossProcessDataHelper: teardown unable to access workArea for complete" + t.getCause());
                    }
                }
            }
        }

        private Object createNewWorkArea() throws NoSuchMethodException {
            Object result = null;
            InitialContext jndi = null;
            try {
                jndi = new InitialContext();
                result = jndi.lookup(WebSpherePlatformCrossProcessDataHelper.kWorkAreaJNDIName);
                if (result != null) {
                    Class<?> userWorkAreaClass = result.getClass();
                    this.getMethodObjects(userWorkAreaClass);
                    this.valid = true;
                }
            }
            catch (NamingException namingException) {}
            return result;
        }

        private void getMethodObjects(Class workAreaClass) throws NoSuchMethodException {
            if (this.getMethod == null) {
                this.getMethod = workAreaClass.getMethod(kGetMethodName, kGetMethodSignature);
            }
            if (this.setMethod == null) {
                this.setMethod = workAreaClass.getMethod(kSetMethodName, kSetMethodSignature);
            }
            if (this.beginMethod == null) {
                this.beginMethod = workAreaClass.getMethod(kBeginMethodName, kBeginMethodSignature);
            }
            if (this.completeMethod == null) {
                this.completeMethod = workAreaClass.getMethod(kCompleteMethodName, kCompleteMethodSignature);
            }
            if (this.removeMethod == null) {
                this.removeMethod = workAreaClass.getMethod(kRemoveMethodName, kRemoveMethodSignature);
            }
        }

        SharedCrossProcessData getCrossProcessObject(boolean create, IModuleFeedbackChannel feedback) {
            SharedCrossProcessData result = null;
            try {
                SharedCrossProcessData cache = AgentShim.getAgent().IAgent_getComponentTracer().getCrossProcessDataCache();
                if (cache != null) {
                    if (cache.getCorrelationID() != null) {
                        if (feedback.isDebugEnabled()) {
                            AgentShim.getAgent().IAgent_getModuleFeedback().debug("WebspherePlatformCrossProcessDataHelper: using existing cache");
                        }
                        cache.setFirstInProcessFlag(false);
                        return cache;
                    }
                    Object workAreaObj = WebSpherePlatformCrossProcessDataHelper.getWorkAreaObject();
                    if (workAreaObj != null) {
                        Object[] args = new Object[]{kPropertyKey};
                        Object obj = this.getMethod.invoke(workAreaObj, args);
                        SharedCrossProcessData.SerializableSharedCrossProcessData serObj = null;
                        if (obj != null) {
                            if (obj instanceof SharedCrossProcessData.SerializableSharedCrossProcessData) {
                                serObj = (SharedCrossProcessData.SerializableSharedCrossProcessData)obj;
                            } else if (feedback.isDebugEnabled()) {
                                AgentShim.getAgent().IAgent_getModuleFeedback().debug("WebspherePlatformCrossProcessDataHelper: received an older/incompatible cross process data on wire.Ignoring this data, creating new correlation data");
                            }
                        } else if (feedback.isDebugEnabled()) {
                            AgentShim.getAgent().IAgent_getModuleFeedback().debug("WebspherePlatformCrossProcessDataHelper: received null object on get from workAarea");
                        }
                        if (serObj != null) {
                            if (feedback.isDebugEnabled()) {
                                AgentShim.getAgent().IAgent_getModuleFeedback().debug("WebspherePlatformCrossProcessDataHelper: syncing SharedCrossProcessData with data from workArea");
                            }
                            if (serObj.getCorId() != null) {
                                if (feedback.isDebugEnabled()) {
                                    AgentShim.getAgent().IAgent_getModuleFeedback().debug("WebspherePlatformCrossProcessDataHelper: populating the cache with data from cross process workAarea");
                                }
                                cache.syncCache(serObj);
                            } else if (feedback.isDebugEnabled()) {
                                AgentShim.getAgent().IAgent_getModuleFeedback().debug("Incorrect/Blank correlation information was obtained from workAarea. Cross process correlation may not work correctly");
                            }
                        } else {
                            if (feedback.isDebugEnabled()) {
                                AgentShim.getAgent().IAgent_getModuleFeedback().debug("WebspherePlatformCrossProcessDataHelper: populating the cache with created cross process data");
                            }
                            cache.setCorrelationID(GUIDGenerator.getInstance().generateKey(), true);
                            cache.createSeqID();
                            cache.setPropagationFlag(0);
                        }
                        return cache;
                    }
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    if (feedback.isDebugEnabled()) {
                        feedback.debug("WebspherePlatformCrossProcessHelper: getCrossProcessObject work area service error " + t);
                    }
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable throwable) {}
            }
            return result;
        }

        boolean setCrossProcessObject(SharedCrossProcessData data, IModuleFeedbackChannel feedback) {
            boolean result = false;
            try {
                Object workAreaObj = WebSpherePlatformCrossProcessDataHelper.getWorkAreaObject();
                if (workAreaObj != null) {
                    Object[] setArgs = new Object[]{kPropertyKey, data.getOutgoingSerializableInstance()};
                    this.setMethod.invoke(workAreaObj, setArgs);
                    result = true;
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    if (feedback.isDebugEnabled()) {
                        feedback.debug("WebspherePlatformCrossProcessHelper: setCrossProcessObject work area service error " + t.getCause());
                    }
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable throwable) {}
            }
            return result;
        }

        boolean removeCrossProcessObject(IModuleFeedbackChannel feedback) {
            boolean result = false;
            try {
                Object workAreaObj = WebSpherePlatformCrossProcessDataHelper.getWorkAreaObject();
                if (workAreaObj != null) {
                    Object[] removeArgs = new Object[]{kPropertyKey};
                    this.removeMethod.invoke(workAreaObj, removeArgs);
                    Object[] completeArgs = new Object[]{};
                    this.completeMethod.invoke(workAreaObj, completeArgs);
                    result = true;
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    if (feedback.isDebugEnabled()) {
                        feedback.debug("Unable to access the WebSphere work area service: " + t.toString());
                    }
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable throwable) {}
            }
            return result;
        }

        boolean isValid() {
            return this.valid;
        }
    }
}

