/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.messageprimitives.sink;

import com.wily.isengard.message.AMessage;
import com.wily.isengard.messageprimitives.InterfaceValidationUtilities;
import com.wily.isengard.messageprimitives.InvalidIsengardInterface;
import com.wily.isengard.messageprimitives.MethodCallMessage;
import com.wily.isengard.messageprimitives.MethodCallUtilities;
import com.wily.isengard.messageprimitives.service.MessageService;
import com.wily.isengard.messageprimitives.service.MessageServiceFactory;
import com.wily.isengard.messageprimitives.sink.IMessageSink;
import com.wily.isengard.messageprimitives.sink.IMessageSinkService;
import com.wily.isengard.messageprimitives.sink.ISinkNotification;
import com.wily.isengard.postoffice.Address;
import com.wily.isengard.postoffice.IPostOfficeNotification;
import com.wily.isengard.postoffice.Mailbox;
import com.wily.isengard.postoffice.PostOffice;
import com.wily.isengard.postoffice.PostOfficeSpecifier;
import com.wily.util.exception.UnexpectedExceptionError;
import com.wily.util.feedback.Module;
import com.wily.wilyassert.Assertion;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class MessageSink
extends MessageService
implements IMessageSinkService,
IPostOfficeNotification {
    private static final Module sModule = new Module("MessageSink");
    private Class fSinkInterface;
    private HashMap fPublishers;
    private MessageHandler fMessageHandler;
    private ISinkNotification fControlChannel;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public MessageSink(PostOffice po, Class sinkInterface, ISinkNotification controlChannel) throws InvalidIsengardInterface {
        super(po);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.wily.isengard.messageprimitives.sink.IMessageSinkService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super.initialize(clazz, this);
        this.initialize(sinkInterface, controlChannel);
    }

    public MessageSink(PostOffice po, Class sinkInterface) throws InvalidIsengardInterface {
        super(po);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.wily.isengard.messageprimitives.sink.IMessageSinkService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super.initialize(clazz, this);
        try {
            this.initialize(sinkInterface, (ISinkNotification)((Object)this));
        }
        catch (ClassCastException e) {
            this.getFeedbackChannel().error(sModule, "The class " + this.getClass() + " must implement the interface ISinkNotification");
            throw new UnexpectedExceptionError(e);
        }
    }

    private void initialize(Class sinkInterface, ISinkNotification controlChannel) throws InvalidIsengardInterface {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("com.wily.isengard.messageprimitives.sink.IMessageSink");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        InterfaceValidationUtilities.validateInterface(sinkInterface, clazz);
        this.fSinkInterface = sinkInterface;
        this.fControlChannel = controlChannel;
        this.fPublishers = new HashMap();
        this.fMessageHandler = new MessageHandler(this.getPostOffice());
        this.receivePostOfficeNotification(this);
    }

    private void handleIncomingData(MethodCallMessage message) {
        IMessageSink sink = (IMessageSink)this.fPublishers.get(message.getSourceAddress());
        Assertion.wilyAssert(sink != null);
        try {
            MethodCallUtilities.callInterface(sink, message);
        }
        catch (Throwable e) {
            this.getFeedbackChannel().error(sModule, "Caught exception while handling sink message.", e);
        }
    }

    public final Address startPublishing(Address fromAddress) {
        IMessageSink handler = this.fControlChannel.sinkPublisherStarted(fromAddress);
        this.fPublishers.put(fromAddress, handler);
        return this.fMessageHandler.getAddress();
    }

    public final void stopPublishing(Address fromAddress) {
        this.fControlChannel.sinkPublisherStopped(fromAddress);
        this.fPublishers.remove(fromAddress);
    }

    public Class getSinkClass() {
        return this.fSinkInterface;
    }

    public void close() {
        this.cancelPostOfficeNotification(this);
        if (this.fMessageHandler != null) {
            super.close();
            this.fMessageHandler.close();
            this.fMessageHandler = null;
        }
    }

    public final void postOfficeAdded(PostOfficeSpecifier postOffice) {
    }

    public final void postOfficeRemoved(PostOfficeSpecifier postOffice) {
        Address publisher;
        LinkedList<Address> deleteList = new LinkedList<Address>();
        Iterator i = this.fPublishers.keySet().iterator();
        while (i.hasNext()) {
            publisher = (Address)i.next();
            if (!publisher.getPostOffice().equals(postOffice)) continue;
            deleteList.add(publisher);
        }
        while (!deleteList.isEmpty()) {
            publisher = (Address)deleteList.removeFirst();
            this.stopPublishing(publisher);
        }
    }

    public static IMessageSinkService getInterface(PostOffice po, Address sinkAddress) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.wily.isengard.messageprimitives.sink.IMessageSinkService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IMessageSinkService)MessageServiceFactory.getService(po, (Class)clazz, sinkAddress);
    }

    private class MessageHandler
    extends Mailbox {
        public MessageHandler(PostOffice po) {
            super(po);
        }

        public final void receiveMessage(AMessage message) {
            if (message instanceof MethodCallMessage) {
                MessageSink.this.handleIncomingData((MethodCallMessage)message);
            } else {
                this.getFeedbackChannel().error(sModule, "Processing unexpected message: " + message);
            }
        }
    }
}

