/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.util.io;

import com.wily.isengard.util.io.CannotDeserializePlaceholderException;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.io.IKeyedClassLoader;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class CustomSerializationThrowableCarrier
implements Externalizable {
    private static final long serialVersionUID = 8356239793981136489L;
    private static final Class[] kThrowableParameterType;
    private static final Class[] kStringParameterType;
    private static final Class[] kNoParameterTypes;
    private static final Object[] kNoArguments;
    private static final Integer kZero;
    private static ThreadLocal sThrowableStackDepth;
    private String fClassName;
    private String fMessage;
    private Throwable fCause;
    private String fStackTrace;
    private int fStackDepth;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Throwable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        kThrowableParameterType = classArray;
        Class[] classArray2 = new Class[1];
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[0] = clazz2;
        kStringParameterType = classArray2;
        kNoParameterTypes = new Class[0];
        kNoArguments = new Object[0];
        kZero = new Integer(0);
        sThrowableStackDepth = new ThreadLocal(){

            protected Object initialValue() {
                return kZero;
            }
        };
    }

    public CustomSerializationThrowableCarrier() {
    }

    public CustomSerializationThrowableCarrier(Throwable throwable) {
        this.fClassName = throwable.getClass().getName();
        this.fMessage = throwable.getMessage();
        try {
            Method method = throwable.getClass().getMethod("getCause", kNoParameterTypes);
            this.fCause = (Throwable)method.invoke((Object)throwable, kNoArguments);
        }
        catch (Exception exception) {}
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        throwable.printStackTrace(writer);
        this.fStackTrace = stringWriter.toString();
    }

    public Throwable reconstitute(IKeyedClassLoader keyedClassLoader, String classLoaderName, IModuleFeedbackChannel feedback, Module module) {
        Throwable throwable = null;
        try {
            Class clazz = keyedClassLoader.forName(classLoaderName, this.getClassName());
            if (this.getMessage() == null) {
                throwable = (Throwable)clazz.newInstance();
            } else {
                Constructor constructor = clazz.getConstructor(kStringParameterType);
                throwable = (Throwable)constructor.newInstance(this.getMessage());
            }
        }
        catch (Throwable t) {
            throwable = new CannotDeserializePlaceholderException(this.getClassName(), this.getMessage(), t.getMessage());
        }
        this.tryInitCause(throwable, feedback, module);
        return throwable;
    }

    private void tryInitCause(Throwable throwable, IModuleFeedbackChannel feedback, Module module) {
        if (this.getCause() != null) {
            try {
                Method method = throwable.getClass().getMethod("initCause", kThrowableParameterType);
                method.invoke((Object)throwable, this.getCause());
            }
            catch (Exception e) {
                feedback.debug(module, "No initCause() for class: " + this.getClassName(), e);
            }
        }
    }

    public String getClassName() {
        return this.fClassName;
    }

    public String getMessage() {
        return this.fMessage;
    }

    public Throwable getCause() {
        return this.fCause;
    }

    public String getStackTrace() {
        return this.fStackTrace;
    }

    public boolean atTopOfChain() {
        return this.fStackDepth == 0;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fClassName = in.readUTF();
        this.fMessage = (String)in.readObject();
        this.fStackDepth = in.readInt();
        this.fCause = (Throwable)in.readObject();
        this.fStackTrace = in.readUTF();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeExternal(ObjectOutput out) throws IOException {
        block5: {
            out.writeUTF(this.fClassName);
            out.writeObject(this.fMessage);
            Integer stackDepth = (Integer)sThrowableStackDepth.get();
            this.fStackDepth = stackDepth;
            out.writeInt(this.fStackDepth);
            if (this.fCause != null) {
                sThrowableStackDepth.set(new Integer(this.fStackDepth + 1));
            }
            try {
                out.writeObject(this.fCause);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                if (this.fCause != null) {
                    sThrowableStackDepth.set(stackDepth);
                }
                throw throwable;
            }
            {
                Object var3_5 = null;
                if (this.fCause == null) break block5;
                sThrowableStackDepth.set(stackDepth);
            }
        }
        out.writeUTF(this.fStackTrace);
    }
}

