/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util;

import com.wily.util.ICloseable;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class CloseableTracker {
    private final Collection fCloseables = Collections.synchronizedSet(new HashSet());
    private volatile boolean fTorndown;

    public CloseableTracker(IModuleFeedbackChannel feedbackChannel) {
    }

    public boolean addCloseable(ICloseable closeable) {
        if (this.fTorndown) {
            closeable.close();
            return false;
        }
        this.fCloseables.add(closeable);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll() {
        ICloseable[] closeableArray = null;
        Collection collection = this.fCloseables;
        synchronized (collection) {
            closeableArray = this.fCloseables.toArray(new ICloseable[this.fCloseables.size()]);
            this.fCloseables.clear();
        }
        if (closeableArray != null) {
            int i = 0;
            while (i < closeableArray.length) {
                closeableArray[i].close();
                ++i;
            }
        }
    }

    public void teardown() {
        this.fTorndown = true;
        this.closeAll();
    }

    public boolean isTorndown() {
        return this.fTorndown;
    }

    public Object getSynchronizationLock() {
        return this;
    }
}

