/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.agent.ds.classmonitor;

import com.wily.rave.agent.ds.classmonitor.ClassInfoContainer;
import java.io.ByteArrayOutputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class CompressionHelper {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final int kMaxBufferLength = 0x100000;
    private final Inflater inflater = new Inflater();
    private final Deflater deflater = new Deflater();
    private final byte[] buffer;
    private final ByteArrayOutputStream outZipped;

    private CompressionHelper() {
        this.deflater.setLevel(1);
        this.buffer = new byte[1024];
        this.outZipped = new ByteArrayOutputStream(16384);
    }

    public static final CompressionHelper getInstance() {
        return CompressionHelperHolder.instance;
    }

    public synchronized byte[] decompress(byte[] classBytes) {
        this.inflater.reset();
        this.outZipped.reset();
        this.inflater.setInput(classBytes);
        while (!this.inflater.finished()) {
            int count;
            try {
                count = this.inflater.inflate(this.buffer);
            }
            catch (DataFormatException dataFormatException) {
                return classBytes;
            }
            this.outZipped.write(this.buffer, 0, count);
        }
        byte[] result = this.outZipped.toByteArray();
        return result;
    }

    public byte[] substituteBytes(byte[] classBytes) {
        return EMPTY_BYTES;
    }

    public synchronized ClassInfoContainer compress(ClassInfoContainer c) {
        try {
            if (c.isCompressed()) {
                return c;
            }
            byte[] code = c.getClassBytes();
            if (code == null) {
                return c;
            }
            this.outZipped.reset();
            this.deflater.reset();
            this.deflater.setInput(code);
            this.deflater.finish();
            while (!this.deflater.finished()) {
                int count = this.deflater.deflate(this.buffer);
                this.outZipped.write(this.buffer, 0, count);
            }
            byte[] result = this.outZipped.toByteArray();
            return new ClassInfoContainer(c.getAssemblyPath(), c.getAssemblyVersion(), c.getClassloader(), c.getClassName(), result, true);
        }
        catch (Throwable throwable) {
            return c;
        }
    }

    /* synthetic */ CompressionHelper(CompressionHelper compressionHelper) {
        this();
    }

    private static class CompressionHelperHolder {
        private static final CompressionHelper instance = new CompressionHelper(null);

        private CompressionHelperHolder() {
        }
    }
}

