/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util;

import com.wily.util.PropertyNotFoundException;
import com.wily.util.properties.IndexedProperties;

public class PropertySubstitutionStringParser {
    private static final char ESCAPE = '\\';
    private static final char JAVA_PROPERTY = '$';
    private static final char OPEN_BRACE = '{';
    private static final char CLOSE_BRACE = '}';
    private StringBuffer buffer = new StringBuffer();
    private int currentIndex;
    private String inputString;
    private boolean isEscape;
    private boolean acceptEscape = false;
    private IndexedProperties agentProps;

    public PropertySubstitutionStringParser(String inputString) throws IllegalArgumentException, PropertyNotFoundException {
        this.inputString = inputString;
        this.currentIndex = 0;
        this.isEscape = false;
        while (this.currentIndex < this.inputString.length()) {
            this.parseNextChar();
        }
    }

    public PropertySubstitutionStringParser(String inputString, IndexedProperties props) throws IllegalArgumentException, PropertyNotFoundException {
        this.inputString = inputString;
        this.currentIndex = 0;
        this.isEscape = false;
        this.agentProps = props;
        while (this.currentIndex < this.inputString.length()) {
            this.parseNextChar();
        }
    }

    public PropertySubstitutionStringParser(String inputString, IndexedProperties props, boolean acceptEscape) throws IllegalArgumentException, PropertyNotFoundException {
        this.inputString = inputString;
        this.currentIndex = 0;
        this.isEscape = false;
        this.agentProps = props;
        this.acceptEscape = acceptEscape;
        while (this.currentIndex < this.inputString.length()) {
            this.parseNextChar();
        }
    }

    private void parseNextChar() throws IllegalArgumentException, PropertyNotFoundException {
        char nextChar = this.currentChar();
        if (nextChar == '$' && !this.isEscape) {
            this.processProperty();
            return;
        }
        if (nextChar == '\\' && !this.isEscape) {
            if (this.acceptEscape) {
                this.buffer.append(nextChar);
            } else {
                this.isEscape = true;
            }
        } else {
            this.isEscape = false;
            this.buffer.append(nextChar);
        }
        ++this.currentIndex;
    }

    private void processProperty() throws IllegalArgumentException, PropertyNotFoundException {
        StringBuffer propertyName = new StringBuffer();
        ++this.currentIndex;
        char openBrace = this.currentChar();
        if (openBrace != '{') {
            throw new IllegalArgumentException("Expected '{' after '$' in " + this.inputString);
        }
        while (true) {
            ++this.currentIndex;
            if (this.currentIndex >= this.inputString.length()) {
                throw new IllegalArgumentException("Expected '}' in " + this.inputString);
            }
            char nextChar = this.currentChar();
            if (nextChar == '}') break;
            if (nextChar == '{') {
                throw new IllegalArgumentException("Nested '{' unsupported in " + this.inputString);
            }
            propertyName.append(nextChar);
        }
        ++this.currentIndex;
        String propertyValue = System.getProperty(propertyName.toString());
        if (propertyValue == null && this.agentProps != null) {
            propertyValue = this.agentProps.getProperty(propertyName.toString());
        }
        if (propertyValue == null) {
            throw new PropertyNotFoundException(propertyName);
        }
        this.buffer.append(propertyValue);
    }

    private char currentChar() {
        return this.inputString.charAt(this.currentIndex);
    }

    public String toString() {
        return this.buffer.toString();
    }

    public String getPropertySubstitutedString() {
        return this.buffer.toString();
    }

    public static void main(String[] args) throws IllegalArgumentException, PropertyNotFoundException {
        int i = 0;
        while (i < args.length) {
            PropertySubstitutionStringParser sp = new PropertySubstitutionStringParser(args[i]);
            System.out.println(String.valueOf(args[i]) + " ==> " + sp.toString());
            ++i;
        }
    }
}

