/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.platform.util;

import com.wily.wilyassert.Assertion;

public final class AggregateCPUUsageCalculator {
    private long[] fStats = new long[4];
    public static final int kCpuStatArrayLength = 4;
    public static final int kIdleCpuStatIndex = 0;
    public static final int kUserCpuStatIndex = 1;
    public static final int kSystemCpuStatIndex = 2;
    public static final int kWaitCpuStatIndex = 3;
    public static final long[] kInitializedStatsArray = new long[4];

    public AggregateCPUUsageCalculator() {
        for (int i = 0; i < 4; ++i) {
            this.fStats[i] = 0L;
        }
    }

    public void setSnapshot(long[] snapshot) {
        for (int i = 0; i < snapshot.length; ++i) {
            Assertion.wilyAssert(snapshot[i] >= 0L);
            this.fStats[i] = snapshot[i];
        }
    }

    public final double getAggregateCPUUsageAllowSkew(long[] stats) {
        long[] newStats = new long[4];
        for (int i = 0; i < stats.length; ++i) {
            newStats[i] = this.fStats[i] - stats[i] == 1L ? this.fStats[i] : stats[i];
        }
        return this.getAggregateCPUUsage(newStats);
    }

    public final double getAggregateCPUUsage(long[] stats) {
        Assertion.wilyAssert(stats != null);
        for (int i = 0; i < stats.length; ++i) {
            Assertion.wilyAssert(stats[i] >= 0L);
        }
        long kernelUsage = stats[2] - this.fStats[2];
        long userUsage = stats[1] - this.fStats[1];
        long sumOfCycles = 0L;
        for (int i = 0; i < stats.length; ++i) {
            sumOfCycles += stats[i] - this.fStats[i];
        }
        double resultDouble = 0.0;
        double sumOfUsage = (double)kernelUsage + (double)userUsage;
        if (sumOfCycles != 0L) {
            resultDouble = 100.0 * (sumOfUsage / (double)sumOfCycles);
        }
        this.setSnapshot(stats);
        Assertion.wilyAssert(resultDouble >= 0.0 && resultDouble <= 100.0);
        return resultDouble;
    }

    static {
        for (int i = 0; i < 4; ++i) {
            AggregateCPUUsageCalculator.kInitializedStatsArray[i] = 0L;
        }
    }
}

