/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.jmx;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.jmx.AJMXDataView;
import com.wily.introscope.agent.stat.AccumulatorAlreadyExistsException;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.metric.ConflictingTypesException;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public final class IntJMXDataView
extends AJMXDataView {
    private IIntegerFluctuatingCounterDataAccumulator fAccumulator;
    private String fFullIntroscopeMetricName;

    public IntJMXDataView(IAgent agent, ObjectName on, MBeanServer server, String attributeName, String fullIntroscopeMetricName) {
        super(agent, on, server, attributeName);
        this.fFullIntroscopeMetricName = fullIntroscopeMetricName;
    }

    protected void doUpdate(Object currentValue) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        Number numberValue;
        if (currentValue instanceof Attribute) {
            Attribute att = (Attribute)currentValue;
            numberValue = (Number)att.getValue();
        } else {
            numberValue = (Number)currentValue;
        }
        int intValue = numberValue.intValue();
        IIntegerFluctuatingCounterDataAccumulator accumulator = this.getTypedAccumulator();
        if (accumulator != null) {
            accumulator.IIntegerCounterDataAccumulator_setValue(intValue);
        }
    }

    protected IDataAccumulator getAccumulator(boolean forceCreate) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        if (forceCreate && this.fAccumulator == null) {
            this.fAccumulator = this.getAgent().IAgent_getDataAccumulatorFactory().createIntegerFluctuatingCounterDataAccumulator(this.fFullIntroscopeMetricName);
        }
        return this.fAccumulator;
    }

    private IIntegerFluctuatingCounterDataAccumulator getTypedAccumulator() throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        return (IIntegerFluctuatingCounterDataAccumulator)this.getAccumulator(true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doDestroy() {
        try {
            if (this.fAccumulator != null) {
                this.getAgent().IAgent_getDataAccumulatorFactory().removeDataAccumulator((IDataAccumulator)this.fAccumulator);
            }
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.fAccumulator = null;
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.fAccumulator = null;
            return;
        }
    }

    public String getFullMetricName() {
        return this.fFullIntroscopeMetricName;
    }
}

