/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.brtm.trace;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.api.IllegalMetricNameException;
import com.wily.introscope.agent.brtm.trace.common.MutableInteger;
import com.wily.introscope.agent.brtm.trace.common.PPSimpleTracer;
import com.wily.introscope.agent.brtm.utilities.MetricHolder;
import com.wily.introscope.agent.brtm.utilities.WrapperFactoryUtils;
import com.wily.introscope.agent.brtm.utilities.WrapperUtils;
import com.wily.introscope.agent.brtm.utilities.common.ExcludeLists;
import com.wily.introscope.agent.enterprise.EnterpriseAgent;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.trace.BTThreadLocalAdministrator;
import com.wily.introscope.agent.trace.INonReentrant;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.cas.AAgentMetricArray;
import com.wily.introscope.agent.trace.cas.IGathererElement;
import com.wily.introscope.agent.trace.cas.IMetricHolder;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ISharedMetricHolder;
import com.wily.introscope.agent.trace.cas.IUpdater;
import com.wily.introscope.agent.trace.cas.RepositoryFactory;
import com.wily.introscope.agent.trace.cas.UpdaterFactory;
import com.wily.introscope.agent.trace.hc2.ASingleMetricTracerFactory;
import com.wily.introscope.agent.transactiontrace.TransactionTraceController;
import com.wily.introscope.spec.agent.beans.bizdef.IBizDefSupportBean;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.introscope.spec.server.transactiontrace.KTransactionTraceConstants;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.util.ArrayUtilities;
import com.wily.util.adt.IConcurrentMapFactory;
import com.wily.util.adt.IWeakIdentityMap;
import com.wily.util.classfile.InvalidMethodDescriptorException;
import com.wily.util.classfile.InvalidMethodNameException;
import com.wily.util.classfile.java.MethodName;
import com.wily.util.feedback.DelegatingFeedbackChannel;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.IRegisteredBehavior;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.properties.AttributeListing;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public class BrtmTracer
extends PPSimpleTracer
implements INonReentrant {
    private static final Module BRTM_MODULE = new Module("BRTM");
    private static IAgent agent;
    private static IModuleFeedbackChannel feedback;
    private static volatile boolean brtmFeatureOn;
    private static final String brtmLocallyOn = "introscope.agent.brtm.locally.enabled";
    private static volatile boolean brtmSnippetOn;
    private static volatile boolean brtmSustainabilityMetricsOn;
    public static final int METHOD_GETPARAMETERMAP = 0;
    public static final int METHOD_GETREQUESTURI = 1;
    public static final int METHOD_UPDATEJSRESPONSE = 2;
    public static final int METHOD_GETURLWITHQUERYSTRING = 3;
    public static final int METHOD_SETEXCLUDEPATTERN = 4;
    public static final int METHOD_CALLSAMEMETHODWITHWRAPPERRESPONSE = 5;
    public static File g_javaScriptTemplateFile;
    public static boolean g_useBuiltinJavaScript;
    public static String g_javaScriptTemplate;
    static final String JAVASCRIPT_CONTENTTYPE = "text/javascript";
    private static String g_javaScriptInclude;
    private static String cmdConfigContent;
    private static String g_JavaScriptExtenInclude;
    private static String[] g_ExcludePattern;
    static final String BRTM_JAVASCRIPT_PATH = "/js/apmbrtm.js";
    static final String BRTM_EXT_JAVASCRIPT_PATH = "/js/apmbrtmextensibility.js";
    static final String BRTM_SNIPPET_JAVASCRIPT_PATH = "/js/snippet.js";
    static File g_javaScriptConfigFile;
    static final String BRTM_CONFIG_JAVASCRIPT_FILENAME = "apmbrtmconfig.js";
    static final String BRTM_EXT_JAVASCRIPT_FILENAME = "apmbrtmextensibility.js";
    public static final Map brtmPropertyKeyMap;
    static final String WILYCMD = "WilyCmd";
    private IBizDefSupportBean brtmBizDefAdmin = null;
    static IUpdater intAverageUpdater;
    static RepositoryFactory repFac;
    static final IUpdater increaserUpdater;
    static int urlAccumulatorCacheSize;
    static ASingleSharedMetricHolder mh;
    private static final ConcurrentHashMap resourceList;
    public static final String[] methodNames;
    public static final String[] overrideClassName;
    public static final String customClassloaderJar = "BrtmExt.jar";
    private static boolean g_initialized;
    private static boolean g_jsConfigGenerated;
    private IRegisteredBehavior throttleBehavior;
    private IRegisteredBehavior unsupportedBrowsersBehavior;
    static int g_iResponseCounter;
    static int g_iMetricCounter;
    static int g_iThrottleResponseLimit;
    static boolean g_bThrottleWarn;
    static boolean g_bThrottleMetricWarn;
    static long g_maxResponseContentLengthForSearching;
    volatile IWeakIdentityMap invocationDataObjectToMethodMap;
    private static volatile IWeakIdentityMap brtmClassLoaderHelpers;
    static volatile int g_iUnsupportedBrowsersCount;
    static int g_searchingMethodHierarchyMaxDepth;
    public static ThreadLocal stackDepthLocal;

    static {
        brtmFeatureOn = true;
        brtmSnippetOn = true;
        brtmSustainabilityMetricsOn = true;
        g_useBuiltinJavaScript = false;
        cmdConfigContent = new String();
        intAverageUpdater = new Updater();
        repFac = null;
        increaserUpdater = UpdaterFactory.getIncreasingUpdater();
        resourceList = new ConcurrentHashMap();
        methodNames = new String[]{"getParameterMap", "getRequestURI", "updateJSResponse", "getURLWithQueryString", "setJSExcludePatternList", "callSameMethodWithWrapperResponse"};
        overrideClassName = new String[]{"javax.servlet.http.HttpServletRequest", "javax.servlet.http.HttpServletRequest", "com.wily.introscope.agent.brtm.wrapper.BrtmWrapperFactory", "com.wily.introscope.agent.brtm.wrapper.BrtmWrapperFactory", "com.wily.introscope.agent.brtm.wrapper.BrtmWrapperFactory", "com.wily.introscope.agent.brtm.wrapper.BrtmWrapperFactory"};
        g_initialized = false;
        g_jsConfigGenerated = false;
        g_iResponseCounter = 0;
        g_iMetricCounter = 0;
        g_iThrottleResponseLimit = 1000;
        g_bThrottleWarn = false;
        g_bThrottleMetricWarn = false;
        g_maxResponseContentLengthForSearching = 32768L;
        brtmClassLoaderHelpers = BrtmTracer.getCache("BrtmClassLoaderHelpers");
        g_iUnsupportedBrowsersCount = 0;
        g_searchingMethodHierarchyMaxDepth = 3;
        brtmPropertyKeyMap = new HashMap();
        brtmPropertyKeyMap.put("BRTM_ENABLED", "introscope.agent.brtm.enabled");
        brtmPropertyKeyMap.put("BRTM_INCLUDELIST", "introscope.agent.brtm.includeURLList");
        brtmPropertyKeyMap.put("BRTM_EXCLUDELIST", "introscope.agent.brtm.excludeURLList");
        brtmPropertyKeyMap.put(KTransactionTraceConstants.kBRTMURLMetricOffBrowser, KTransactionTraceConstants.kBRTMURLMetricOff);
        brtmPropertyKeyMap.put(KTransactionTraceConstants.kBRTMWilyURLBrowser, "introscope.agent.brtm.wilyURL");
        brtmPropertyKeyMap.put(KTransactionTraceConstants.kBRTMAJAXEnabledBrowser, KTransactionTraceConstants.kBRTMAJAXEnabled);
        brtmPropertyKeyMap.put(KTransactionTraceConstants.kBRTMAJAXThresholdBrowser, KTransactionTraceConstants.kBRTMAJAXThreshold);
        brtmPropertyKeyMap.put(KTransactionTraceConstants.kBRTMJSFunctionThresholdBrowser, KTransactionTraceConstants.kBRTMJSFunctionThreshold);
        brtmPropertyKeyMap.put(KTransactionTraceConstants.kBRTMPageLoadEnabledBrowser, KTransactionTraceConstants.kBRTMPageLoadEnabled);
        brtmPropertyKeyMap.put(KTransactionTraceConstants.kBRTMPageLoadThresholdBrowser, KTransactionTraceConstants.kBRTMPageLoadThreshold);
        brtmPropertyKeyMap.put(KTransactionTraceConstants.kBRTMJSFunctionEnabledBrowser, KTransactionTraceConstants.kBRTMJSFunctionEnabled);
        brtmPropertyKeyMap.put(KTransactionTraceConstants.kBRTMMetricFreqBrowser, KTransactionTraceConstants.kBRTMMetricFreq);
        brtmPropertyKeyMap.put(KTransactionTraceConstants.kBRTMBrowserLoggingBrowser, KTransactionTraceConstants.kBRTMBrowserLogging);
        brtmPropertyKeyMap.put(KTransactionTraceConstants.kBRTMGeoEnabledBrowser, KTransactionTraceConstants.kBRTMGeoEnabled);
        brtmPropertyKeyMap.put(KTransactionTraceConstants.kBRTMGeoMaxAgeBrowser, KTransactionTraceConstants.kBRTMGeoMaxAge);
        brtmPropertyKeyMap.put(KTransactionTraceConstants.kBRTMGeoTimeoutBrowser, KTransactionTraceConstants.kBRTMGeoTimeout);
        brtmPropertyKeyMap.put(KTransactionTraceConstants.kBRTMGeoHghAccurBrowser, KTransactionTraceConstants.kBRTMGeoHghAccur);
        brtmPropertyKeyMap.put(KTransactionTraceConstants.kBRTMTraceStartTimeAdjustmentEnabledBrowser, "introscope.agent.brtm.trace.starttime.adjustment.enabled");
        stackDepthLocal = new ThreadLocal(){

            public Object initialValue() {
                return new MutableInteger();
            }
        };
    }

    public BrtmTracer(IAgent arg0, AttributeListing arg1, ProbeIdentification arg2, Object arg3) throws AgentNotAvailableException {
        super(arg0, arg1, arg2, arg3);
        agent = arg0;
        feedback = new DelegatingFeedbackChannel(arg0.IAgent_getModuleFeedback(), BRTM_MODULE);
        brtmFeatureOn = BTThreadLocalAdministrator.getInstance().isBRTMEnabled();
        brtmSnippetOn = BTThreadLocalAdministrator.getInstance().isSnippetInsertionEnabled();
        brtmSustainabilityMetricsOn = BTThreadLocalAdministrator.getInstance().isBRTMSustEnabled();
        if (!g_initialized) {
            g_initialized = true;
            this.initializeProperties();
            g_ExcludePattern = BTThreadLocalAdministrator.getInstance().getExcludeTagPatternList();
        }
        try {
            this.brtmBizDefAdmin = (IBizDefSupportBean)this.getAgent().IAgent_getTracerAdministrator().loadTraceSupport("com.wily.introscope.agent.bizdef.BizDefAdministratorFactory", "").getTraceSupportInstance();
        }
        catch (Throwable t) {
            feedback.warn(BRTM_MODULE, "Tracer failed initialization");
            feedback.verbose(BRTM_MODULE, "Tracer failed initialization", t);
        }
    }

    @Override
    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    @Override
    public boolean ITracerFactory_isShutoff() {
        return false;
    }

    @Override
    public void ITracer_startTrace(int arg0, InvocationData invocationData) {
        if (!brtmFeatureOn) {
            return;
        }
        MutableInteger stackDepth = (MutableInteger)stackDepthLocal.get();
        stackDepth.inc();
        if (stackDepth.getValue() > 1) {
            return;
        }
        if (!this.init(invocationData).booleanValue()) {
            return;
        }
        Object req = invocationData.getInvocationParameterAsObject(0);
        invocationData.getInvocationParameterAsObject(1);
        WrapperFactoryUtils wrapperFactoryUtil = this.getWrapperFactoryUtils(req);
        Object factoryObject = wrapperFactoryUtil.getFactoryObject();
        if (req != null) {
            Object fullURL;
            BTThreadLocalAdministrator.getInstance().insert(brtmLocallyOn, (Object)new Boolean(true));
            String url = null;
            if (BTThreadLocalAdministrator.getInstance().get("BRTM_REQ_URI") != null) {
                url = (String)BTThreadLocalAdministrator.getInstance().get("BRTM_REQ_URI");
            } else {
                url = (String)BrtmTracer.getObjectResult(req, invocationData, 1, wrapperFactoryUtil.getMethodCache());
                BTThreadLocalAdministrator.getInstance().insert("BRTM_REQ_URI", (Object)url);
            }
            if (feedback.isTraceEnabled()) {
                feedback.trace(BRTM_MODULE, "...1.1 startTrace... request class loader =" + invocationData.getInvocationParameterAsObject(0).getClass().getClassLoader() + ", url= " + url);
                feedback.trace(BRTM_MODULE, "...1.2 startTrace... response class loader =" + invocationData.getInvocationParameterAsObject(1).getClass().getClassLoader() + ", url= " + url);
                feedback.trace(BRTM_MODULE, "...1.3 startTrace... InvocationObject class loader =" + invocationData.getInvocationObject().getClass().getClassLoader() + ", url= " + url);
            }
            if (!this.shouldContinueBRTM(fullURL = this.getURLWithQueryString(req, invocationData, factoryObject, wrapperFactoryUtil))) {
                BTThreadLocalAdministrator.getInstance().insert("BrowserAgentExcludeURL", (Object)true);
                if (feedback.isTraceEnabled()) {
                    feedback.trace(BRTM_MODULE, "...2 shouldContinueBRTM... request is skipped in browser agent, fullURL= " + fullURL);
                }
                return;
            }
            Map paramsMap = (Map)BrtmTracer.getObjectResult(req, invocationData, 0, wrapperFactoryUtil.getMethodCache());
            Boolean isWilyRequest = this.processWilyRequest(invocationData, url, paramsMap, stackDepth, factoryObject, wrapperFactoryUtil);
            if (isWilyRequest.booleanValue()) {
                return;
            }
            if (!this.checkThrottleLimit()) {
                return;
            }
            if (!brtmSnippetOn) {
                return;
            }
            this.processAppRequest(invocationData, url, stackDepth, factoryObject, wrapperFactoryUtil);
        }
    }

    private WrapperFactoryUtils getWrapperFactoryUtils(Object req) {
        return (WrapperFactoryUtils)brtmClassLoaderHelpers.getWeak(this.getObjectClassLoader(req));
    }

    private void processAppRequest(InvocationData invocationData, String url, MutableInteger stackDepth, Object factoryObject, WrapperFactoryUtils wrapperFactoryUtil) {
        if (g_ExcludePattern != null) {
            BrtmTracer.invoke1ArgReturnsVoid(factoryObject, invocationData, 4, g_ExcludePattern, g_ExcludePattern.getClass(), wrapperFactoryUtil.getMethodCache());
        }
        BTThreadLocalAdministrator.getInstance().insert("x-apm-brtm-tt-starttime", (Object)invocationData.getWallClockTime());
        if (feedback.isTraceEnabled()) {
            feedback.trace(BRTM_MODULE, "...2 processAppRequest... app request ... start callSameMethodWithWrapperResponse in brtmtracer, url= " + url);
        }
        if (!this.callSameMethodWithWrapperResponse(invocationData, url, factoryObject, wrapperFactoryUtil).booleanValue()) {
            return;
        }
        if (feedback.isTraceEnabled()) {
            feedback.trace(BRTM_MODULE, "...6 processAppRequest... app request ... finish callSameMethodWithWrapperResponse in brtmtracer, url= " + url);
        }
        BTThreadLocalAdministrator.getInstance().flush();
        if (stackDepth.getValue() > 0) {
            stackDepth.clear();
        }
        ++g_iResponseCounter;
    }

    private Boolean init(InvocationData invocationData) {
        String temp;
        if (!this.initClassLoader(invocationData).booleanValue()) {
            return Boolean.FALSE;
        }
        if (g_javaScriptTemplate == null && g_javaScriptTemplateFile == null) {
            this.updateJSSnippet();
        }
        if (brtmSnippetOn && BTThreadLocalAdministrator.sJavaScriptConfigReset && (temp = this.createConfigJavaScriptContent()) != null) {
            cmdConfigContent = temp;
            g_jsConfigGenerated = true;
            BTThreadLocalAdministrator.sJavaScriptConfigReset = false;
        }
        if (this.invocationDataObjectToMethodMap == null) {
            this.invocationDataObjectToMethodMap = agent.IAgent_getConcurrentMapFactory().getConcurrentCappedWeakIdentityMap("BrtmInvocationDataObjectToMethod");
        }
        return Boolean.TRUE;
    }

    private Boolean initClassLoader(InvocationData invocationData) {
        WrapperFactoryUtils result;
        Object req = invocationData.getInvocationParameterAsObject(0);
        if (brtmClassLoaderHelpers == null) {
            brtmClassLoaderHelpers = BrtmTracer.getCache("BrtmClassLoaderHelpers");
        }
        if ((result = this.getWrapperFactoryUtils(req)) != null) {
            if (feedback.isTraceEnabled()) {
                feedback.trace(BRTM_MODULE, "...initClassLoader got classloader/class from cache....");
            }
            return Boolean.TRUE;
        }
        try {
            URLClassLoader classLoader = WrapperUtils.createClassLoader(this.getObjectClassLoader(req), customClassloaderJar, agent);
            Class<?> wrapperFactory = classLoader.loadClass("com.wily.introscope.agent.brtm.wrapper.BrtmWrapperFactory");
            Method method = wrapperFactory.getMethod("getInstance", IAgent.class);
            Object factoryObject = method.invoke(wrapperFactory, agent);
            if (feedback.isDebugEnabled()) {
                feedback.debug(BRTM_MODULE, "...initClassLoader. new classloader load class... brtm classloader =" + classLoader.toString());
            }
            if (classLoader != null && factoryObject != null) {
                brtmClassLoaderHelpers.putWeak(this.getObjectClassLoader(req), new WrapperFactoryUtils(classLoader, factoryObject));
                return Boolean.TRUE;
            }
        }
        catch (SecurityException e) {
            feedback.error(BRTM_MODULE, "SecurityException: ", e);
        }
        catch (NoSuchMethodException e) {
            feedback.error(BRTM_MODULE, "NoSuchMethodException: ", e);
        }
        catch (IllegalArgumentException e) {
            feedback.error(BRTM_MODULE, "IllegalArgumentException: ", e);
        }
        catch (IllegalAccessException e) {
            feedback.error(BRTM_MODULE, "IllegalAccessException: ", e);
        }
        catch (InvocationTargetException e) {
            feedback.error(BRTM_MODULE, "InvocationTargetException: ", e);
            invocationData.IParameterizedMethodTracer_setThrownException((Object)e.getTargetException());
        }
        catch (MalformedURLException e) {
            feedback.error(BRTM_MODULE, "MalformedURLException: ", e);
        }
        catch (AgentNotAvailableException e) {
            feedback.error(BRTM_MODULE, "AgentNotAvailableException: ", e);
        }
        catch (ClassNotFoundException e) {
            feedback.error(BRTM_MODULE, "ClassNotFoundException: ", e);
        }
        return Boolean.FALSE;
    }

    private ClassLoader getObjectClassLoader(Object o) {
        return o.getClass().getClassLoader();
    }

    private Boolean processWilyRequest(InvocationData invocationData, String url, Map paramsMap, MutableInteger stackDepth, Object factoryObject, WrapperFactoryUtils wrapperFactoryUtil) {
        if (paramsMap != null && !paramsMap.isEmpty() && paramsMap.containsKey(WILYCMD)) {
            String[] values = (String[])paramsMap.get(WILYCMD);
            String value = values[0];
            if (brtmSnippetOn && value.equalsIgnoreCase("cmdJS")) {
                if (feedback.isTraceEnabled()) {
                    feedback.trace(BRTM_MODULE, "...2 processWilyRequest...cmdJS..., url = " + url);
                }
                invocationData.IMethodTracer_setShouldStub(true);
                this.downloadCmdJScript(invocationData, url, factoryObject, wrapperFactoryUtil);
                if (stackDepth.getValue() > 0) {
                    stackDepth.clear();
                }
                BTThreadLocalAdministrator.getInstance().flush();
                return Boolean.TRUE;
            }
            if (value.equalsIgnoreCase("cmdMetrics")) {
                invocationData.IMethodTracer_setShouldStub(true);
                if (feedback.isTraceEnabled()) {
                    feedback.trace(BRTM_MODULE, "...2 processWilyRequest...cmdMetrics..., url = " + url);
                }
                this.createMetrics(paramsMap, invocationData);
                if (stackDepth.getValue() > 0) {
                    stackDepth.clear();
                }
                BTThreadLocalAdministrator.getInstance().flush();
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    @Override
    public void ITracer_finishTrace(int arg0, InvocationData invocationData) {
        if (!brtmFeatureOn) {
            return;
        }
        MutableInteger stackDepth = (MutableInteger)stackDepthLocal.get();
        stackDepth.dec();
        if (stackDepth.getValue() > 1) {
            return;
        }
        if (BTThreadLocalAdministrator.getInstance().get(brtmLocallyOn) != null) {
            if (stackDepth.getValue() == 0) {
                BTThreadLocalAdministrator.getInstance().flush();
                feedback.debug(BRTM_MODULE, "...finishTrace...flush() = " + stackDepth.getValue());
            }
            return;
        }
    }

    private void downloadCmdJScript(InvocationData invocationData, String url, Object factoryObject, WrapperFactoryUtils wrapperFactoryUtil) {
        String brtmJS = this.loadJScript(null);
        String configJS = this.loadJScript("cmdConfigJS");
        String extenJS = this.loadJScript("cmdExtenJS");
        String js = String.valueOf(configJS) + extenJS + brtmJS;
        if (js != null) {
            this.updateJSResponse(invocationData.getInvocationParameterAsObject(1), js, invocationData, factoryObject, wrapperFactoryUtil);
        }
        BTThreadLocalAdministrator.getInstance().flush();
    }

    private void initializeProperties() {
        g_iThrottleResponseLimit = BTThreadLocalAdministrator.getInstance().getThrottleLimit();
        g_maxResponseContentLengthForSearching = BTThreadLocalAdministrator.getInstance().getMaxResponseContentLengthForSearching();
        g_searchingMethodHierarchyMaxDepth = BTThreadLocalAdministrator.getInstance().getSearchingMethodHierarchyMaxDepth();
        this.throttleBehavior = this.getAgent().IAgent_getCommonHeartbeat().addBehavior(new ITimestampedRunnable(){

            @Override
            public void ITimestampedRunnable_execute(long nowInMillis) {
                if (BTThreadLocalAdministrator.getInstance().isBRTMSustEnabled()) {
                    BrtmTracer.this.getAgent().IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:" + KTransactionTraceConstants.kBRTMThrottleResponseCount).IIntegerCounterDataAccumulator_setValue(g_iResponseCounter);
                }
                BrtmTracer.resetThrottleTimer();
            }
        }, "BRTMThrottleLimit", true, 15000L, false);
        this.unsupportedBrowsersBehavior = this.getAgent().IAgent_getCommonHeartbeat().addBehavior(new ITimestampedRunnable(){

            @Override
            public void ITimestampedRunnable_execute(long nowInMillis) {
                if (BTThreadLocalAdministrator.getInstance().isBRTMSustEnabled()) {
                    BrtmTracer.this.getAgent().IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:introscope.agent.brtm.unsupportedBrowsers.count").IIntegerCounterDataAccumulator_setValue(g_iUnsupportedBrowsersCount);
                }
                g_iUnsupportedBrowsersCount = 0;
            }
        }, "BRTMUnsupportedBrowsersCount", true, 15000L, false);
    }

    private boolean checkThrottleLimit() {
        if (g_iResponseCounter >= g_iThrottleResponseLimit) {
            if (!g_bThrottleWarn) {
                g_bThrottleWarn = true;
                if (feedback.isDebugEnabled()) {
                    feedback.debug(BRTM_MODULE, "BRTM: Exceeded the throttle limit.  Not inserting JavaScript for the remainder of this 15 second interval and any future intervals that exceed the limit.");
                }
            }
            return false;
        }
        return true;
    }

    public static void resetThrottleTimer() {
        g_iMetricCounter = 0;
        g_iResponseCounter = 0;
    }

    public static void setThrottleResponseLimit(Integer value) {
        if (value != null) {
            g_iThrottleResponseLimit = value;
        }
    }

    private void createMetrics(Map paramsMap, InvocationData data) {
        this.parsePostParamsAndReportMetrics(paramsMap);
        String url = (String)paramsMap.get("URL");
        this.parsePostParamsAndCreateTrxTrace(data, paramsMap, url);
    }

    private Boolean parsePostParamsAndReportMetrics(Map postParamMap) {
        Set<Object> metricsSet = new HashSet();
        metricsSet = this.metricsExtractor(postParamMap);
        if (metricsSet != null && !metricsSet.isEmpty()) {
            for (MetricHolder metricHolder : metricsSet) {
                String metricPathAndName = metricHolder.getMetricName();
                String value = metricHolder.getMetricValue();
                int accType = metricHolder.getAccumulatorType();
                int index = metricPathAndName.indexOf(":");
                if (index <= 0) continue;
                String metricPath = metricPathAndName.substring(0, index);
                String metricName = metricPathAndName.substring(index + 1);
                try {
                    this.reportNewMetrics(metricPath, metricName, value, accType);
                }
                catch (IllegalMetricNameException ex) {
                    if (feedback.isDebugEnabled()) {
                        feedback.debug(BRTM_MODULE, "BrtmTracer: Illegal metric name in post parameter.");
                    }
                    ex.printStackTrace();
                }
            }
        } else if (feedback.isDebugEnabled()) {
            feedback.debug(BRTM_MODULE, "BrtmTracer: No metrics in the post parameters.");
        }
        return true;
    }

    public Set<MetricHolder> metricsExtractor(Map postParamMap) {
        HashSet<MetricHolder> metricHolderSet = new HashSet<MetricHolder>();
        String metricString = null;
        if (postParamMap.get("UB") != null) {
            if (feedback.isDebugEnabled()) {
                feedback.debug(BRTM_MODULE, "Skipping metric extraction for Wily Request from unsupported browser");
            }
            if (brtmSustainabilityMetricsOn) {
                ++g_iUnsupportedBrowsersCount;
            }
            return null;
        }
        if (postParamMap.get("bCount") == null) {
            return null;
        }
        String[] c = (String[])postParamMap.get("bCount");
        int count = 0;
        try {
            count = Integer.parseInt(c[0]);
            int i = 0;
            while (i < count) {
                String bizServiceName = null;
                String bizTrxName = null;
                String bizTrxCmpName = null;
                String[] postParamArray = (String[])postParamMap.get("b" + String.valueOf(i));
                String postParam = postParamArray[0];
                int index = postParam.indexOf("$");
                if (index >= 0) {
                    boolean btContext = false;
                    metricString = postParam.substring(index + 1);
                    StringTokenizer stringTokenizer = new StringTokenizer(metricString, ";");
                    if (stringTokenizer.hasMoreElements()) {
                        String bizTrxCmpMetric;
                        String bizTrxMetric;
                        int positionEqual;
                        String bizServiceMetric;
                        String btMetricContext = (String)stringTokenizer.nextElement();
                        StringTokenizer stringBizTokenizer = new StringTokenizer(btMetricContext, ",");
                        if (stringBizTokenizer.hasMoreElements() && !(bizServiceMetric = (String)stringBizTokenizer.nextElement()).contains("bs=-1")) {
                            positionEqual = bizServiceMetric.indexOf("=");
                            bizServiceName = bizServiceMetric.substring(positionEqual + 1, bizServiceMetric.length());
                            btContext = true;
                        }
                        if (stringBizTokenizer.hasMoreElements() && !(bizTrxMetric = (String)stringBizTokenizer.nextElement()).contains("bt=-1")) {
                            positionEqual = bizTrxMetric.indexOf("=");
                            bizTrxName = bizTrxMetric.substring(positionEqual + 1, bizTrxMetric.length());
                            btContext = true;
                        }
                        if (stringBizTokenizer.hasMoreElements() && !(bizTrxCmpMetric = (String)stringBizTokenizer.nextElement()).contains("btc=-1")) {
                            positionEqual = bizTrxCmpMetric.indexOf("=");
                            bizTrxCmpName = bizTrxCmpMetric.substring(positionEqual + 1, bizTrxCmpMetric.length());
                            btContext = true;
                        }
                    }
                    String resourcePath = null;
                    while (stringTokenizer.hasMoreElements()) {
                        String metric = (String)stringTokenizer.nextElement();
                        int positionEqual = metric.indexOf("=");
                        if (positionEqual <= 0) continue;
                        String metricName = metric.substring(0, positionEqual);
                        String metricRemain = metric.substring(positionEqual + 1, metric.length());
                        int positionComma = metricRemain.indexOf(",");
                        String metricValue = metricRemain.substring(1, positionComma);
                        int positionEnd = metricRemain.indexOf(")");
                        int accumulatorType = Integer.parseInt(metricRemain.substring(positionComma + 1, positionEnd));
                        String metricPrefixName = btContext ? "Business Segment|" + bizServiceName + "|" + bizTrxName + "|" + bizTrxCmpName + "|Browser" : "Business Segment";
                        metricName = metricName.indexOf(":") > 0 ? String.valueOf(metricPrefixName) + "|" + metricName : String.valueOf(metricPrefixName) + ":" + metricName;
                        if (resourcePath == null) {
                            resourcePath = metricName.substring(0, metricName.indexOf(":"));
                        }
                        MetricHolder holder = null;
                        if (resourceList.containsKey(resourcePath)) {
                            holder = new MetricHolder(metricName, metricValue, accumulatorType);
                            metricHolderSet.add(holder);
                        } else {
                            if (resourceList.size() >= BTThreadLocalAdministrator.getInstance().getResourceLimit()) break;
                            resourceList.put(resourcePath, Boolean.TRUE);
                            if (resourceList.size() >= BTThreadLocalAdministrator.getInstance().getResourceLimit()) {
                                feedback.info(BRTM_MODULE, "Browser Resource Limit is reached, no more browser metrics are created for new resources");
                            }
                            if (BTThreadLocalAdministrator.getInstance().isBRTMSustEnabled()) {
                                this.getAgent().IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:" + KTransactionTraceConstants.kBRTMResourceCounter).IIntegerCounterDataAccumulator_setValue(resourceList.size());
                            }
                            holder = new MetricHolder(metricName, metricValue, accumulatorType);
                            metricHolderSet.add(holder);
                        }
                        metricHolderSet.add(holder);
                    }
                    btContext = false;
                }
                ++i;
            }
        }
        catch (Exception e) {
            if (feedback.isDebugEnabled()) {
                feedback.debug(BRTM_MODULE, "BrtmTracer: Exception while extracting metrics from post parameters");
            }
            if (this.getModuleFeedback().isTraceEnabled()) {
                this.getModuleFeedback().trace(BRTM_MODULE, e.getMessage(), e);
            }
            return null;
        }
        return metricHolderSet;
    }

    private Boolean callSameMethodWithWrapperResponse(InvocationData invocationData, String url, Object factoryObject, WrapperFactoryUtils wrapperFactoryUtil) {
        String methodDesc;
        Object[] argPassArray = new Object[invocationData.getInvocationParameterCount()];
        int i = 0;
        while (i < invocationData.getInvocationParameterCount()) {
            argPassArray[i] = invocationData.getInvocationParameterAsObject(i);
            ++i;
        }
        Object o = invocationData.getInvocationObject();
        String className = invocationData.getProbeInformation().getProbeIdentification().getProbeClassName();
        String methodName = invocationData.getProbeInformation().getProbeIdentification().getProbeMethodName();
        Map methodItem = this.getMethodAndArgClass(o, methodName, argPassArray.length, methodDesc = invocationData.getProbeInformation().getProbeIdentification().getProbeMethodDescriptor());
        if (methodItem == null) {
            if (feedback.isTraceEnabled()) {
                feedback.trace(BRTM_MODULE, "...callSameMethodWithWrapperResponse... no invocationObject method is found ....");
            }
            return Boolean.FALSE;
        }
        invocationData.IMethodTracer_setShouldStub(true);
        invocationData.IMethodTracer_setReentrancyOverwrite(true);
        HashMap<String, Object> argMap = new HashMap<String, Object>();
        argMap.put("argPassArray", argPassArray);
        argMap.put("methodItem", methodItem);
        argMap.put("snippetJS", g_javaScriptTemplate);
        if (cmdConfigContent != null) {
            argMap.put("maxResponseContentLengthForSearching", BTThreadLocalAdministrator.getInstance().getMaxResponseContentLengthForSearching());
        }
        argMap.put("invocationData", invocationData);
        Object[] argArray = new Object[6];
        Class[] argClassArray = new Class[6];
        argArray[0] = o;
        argArray[1] = methodName;
        argArray[2] = className;
        argArray[3] = methodDesc;
        argArray[4] = argMap;
        argArray[5] = url;
        argClassArray[0] = Object.class;
        argClassArray[1] = String.class;
        argClassArray[2] = String.class;
        argClassArray[3] = String.class;
        argClassArray[4] = Map.class;
        argClassArray[5] = String.class;
        try {
            BrtmTracer.invokeReturnsVoid(factoryObject, invocationData, 5, argArray, argClassArray, wrapperFactoryUtil.getMethodCache());
        }
        catch (Exception exception) {
            if (feedback.isDebugEnabled()) {
                feedback.debug(BRTM_MODULE, "Exception in callSameMethodWithWrapperResponse method, restore original request. ");
            }
            invocationData.IMethodTracer_setShouldStub(false);
            invocationData.IMethodTracer_setReentrancyOverwrite(false);
        }
        return Boolean.TRUE;
    }

    private boolean shouldContinueBRTM(Object fullURL) {
        if (fullURL == null) {
            return false;
        }
        String url = fullURL.toString();
        if (url.indexOf(63) > 0 && (url.contains("WilyCmd=cmdJS") || url.contains("WilyCmd=cmdMetrics"))) {
            return true;
        }
        return !this.checkExcludeList(fullURL.toString());
    }

    private boolean checkExcludeList(String url) {
        Pattern[] includeList = BTThreadLocalAdministrator.getInstance().getIncludeURLPatternList();
        Pattern[] excludeList = BTThreadLocalAdministrator.getInstance().getExcludeURLPatternList();
        if (includeList == null && excludeList == null) {
            return false;
        }
        ExcludeLists.getInstance().setUrlIncludeList(includeList);
        ExcludeLists.getInstance().setUrlExcludeList(excludeList);
        return ExcludeLists.getInstance().inExcludeLists(url);
    }

    private void updateJSResponse(Object response, String js, InvocationData invocationData, Object factoryObject, WrapperFactoryUtils wrapperFactoryUtil) {
        Object[] argArray = new Object[2];
        Class[] classArray = new Class[2];
        argArray[0] = response;
        classArray[0] = Object.class;
        argArray[1] = js;
        classArray[1] = String.class;
        BrtmTracer.invokeReturnsObject(factoryObject, invocationData, 2, argArray, classArray, wrapperFactoryUtil.getMethodCache());
    }

    private String loadJScript(String type) {
        block18: {
            InputStream javaScriptIncludeStream;
            block17: {
                if (type != null && type.equalsIgnoreCase("cmdConfigJS")) {
                    return cmdConfigContent;
                }
                if (type != null && type.equalsIgnoreCase("cmdExtenJS")) {
                    if (g_JavaScriptExtenInclude != null) {
                        return g_JavaScriptExtenInclude;
                    }
                    this.updateJSExtension();
                    return g_JavaScriptExtenInclude;
                }
                if (g_javaScriptInclude != null) {
                    return g_javaScriptInclude;
                }
                javaScriptIncludeStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(BRTM_JAVASCRIPT_PATH);
                if (javaScriptIncludeStream != null) break block17;
                if (feedback.isDebugEnabled()) {
                    feedback.debug(BRTM_MODULE, "Cannot find JavaScript include file. File is empty. ");
                }
                return null;
            }
            try {
                InputStreamReader inReader = null;
                try {
                    try {
                        StringBuffer templateBuf = new StringBuffer(100);
                        inReader = new InputStreamReader(javaScriptIncludeStream);
                        char[] inBuf = new char[100];
                        int bytesLastRead = 0;
                        while (bytesLastRead >= 0) {
                            bytesLastRead = inReader.read(inBuf, 0, 100);
                            if (bytesLastRead <= 0) continue;
                            templateBuf.append(inBuf, 0, bytesLastRead);
                        }
                        g_javaScriptInclude = templateBuf.toString();
                    }
                    catch (IOException iOException) {
                        if (feedback.isDebugEnabled()) {
                            feedback.debug(BRTM_MODULE, "Cannot find JavaScript include file. Error ");
                        }
                        if (inReader != null) {
                            inReader.close();
                        }
                        javaScriptIncludeStream.close();
                    }
                }
                finally {
                    if (inReader != null) {
                        inReader.close();
                    }
                    javaScriptIncludeStream.close();
                }
            }
            catch (Exception exception) {
                if (!feedback.isDebugEnabled()) break block18;
                feedback.debug(BRTM_MODULE, "Cannot find JavaScript include file. Exception ");
            }
        }
        return g_javaScriptInclude;
    }

    private String createConfigJavaScriptContent() {
        StringBuffer jsContentBuffer = new StringBuffer();
        if (!brtmPropertyKeyMap.isEmpty()) {
            for (Map.Entry e : brtmPropertyKeyMap.entrySet()) {
                String propertyLine;
                String agentPropKey = (String)e.getValue();
                if (agentPropKey.equals("introscope.agent.brtm.enabled")) {
                    propertyLine = String.valueOf((String)e.getKey()) + "=" + BTThreadLocalAdministrator.getInstance().isBRTMEnabled() + ";";
                    jsContentBuffer.append(propertyLine);
                    jsContentBuffer.append("\n");
                    continue;
                }
                if (agentPropKey.equals(KTransactionTraceConstants.kBRTMAJAXEnabled)) {
                    propertyLine = String.valueOf((String)e.getKey()) + "=" + BTThreadLocalAdministrator.getInstance().isAJAXEnabled() + ";";
                    jsContentBuffer.append(propertyLine);
                    jsContentBuffer.append("\n");
                    continue;
                }
                if (agentPropKey.equals(KTransactionTraceConstants.kBRTMAJAXThreshold)) {
                    propertyLine = String.valueOf((String)e.getKey()) + "=" + BTThreadLocalAdministrator.getInstance().getAJAXThreshold() + ";";
                    jsContentBuffer.append(propertyLine);
                    jsContentBuffer.append("\n");
                    continue;
                }
                if (agentPropKey.equals("introscope.agent.brtm.includeURLList")) {
                    if (BTThreadLocalAdministrator.getInstance().getBrowserIncludeURLList() == null || BTThreadLocalAdministrator.getInstance().getBrowserIncludeURLList().length() == 0) continue;
                    propertyLine = String.valueOf((String)e.getKey()) + "=" + BTThreadLocalAdministrator.getInstance().getBrowserIncludeURLList().replace("\\", "\\\\") + ";";
                    jsContentBuffer.append(propertyLine);
                    jsContentBuffer.append("\n");
                    continue;
                }
                if (agentPropKey.equals(KTransactionTraceConstants.kBRTMBrowserLogging)) {
                    propertyLine = String.valueOf((String)e.getKey()) + "=" + BTThreadLocalAdministrator.getInstance().isBrowserLogging() + ";";
                    jsContentBuffer.append(propertyLine);
                    jsContentBuffer.append("\n");
                    continue;
                }
                if (agentPropKey.equals("introscope.agent.brtm.excludeURLList")) {
                    if (BTThreadLocalAdministrator.getInstance().getBrowserExcludeURLList() == null || BTThreadLocalAdministrator.getInstance().getBrowserExcludeURLList().length() == 0) continue;
                    propertyLine = String.valueOf((String)e.getKey()) + "=" + BTThreadLocalAdministrator.getInstance().getBrowserExcludeURLList().replace("\\", "\\\\") + ";";
                    jsContentBuffer.append(propertyLine);
                    jsContentBuffer.append("\n");
                    continue;
                }
                if (agentPropKey.equals(KTransactionTraceConstants.kBRTMGeoEnabled)) {
                    propertyLine = String.valueOf((String)e.getKey()) + "=" + BTThreadLocalAdministrator.getInstance().isGeoLocationEnabled() + ";";
                    jsContentBuffer.append(propertyLine);
                    jsContentBuffer.append("\n");
                    continue;
                }
                if (agentPropKey.equals(KTransactionTraceConstants.kBRTMGeoHghAccur)) {
                    propertyLine = String.valueOf((String)e.getKey()) + "=" + BTThreadLocalAdministrator.getInstance().getGeoHghAccur() + ";";
                    jsContentBuffer.append(propertyLine);
                    jsContentBuffer.append("\n");
                    continue;
                }
                if (agentPropKey.equals(KTransactionTraceConstants.kBRTMGeoMaxAge)) {
                    propertyLine = String.valueOf((String)e.getKey()) + "=" + BTThreadLocalAdministrator.getInstance().getGeoMaxAge() + ";";
                    jsContentBuffer.append(propertyLine);
                    jsContentBuffer.append("\n");
                    continue;
                }
                if (agentPropKey.equals(KTransactionTraceConstants.kBRTMGeoTimeout)) {
                    propertyLine = String.valueOf((String)e.getKey()) + "=" + BTThreadLocalAdministrator.getInstance().getGeoTimeout() + ";";
                    jsContentBuffer.append(propertyLine);
                    jsContentBuffer.append("\n");
                    continue;
                }
                if (agentPropKey.equals(KTransactionTraceConstants.kBRTMJSFunctionEnabled)) {
                    propertyLine = String.valueOf((String)e.getKey()) + "=" + BTThreadLocalAdministrator.getInstance().isJSFunctionEnabled() + ";";
                    jsContentBuffer.append(propertyLine);
                    jsContentBuffer.append("\n");
                    continue;
                }
                if (agentPropKey.equals(KTransactionTraceConstants.kBRTMJSFunctionThreshold)) {
                    propertyLine = String.valueOf((String)e.getKey()) + "=" + BTThreadLocalAdministrator.getInstance().getJSFunctionThreshold() + ";";
                    jsContentBuffer.append(propertyLine);
                    jsContentBuffer.append("\n");
                    continue;
                }
                if (agentPropKey.equals(KTransactionTraceConstants.kBRTMMetricFreq)) {
                    propertyLine = String.valueOf((String)e.getKey()) + "=" + BTThreadLocalAdministrator.getInstance().getMetricFreq() + ";";
                    jsContentBuffer.append(propertyLine);
                    jsContentBuffer.append("\n");
                    continue;
                }
                if (agentPropKey.equals(KTransactionTraceConstants.kBRTMPageLoadEnabled)) {
                    propertyLine = String.valueOf((String)e.getKey()) + "=" + BTThreadLocalAdministrator.getInstance().isPageLoadEnabled() + ";";
                    jsContentBuffer.append(propertyLine);
                    jsContentBuffer.append("\n");
                    continue;
                }
                if (agentPropKey.equals(KTransactionTraceConstants.kBRTMPageLoadThreshold)) {
                    propertyLine = String.valueOf((String)e.getKey()) + "=" + BTThreadLocalAdministrator.getInstance().getPageLoadThreshold() + ";";
                    jsContentBuffer.append(propertyLine);
                    jsContentBuffer.append("\n");
                    continue;
                }
                if (agentPropKey.equals(KTransactionTraceConstants.kBRTMURLMetricOff)) {
                    propertyLine = String.valueOf((String)e.getKey()) + "=" + BTThreadLocalAdministrator.getInstance().isURLMetricOff() + ";";
                    jsContentBuffer.append(propertyLine);
                    jsContentBuffer.append("\n");
                    continue;
                }
                if (agentPropKey.equals("introscope.agent.brtm.wilyURL")) {
                    if (BTThreadLocalAdministrator.getInstance().getWilyURL() == null || BTThreadLocalAdministrator.getInstance().getWilyURL().length() == 0) continue;
                    propertyLine = String.valueOf((String)e.getKey()) + "=" + BTThreadLocalAdministrator.getInstance().getWilyURL() + ";";
                    jsContentBuffer.append(propertyLine);
                    jsContentBuffer.append("\n");
                    continue;
                }
                if (!agentPropKey.equals("introscope.agent.brtm.trace.starttime.adjustment.enabled")) continue;
                propertyLine = String.valueOf((String)e.getKey()) + "=" + BTThreadLocalAdministrator.getInstance().isTraceStartTimeAdjustmentEnabled() + ";";
                jsContentBuffer.append(propertyLine);
                jsContentBuffer.append("\n");
            }
        }
        return jsContentBuffer.toString();
    }

    private synchronized void updateJSSnippet() {
        try {
            String javaScriptTemplateFilePath = BTThreadLocalAdministrator.getInstance().getSnippetLocation();
            if (javaScriptTemplateFilePath == null || javaScriptTemplateFilePath.length() == 0) {
                g_useBuiltinJavaScript = true;
                InputStream builtinJavaScriptStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(BRTM_SNIPPET_JAVASCRIPT_PATH);
                if (builtinJavaScriptStream == null) {
                    this.getModuleFeedback().info("Cannot find builtin JavaScript snippet file. Disabling BRTM.");
                    brtmFeatureOn = false;
                    return;
                }
                InputStreamReader inReader = null;
                try {
                    try {
                        StringBuffer templateBuf = new StringBuffer(100);
                        inReader = new InputStreamReader(builtinJavaScriptStream);
                        char[] inBuf = new char[100];
                        int bytesLastRead = 0;
                        while (bytesLastRead >= 0) {
                            bytesLastRead = inReader.read(inBuf, 0, 100);
                            if (bytesLastRead <= 0) continue;
                            templateBuf.append(inBuf, 0, bytesLastRead);
                        }
                        g_javaScriptTemplate = templateBuf.toString();
                        this.getModuleFeedback().info("Using built-in JavaScript snippet file.");
                    }
                    catch (IOException iOException) {
                        this.getModuleFeedback().info("Cannot read builtin JavaScript snippet file. Disabling BRTM.");
                        brtmFeatureOn = false;
                        if (inReader != null) {
                            inReader.close();
                        }
                        builtinJavaScriptStream.close();
                    }
                }
                finally {
                    if (inReader != null) {
                        inReader.close();
                    }
                    builtinJavaScriptStream.close();
                }
                return;
            }
            g_javaScriptTemplateFile = new File(javaScriptTemplateFilePath);
            if (g_javaScriptTemplateFile != null) {
                this.getModuleFeedback().info("JavaScript snippet file path: " + g_javaScriptTemplateFile.getAbsolutePath());
            }
            try {
                if (!g_javaScriptTemplateFile.canRead()) {
                    this.getModuleFeedback().info(BRTM_MODULE, String.valueOf(g_javaScriptTemplateFile.getAbsolutePath()) + " not readable. Disabling BRTM.");
                    brtmFeatureOn = false;
                    return;
                }
            }
            catch (SecurityException securityException) {
                feedback.error(BRTM_MODULE, String.valueOf(g_javaScriptTemplateFile.getAbsolutePath()) + " security denied access. Disabling BRTM.");
                brtmFeatureOn = false;
                return;
            }
        }
        catch (Exception e) {
            feedback.error(BRTM_MODULE, "Could not initialize BRT JavaScript snippet file.  Disabling BRTM.", e);
            brtmFeatureOn = false;
            return;
        }
        try {
            String line;
            BufferedReader input = new BufferedReader(new FileReader(g_javaScriptTemplateFile));
            StringBuffer buf = new StringBuffer();
            while ((line = input.readLine()) != null) {
                buf.append(line);
                buf.append('\n');
            }
            g_javaScriptTemplate = buf.toString();
        }
        catch (FileNotFoundException fnf) {
            feedback.error(BRTM_MODULE, "Could not initialize BRT JavaScript snippet file.  Disabling BRTM.", fnf);
            brtmFeatureOn = false;
            return;
        }
        catch (IOException io) {
            feedback.error(BRTM_MODULE, "Could not initialize BRT JavaScript snippet file.  Disabling BRTM.", io);
            brtmFeatureOn = false;
            return;
        }
    }

    private synchronized void updateJSExtension() {
        File javaScriptExtensionFile;
        try {
            String javaScriptExtensionFilePath = BTThreadLocalAdministrator.getInstance().getJSExtensionLocation();
            if (javaScriptExtensionFilePath == null || javaScriptExtensionFilePath.length() == 0) {
                InputStream builtinJavaScriptStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(BRTM_EXT_JAVASCRIPT_PATH);
                if (builtinJavaScriptStream == null) {
                    this.getModuleFeedback().info("Cannot find builtin JavaScript extension file. ");
                    return;
                }
                InputStreamReader inReader = null;
                try {
                    try {
                        StringBuffer templateBuf = new StringBuffer(100);
                        inReader = new InputStreamReader(builtinJavaScriptStream);
                        char[] inBuf = new char[100];
                        int bytesLastRead = 0;
                        while (bytesLastRead >= 0) {
                            bytesLastRead = inReader.read(inBuf, 0, 100);
                            if (bytesLastRead <= 0) continue;
                            templateBuf.append(inBuf, 0, bytesLastRead);
                        }
                        g_JavaScriptExtenInclude = templateBuf.toString();
                        this.getModuleFeedback().info("Using built-in JavaScript extension file.");
                    }
                    catch (IOException iOException) {
                        this.getModuleFeedback().info("Cannot read builtin JavaScript extension file. ");
                        if (inReader != null) {
                            inReader.close();
                        }
                        builtinJavaScriptStream.close();
                    }
                }
                finally {
                    if (inReader != null) {
                        inReader.close();
                    }
                    builtinJavaScriptStream.close();
                }
                return;
            }
            javaScriptExtensionFile = new File(javaScriptExtensionFilePath);
            if (javaScriptExtensionFile != null) {
                this.getModuleFeedback().info("JavaScript extension file path: " + javaScriptExtensionFile.getAbsolutePath());
            }
            try {
                if (!javaScriptExtensionFile.canRead()) {
                    if (feedback.isDebugEnabled()) {
                        feedback.debug(BRTM_MODULE, String.valueOf(javaScriptExtensionFile.getAbsolutePath()) + " not readable.");
                    }
                    return;
                }
            }
            catch (SecurityException securityException) {
                feedback.error(BRTM_MODULE, String.valueOf(javaScriptExtensionFile.getAbsolutePath()) + " security denied access.");
                return;
            }
        }
        catch (Exception e) {
            feedback.error(BRTM_MODULE, "Could not initialize BRT JavaScript extension file.", e);
            return;
        }
        try {
            String line;
            BufferedReader input = new BufferedReader(new FileReader(javaScriptExtensionFile));
            StringBuffer buf = new StringBuffer();
            while ((line = input.readLine()) != null) {
                buf.append(line);
                buf.append('\n');
            }
            g_JavaScriptExtenInclude = buf.toString();
        }
        catch (FileNotFoundException fnf) {
            feedback.error(BRTM_MODULE, "Could not initialize BRT JavaScript extension file.  ", fnf);
            return;
        }
        catch (IOException io) {
            feedback.error(BRTM_MODULE, "Could not initialize BRT JavaScript extension file.  Disabling BRTM.", io);
            return;
        }
    }

    public static void setJavaScriptConfigFile(File file) {
        g_javaScriptConfigFile = file;
    }

    public static void resetJavaScriptConfigProp() {
        g_jsConfigGenerated = false;
    }

    public void reportNewMetrics(String metricComponentName, String metricName, String stMerticValue, int accType) throws IllegalMetricNameException {
        int metricValue = -1;
        try {
            metricValue = Integer.parseInt(stMerticValue);
        }
        catch (NumberFormatException numberFormatException) {
            metricValue = -1;
            feedback.error(BRTM_MODULE, "Unable to parse metric: " + metricComponentName + ":" + metricName + "=" + stMerticValue, null);
        }
        if (metricComponentName != null && metricName != null) {
            this.recordNewMetrics(metricComponentName, metricName, metricValue, accType);
        }
    }

    private void recordNewMetrics(String componentName, String metricName, int metricValue, int accType) throws IllegalMetricNameException {
        String metricPathAndName = null;
        metricPathAndName = String.valueOf(componentName) + ":" + metricName;
        DataAccumulatorFactory daf = this.getAgent().IAgent_getDataAccumulatorFactory();
        if (accType == 0) {
            daf.safeGetIntegerAverageDataAccumulator(metricPathAndName).IIntegerAggregatingDataAccumulator_recordDataPoint(metricValue);
        } else if (accType == 1) {
            daf.safeGetLongIntervalCounterDataAccumulator(metricPathAndName).ILongAggregatingDataAccumulator_recordDataPoint((long)metricValue);
        }
    }

    private Boolean parsePostParamsAndCreateTrxTrace(InvocationData data, Map postParamMap, String url) {
        String traceName = null;
        if (postParamMap.get("bCount") == null) {
            if (feedback.isDebugEnabled()) {
                feedback.debug(BRTM_MODULE, " bcount is empty ");
            }
            return false;
        }
        int count = Integer.parseInt(((String[])postParamMap.get("bCount"))[0]);
        int i = 0;
        while (i < count) {
            boolean traceOn = false;
            String[] postParamArray = (String[])postParamMap.get("b" + String.valueOf(i));
            String postParam = postParamArray[0];
            HashMap<String, String> trxTraceComponents = new HashMap<String, String>();
            new HashMap();
            int index = postParam.indexOf("$");
            if (index > 0) {
                traceOn = true;
                String trxTraceDataString = postParam.substring(0, index);
                StringTokenizer trxStringTokenizer = new StringTokenizer(trxTraceDataString, ";");
                while (trxStringTokenizer.hasMoreElements()) {
                    String trxTraceElement = (String)trxStringTokenizer.nextElement();
                    int positionEqual = trxTraceElement.indexOf("=");
                    if (positionEqual <= 0) continue;
                    String key = trxTraceElement.substring(0, positionEqual);
                    if (key.trim().equals("g")) {
                        key = new String("geo-location");
                    } else if (key.trim().equals("p")) {
                        key = new String("browser type");
                    } else if (key.trim().equals("pv")) {
                        key = new String("browser version");
                    }
                    String value = trxTraceElement.substring(positionEqual + 1);
                    trxTraceComponents.put(key, value);
                }
            }
            if (traceOn) {
                HashMap<String, MetricHolder> metricHolder = new HashMap<String, MetricHolder>();
                String bizServiceName = null;
                String bizTrxName = null;
                String bizTrxCmpName = null;
                String urlName = null;
                String metricString = null;
                postParam = postParamArray[0];
                index = postParam.indexOf("$");
                if (index >= 0) {
                    boolean btContext = false;
                    metricString = postParam.substring(index + 1);
                    StringTokenizer stringTokenizer = new StringTokenizer(metricString, ";");
                    if (stringTokenizer.hasMoreElements()) {
                        String urlMetric;
                        String bizTrxCmpMetric;
                        String bizTrxMetric;
                        int positionEqual;
                        String bizServiceMetric;
                        String btMetricContext = (String)stringTokenizer.nextElement();
                        StringTokenizer stringBizTokenizer = new StringTokenizer(btMetricContext, ",");
                        if (stringBizTokenizer.hasMoreElements() && !(bizServiceMetric = (String)stringBizTokenizer.nextElement()).contains("bs=-1")) {
                            positionEqual = bizServiceMetric.indexOf("=");
                            bizServiceName = bizServiceMetric.substring(positionEqual + 1, bizServiceMetric.length());
                            btContext = true;
                        }
                        if (stringBizTokenizer.hasMoreElements() && !(bizTrxMetric = (String)stringBizTokenizer.nextElement()).contains("bt=-1")) {
                            positionEqual = bizTrxMetric.indexOf("=");
                            bizTrxName = bizTrxMetric.substring(positionEqual + 1, bizTrxMetric.length());
                            btContext = true;
                        }
                        if (stringBizTokenizer.hasMoreElements() && !(bizTrxCmpMetric = (String)stringBizTokenizer.nextElement()).contains("btc=-1")) {
                            positionEqual = bizTrxCmpMetric.indexOf("=");
                            bizTrxCmpName = bizTrxCmpMetric.substring(positionEqual + 1, bizTrxCmpMetric.length());
                            btContext = true;
                        }
                        if (stringBizTokenizer.hasMoreElements() && !(urlMetric = (String)stringBizTokenizer.nextElement()).contains("url=-1")) {
                            positionEqual = urlMetric.indexOf("=");
                            urlName = urlMetric.substring(positionEqual + 1, urlMetric.length());
                        }
                    }
                    while (stringTokenizer.hasMoreElements()) {
                        String metricPrefixName;
                        String metric = (String)stringTokenizer.nextElement();
                        int positionEqual = metric.indexOf("=");
                        if (positionEqual <= 0) continue;
                        String metricName = metric.substring(0, positionEqual);
                        String metricRemain = metric.substring(positionEqual + 1, metric.length());
                        int positionComma = metricRemain.indexOf(",");
                        String metricValue = metricRemain.substring(1, positionComma);
                        int positionEnd = metricRemain.indexOf(")");
                        int accumulatorType = Integer.parseInt(metricRemain.substring(positionComma + 1, positionEnd));
                        traceName = btContext ? (metricPrefixName = "Business Segment|" + bizServiceName + "|" + bizTrxName + "|" + bizTrxCmpName + "|Browser") : (metricPrefixName = "Business Segment|" + urlName);
                        metricName = metricName.indexOf(":") > 0 ? (urlName != null && metricName.contains(urlName) ? "Business Segment|" + metricName : String.valueOf(metricPrefixName) + "|" + metricName) : String.valueOf(metricPrefixName) + ":" + metricName;
                        MetricHolder holder = new MetricHolder(metricName, metricValue, accumulatorType);
                        metricHolder.put(metricName, holder);
                    }
                    btContext = false;
                }
                this.reportTrace(trxTraceComponents, metricHolder, traceName, url);
            }
            ++i;
        }
        return true;
    }

    public void reportTrace(Map<String, String> trxTraceData, Map<String, MetricHolder> metricData, String traceName, String url) {
        long tDuration;
        long tStartTime;
        HashMap<String, String> params;
        block10: {
            params = new HashMap<String, String>();
            tStartTime = 0L;
            tDuration = 0L;
            try {
                tStartTime = Long.parseLong(trxTraceData.get("startTime"));
            }
            catch (Exception exception) {
                if (feedback.isDebugEnabled()) {
                    feedback.debug(BRTM_MODULE, "BrtmTracer: Could not get Transaction trace start time from the post parameter. Using System time");
                }
                tStartTime = System.currentTimeMillis();
            }
            try {
                tDuration = Long.parseLong(trxTraceData.get("duration"));
            }
            catch (Exception exception) {
                if (!feedback.isDebugEnabled()) break block10;
                feedback.debug(BRTM_MODULE, "BrtmTracer: Could not get Transaction trace duration from the post parameter.");
            }
        }
        if (tStartTime == 0L) {
            tStartTime = System.currentTimeMillis() - 47000L;
        }
        params.put("Trace Type", "Normal");
        if (trxTraceData != null) {
            for (Map.Entry<String, Object> entry : trxTraceData.entrySet()) {
                String key = entry.getKey();
                String value = (String)entry.getValue();
                if (value == null) continue;
                params.put(key, value);
            }
        }
        if (metricData != null) {
            for (Map.Entry<String, Object> entry : metricData.entrySet()) {
                entry.getKey();
                MetricHolder value = (MetricHolder)entry.getValue();
                if (value == null) continue;
                params.put(value.getMetricName(), value.getMetricValue());
            }
        }
        TransactionComponentData transactionComponentData = TransactionComponentData.createMilliSecTransactionComponentData((String)traceName, (long)tStartTime, (long)tDuration, params);
        this.sendTrace(transactionComponentData);
    }

    private void sendTrace(TransactionComponentData trace) {
        try {
            EnterpriseAgent agent = (EnterpriseAgent)AgentShim.getAgent();
            TransactionTraceController ttc = agent.getTransactionTraceController();
            ttc.ITransactionTraceListener_reportTransaction(trace);
        }
        catch (ThreadDeath e) {
            feedback.error(BRTM_MODULE, "Failed to send transaction trace: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            feedback.error(BRTM_MODULE, "Failed to send transaction trace: " + e.getMessage(), e);
        }
    }

    private Map getMethodAndArgClass(Object invocationDataObject, String methodName, int argCount, String methodDesc) {
        HashMap methodItemsMap = null;
        String innerKey = new StringBuffer().append(methodName).append(argCount).append(methodDesc).toString();
        if (this.invocationDataObjectToMethodMap.containsWeakKey(invocationDataObject) && (methodItemsMap = (HashMap)this.invocationDataObjectToMethodMap.getWeak(invocationDataObject)).containsKey(innerKey)) {
            Map methodItem = (Map)methodItemsMap.get(innerKey);
            if (feedback.isTraceEnabled()) {
                feedback.trace(BRTM_MODULE, "...getMethodAndArgClass... got invocationObject method/class from invocationDataObjectToMethodMap....");
                feedback.trace(BRTM_MODULE, "...getMethodAndArgClass... invocationDataObject class name =" + invocationDataObject.getClass().getName() + "... invocationDataObject classloader =" + invocationDataObject.getClass().getClassLoader().toString());
            }
            return methodItem;
        }
        Class<?> invocationDataObjectClasses = invocationDataObject.getClass();
        HashMap<String, Object> methodItem = new HashMap<String, Object>();
        int maxSearchCount = g_searchingMethodHierarchyMaxDepth;
        Method[] methods = null;
        while (invocationDataObjectClasses != null && maxSearchCount > 0) {
            methods = maxSearchCount == g_searchingMethodHierarchyMaxDepth ? (Method[])ArrayUtilities.append(invocationDataObjectClasses.getMethods(), invocationDataObjectClasses.getDeclaredMethods(), Method.class) : invocationDataObjectClasses.getDeclaredMethods();
            Method[] methodArray = methods;
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method i = methodArray[n2];
                if (methodName.equals(i.getName()) && i.getParameterTypes().length == argCount) {
                    Class<?>[] argClassArray = i.getParameterTypes();
                    try {
                        MethodName newMethod = MethodName.getMethodName(i, true);
                        if (methodDesc.equalsIgnoreCase(newMethod.getMethodDescriptor().toString())) {
                            methodItem.put("method", i);
                            methodItem.put("argClassArray", argClassArray);
                            if (methodItemsMap == null) {
                                methodItemsMap = new HashMap();
                            }
                            methodItemsMap.put(innerKey, methodItem);
                            this.invocationDataObjectToMethodMap.putWeak(invocationDataObject, methodItemsMap);
                            if (feedback.isTraceEnabled()) {
                                feedback.trace(BRTM_MODULE, "...getMethodAndArgClass... add new invocationObject method/class into invocationDataObjectToMethodMap....");
                                feedback.trace(BRTM_MODULE, "...getMethodAndArgClass... invocationDataObject class name =" + invocationDataObject.getClass().getName() + "... invocationDataObject classloader =" + invocationDataObject.getClass().getClassLoader().toString());
                            }
                            return methodItem;
                        }
                    }
                    catch (InvalidMethodDescriptorException e) {
                        feedback.error(BRTM_MODULE, "Failed to get Method: " + e.getMessage(), e);
                    }
                    catch (InvalidMethodNameException e) {
                        feedback.error(BRTM_MODULE, "Failed to get Method: " + e.getMessage(), e);
                    }
                }
                ++n2;
            }
            invocationDataObjectClasses = invocationDataObjectClasses.getSuperclass();
            --maxSearchCount;
        }
        return null;
    }

    private static final IWeakIdentityMap getCache(String policyName) {
        try {
            IAgent agent = AgentShim.getAgent();
            IConcurrentMapFactory mapFactory = agent.IAgent_getConcurrentMapFactory();
            return mapFactory.getConcurrentCappedWeakIdentityMap(policyName);
        }
        catch (AgentNotAvailableException agentNotAvailableException) {
            return null;
        }
    }

    private Object getURLWithQueryString(Object request, InvocationData invocationData, Object factoryObject, WrapperFactoryUtils wrapperFactoryUtil) {
        Object[] argArray = new Object[1];
        Class[] classArray = new Class[1];
        argArray[0] = request;
        classArray[0] = Object.class;
        Object result = BrtmTracer.invokeReturnsObject(factoryObject, invocationData, 3, argArray, classArray, wrapperFactoryUtil.getMethodCache());
        return result;
    }

    static class ASingleSharedMetricHolder
    implements ISharedMetricHolder,
    ASingleMetricTracerFactory.ISingleMetricHolder {
        static ConcurrentHashMap<String, ConcurrentHashMap<String, IRepository>> metricRepositoryArrayMap;
        AAgentMetricArray metric;
        IRepository rep;

        public ASingleSharedMetricHolder() {
            metricRepositoryArrayMap = new ConcurrentHashMap();
        }

        public ConcurrentHashMap getRepositories(String metricURL) {
            return metricRepositoryArrayMap.get(metricURL);
        }

        public int getRepositorySize() {
            return metricRepositoryArrayMap.size();
        }

        public Map setAndGetRepositories(String metricURL, ConcurrentHashMap repositories) {
            return metricRepositoryArrayMap.putIfAbsent(metricURL, repositories);
        }

        public AgentMetric getSingleMetric() {
            if (this.metric == null) {
                return null;
            }
            return (AgentMetric)this.metric.getMetrics()[0];
        }

        public void addMetric(AgentMetric addedMetric, IRepository structure) {
            this.rep = structure;
            this.metric = AAgentMetricArray.getInstance((AgentMetric)addedMetric);
        }

        public void addMetric(AgentMetric[] addedMetric, IRepository structure) {
            this.rep = structure;
            this.metric = AAgentMetricArray.getInstance((AgentMetric[])addedMetric);
        }

        public IRepository getRepository() {
            return this.rep;
        }

        public IMetricHolder getCorrespondingMetricHolder() {
            return new ASingleSharedMetricMetricHolder(this);
        }
    }

    static class ASingleSharedMetricMetricHolder
    extends ASingleSharedMetricHolder
    implements IMetricHolder {
        ASingleSharedMetricMetricHolder(ASingleSharedMetricHolder seed) {
            this.addMetric(seed.getSingleMetric(), seed.rep);
        }

        public Iterator getMetrics() {
            return Collections.EMPTY_MAP.entrySet().iterator();
        }
    }

    static final class Updater
    implements IUpdater {
        Updater() {
        }

        public final void update(IGathererElement element, long value, long startTime, long endTime) {
            element.combineValue(value);
            element.combineTime(startTime);
        }

        public final void update(IGathererElement repository, long value, long time) {
            repository.combineValue(value);
            repository.combineTime(time);
        }
    }
}

