/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.brtm.utilities;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.IAgent;
import com.wily.util.io.ExtendedFile;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.resource.FileBasedResource;
import com.wily.util.resource.IResource;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;

public class WrapperUtils {
    private static IAgent fAgent;
    public static HashMap wsdmClassLoaders;
    public static final String customClassloaderJar = "BrtmExt.jar";
    private static final String kLineSeparatorPropertyName = "line.separator";

    static {
        wsdmClassLoaders = new HashMap();
    }

    public static URLClassLoader createClassLoader(ClassLoader parent, String customClassLoaderJarFile, IAgent agent) throws MalformedURLException, AgentNotAvailableException {
        fAgent = agent;
        URLClassLoader urlClassLoader = null;
        IResource resource = null;
        String directoryProperty = (String)agent.IAgent_getIndexedProperties().get("introscope.agent.extensions.directory");
        resource = ExtendedFile.isAbsolutePath(directoryProperty) ? WrapperUtils.getDirFinder(WrapperUtils.getExtensionDirectory(), customClassLoaderJarFile) : WrapperUtils.getDirFinder(String.valueOf(WrapperUtils.getAbsoluteAgentPath()) + File.separator + WrapperUtils.getExtensionDirectory() + File.separator, customClassLoaderJarFile);
        URL[] urlResources = new URL[]{resource.IResource_getURL()};
        urlClassLoader = new URLClassLoader(urlResources, parent);
        return urlClassLoader;
    }

    public static String getAbsoluteAgentPath() {
        String path = "";
        IResource profileResource = fAgent.IAgent_getConfigurationResource();
        if (profileResource.IResource_isFileResource()) {
            File profileDirectory = new File(profileResource.IResource_getLocation()).getParentFile();
            File pathFile = new File(profileDirectory, path);
            path = pathFile.getAbsolutePath();
        }
        return path;
    }

    public static IResource getDirFinder(String directoryName, String fileName) {
        ExtendedFile wilyDirectory = new ExtendedFile(directoryName);
        String fullPath = new ExtendedFile(wilyDirectory, fileName).safeGetCanonicalPath();
        return new FileBasedResource(fullPath);
    }

    public static String getExtensionDirectory() {
        String extFolder = "";
        try {
            IndexedProperties props = WrapperUtils.getAgentConfiguration();
            extFolder = props.getTrimmedProperty("introscope.agent.extensions.directory");
        }
        catch (AgentNotAvailableException bomb) {
            fAgent.IAgent_getModuleFeedback().error("getExtensionDirectory " + WrapperUtils.dumpStackTrace(bomb));
        }
        return extFolder;
    }

    public static IndexedProperties getAgentConfiguration() throws AgentNotAvailableException {
        return fAgent.IAgent_getIndexedProperties();
    }

    public static String dumpStackTrace(Throwable bomb) {
        StackTracePrintStream stack = new StackTracePrintStream((OutputStream)new ByteArrayOutputStream(), 1024);
        bomb.printStackTrace(stack);
        return stack.getString();
    }

    private static class StackTracePrintStream
    extends PrintStream {
        private final char[] fLineSeparator = System.getProperty("line.separator").toCharArray();
        private int fCursor = 0;
        private char[] fChars;
        private int fCharCount;

        public StackTracePrintStream(OutputStream dummy, int initialSize) {
            super(dummy);
            this.fChars = new char[initialSize];
            this.fCharCount = initialSize;
        }

        @Override
        public synchronized void print(char[] data) {
            while (this.fCursor + data.length > this.fCharCount) {
                this.growBuffer();
            }
            System.arraycopy(data, 0, this.fChars, this.fCursor, data.length);
            this.fCursor += data.length;
        }

        @Override
        public synchronized void print(String s) {
            if (s == null) {
                s = "null";
            }
            int length = s.length();
            while (this.fCursor + length > this.fCharCount) {
                this.growBuffer();
            }
            s.getChars(0, length, this.fChars, this.fCursor);
            this.fCursor += length;
        }

        @Override
        public synchronized void print(Object obj) {
            this.print(String.valueOf(obj));
        }

        @Override
        public synchronized void println(char[] data) {
            this.print(data);
            this.printSeparator();
        }

        @Override
        public synchronized void println(String s) {
            this.print(s);
            this.printSeparator();
        }

        @Override
        public synchronized void println(Object obj) {
            this.print(obj);
            this.printSeparator();
        }

        @Override
        public synchronized void println() {
            this.printSeparator();
        }

        private void printSeparator() {
            this.print(this.fLineSeparator);
        }

        private void growBuffer() {
            int newSize = this.fCharCount * 2;
            char[] newBuffer = new char[newSize];
            System.arraycopy(this.fChars, 0, newBuffer, 0, this.fCharCount);
            this.fCharCount = newSize;
            this.fChars = newBuffer;
        }

        public String getString() {
            return new String(this.fChars, 0, this.fCursor);
        }

        public void reset() {
            this.fCursor = 0;
        }

        @Override
        public void flush() {
        }
    }
}

